/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rapidEye.comm.req.events;

import com.honeywell.rapidEyeObjects.REDateTime;
import com.honeywell.rapidEyeObjects.REEventQueryRequest;
import com.honeywell.rapidEyeObjects.REEventQueryResponse;
import com.honeywell.rapidEyeObjects.REEventQueryResultRequest;
import com.honeywell.rapidEyeObjects.REEventQueryResultResponse;
import com.honeywell.rapidEyeObjects.RESensor;
import com.honeywell.rapidEyeObjects.RESensors;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfTransmitAckResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfVideo.comm.req.BDdfRefreshEventsReq;
import com.tridium.ddfVideo.comm.rsp.BIDdfRefreshEventsRsp;
import com.tridium.rapidEye.comm.BRapidEyeTcpCommunicator;
import com.tridium.rapidEye.comm.req.events.BIRapidEyeEventTcpRequest;
import com.tridium.rapidEye.comm.rsp.BRapidEyeEventListRefreshResponse;
import com.tridium.rapidEye.identify.BRapidEyeCameraId;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRapidEyeEventListRefreshRequest
extends BDdfRefreshEventsReq
implements BIRapidEyeEventTcpRequest,
BIDdfMultiFrameResponse,
BIDdfTransmitAckResponse {
    public static final Type TYPE;
    BRapidEyeTcpCommunicator tcpCom;
    int progressPercentage;
    boolean complete;
    RESensors mainsensors;
    int totalNumber;
    BAbsTime fromTime;
    BAbsTime toTime;
    boolean resultRequested;
    Vector completeResult;
    static /* synthetic */ Class class$com$tridium$rapidEye$comm$req$events$BRapidEyeEventListRefreshRequest;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        if (iDdfDataFrame.getFrameBytes()[0] != 9) {
            REEventQueryResultResponse rEEventQueryResultResponse = new REEventQueryResultResponse();
            try {
                Vector vector = rEEventQueryResultResponse.fromBuffer(new ByteBuffer(iDdfDataFrame.getFrameBytes()), this.mainsensors);
                if (vector != null && vector.size() > 0) {
                    int n = 0;
                    while (n < vector.size()) {
                        this.completeResult.add(vector.get(n));
                        ++n;
                    }
                    this.resultRequested = false;
                } else {
                    if (vector == null) {
                        this.resultRequested = true;
                        return this.processReceiveEvents(iDdfDataFrame);
                    }
                    this.resultRequested = true;
                }
            }
            catch (IOException iOException) {
                this.complete = true;
                iOException.printStackTrace();
                throw new DdfResponseException("Cannot get the data");
            }
            return this;
        }
        REEventQueryResponse rEEventQueryResponse = new REEventQueryResponse();
        try {
            this.totalNumber = rEEventQueryResponse.fromBuffer(new ByteBuffer(iDdfDataFrame.getFrameBytes()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.resultRequested = false;
        return this;
    }

    public BIDdfRefreshEventsRsp processReceiveEvents(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        this.complete = true;
        if (this.completeResult.size() <= 0) {
            throw new DdfResponseException(" No events during " + this.fromTime.toLocalTime() + " > " + this.toTime.toLocalTime());
        }
        return new BRapidEyeEventListRefreshResponse(this.completeResult);
    }

    public byte[] toByteArray() {
        Object object;
        BAbsTime bAbsTime;
        ByteBuffer byteBuffer = new ByteBuffer();
        BRelTime bRelTime = this.tcpCom.getMainCommunicator().getHoneywellDvr().getDurationForEvents();
        this.complete = false;
        REEventQueryRequest rEEventQueryRequest = new REEventQueryRequest();
        BAbsTime bAbsTime2 = this.getRetrieveActionParam().getTimeIndex().timeEquals(BAbsTime.NULL) ? BAbsTime.now() : this.getRetrieveActionParam().getTimeIndex();
        if (this.fromTime != null) {
            bAbsTime2 = this.fromTime;
        }
        if (this.getRetrieveActionParam().getNumEvents() < 0) {
            bAbsTime = bAbsTime2.subtract(bRelTime);
            object = BAbsTime.make((long)bAbsTime.getMillis());
            bAbsTime = BAbsTime.make((long)bAbsTime2.getMillis());
            bAbsTime2 = object;
        } else {
            bAbsTime = bAbsTime2.add(bRelTime);
        }
        this.fromTime = bAbsTime2;
        this.toTime = bAbsTime;
        object = new REDateTime(bAbsTime2.getMillis() / 1000L, 0L);
        REDateTime rEDateTime = new REDateTime(bAbsTime.getMillis() / 1000L, 0L);
        Vector vector = this.buildSensorsList();
        rEEventQueryRequest.toBuffer(byteBuffer, vector, (REDateTime)object, rEDateTime);
        return byteBuffer.toByteArray();
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
        if (this.completeResult.size() >= 20) {
            this.isFinalEffort = false;
        }
        super.processResponse(bIDdfResponse);
        if (this.getRetrieveActionParam().getNumEvents() < 0) {
            this.getRetrieveActionParam().setTimeIndex(this.fromTime);
        } else {
            this.getRetrieveActionParam().setTimeIndex(this.toTime);
        }
    }

    public void setCommunicator(BRapidEyeTcpCommunicator bRapidEyeTcpCommunicator) {
        this.tcpCom = bRapidEyeTcpCommunicator;
    }

    public String getPassword() {
        return null;
    }

    public String getUserName() {
        return null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] getBytes() {
        if (this.resultRequested) {
            return null;
        }
        REEventQueryResultRequest rEEventQueryResultRequest = new REEventQueryResultRequest();
        ByteBuffer byteBuffer = new ByteBuffer();
        rEEventQueryResultRequest.toBuffer(byteBuffer, 0, 0);
        this.resultRequested = true;
        return byteBuffer.toByteArray();
    }

    public Vector buildSensorsList() {
        Vector<RESensor> vector = new Vector<RESensor>();
        this.mainsensors = this.tcpCom.getMainCommunicator().getAlarmTcpCommunicator().getSensors();
        Iterator iterator = this.mainsensors.iterator();
        while (iterator.hasNext()) {
            RESensor rESensor = (RESensor)iterator.next();
            if (rESensor.sensor_id / 2 != ((BRapidEyeCameraId)this.getDeviceId()).getCameraId() && rESensor.sensor_id != ((BRapidEyeCameraId)this.getDeviceId()).getCameraId() + 1999 || rESensor.event_id != 700 && rESensor.event_id != 701 && rESensor.event_id != 1000 && rESensor.event_id != 1001 && rESensor.event_id != 900 && rESensor.event_id != 901 && rESensor.event_id != 902 && rESensor.event_id != 903 && rESensor.event_id != 904 && rESensor.event_id != 905 && rESensor.event_id != 906 && rESensor.event_id != 907) continue;
            vector.add(rESensor);
        }
        return vector;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.progressPercentage = 0;
        this.complete = false;
        this.mainsensors = null;
        this.totalNumber = 0;
        this.fromTime = null;
        this.toTime = null;
        this.resultRequested = true;
        this.completeResult = new Vector();
    }

    public BRapidEyeEventListRefreshRequest() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$rapidEye$comm$req$events$BRapidEyeEventListRefreshRequest;
        if (clazz == null) {
            clazz = class$com$tridium$rapidEye$comm$req$events$BRapidEyeEventListRefreshRequest = BRapidEyeEventListRefreshRequest.class("[Lcom.tridium.rapidEye.comm.req.events.BRapidEyeEventListRefreshRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

