/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanJvln;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.pciCards.BPciCard;
import com.tridium.platHwScan.pciCards.BPciSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJvlnBoard
extends BBaseBoard {
    public static final Property LAN1 = BJvlnBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    public static final Property LAN2 = BJvlnBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    public static final Property COM1 = BJvlnBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    public static final Property COM2 = BJvlnBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    public static final Property optionSlot1 = BJvlnBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    public static final Property optionSlot2 = BJvlnBoard.newProperty((int)1, (BValue)new BOptionSlot(2), null);
    public static final Property pciSlot = BJvlnBoard.newProperty((int)1, (BValue)new BPciSlot(), null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String BASE_BOARD_CODE = "04";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 5;
    private static final int HARDWARE_REF_COUNT = 12;
    static /* synthetic */ Class class$com$tridium$platHwScanJvln$BJvlnBoard;
    static /* synthetic */ Class class$com$tridium$platHwScan$ports$BPort;

    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    public void setLAN1(BEthernetPort bEthernetPort) {
        this.set(LAN1, (BValue)bEthernetPort, null);
    }

    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    public void setLAN2(BEthernetPort bEthernetPort) {
        this.set(LAN2, (BValue)bEthernetPort, null);
    }

    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    public void setCOM1(BPort bPort) {
        this.set(COM1, (BValue)bPort, null);
    }

    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    public void setCOM2(BPort bPort) {
        this.set(COM2, (BValue)bPort, null);
    }

    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    public void setOptionSlot1(BOptionSlot bOptionSlot) {
        this.set(optionSlot1, (BValue)bOptionSlot, null);
    }

    public BOptionSlot getOptionSlot2() {
        return (BOptionSlot)this.get(optionSlot2);
    }

    public void setOptionSlot2(BOptionSlot bOptionSlot) {
        this.set(optionSlot2, (BValue)bOptionSlot, null);
    }

    public BPciSlot getPciSlot() {
        return (BPciSlot)this.get(pciSlot);
    }

    public void setPciSlot(BPciSlot bPciSlot) {
        this.set(pciSlot, (BValue)bPciSlot, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array array, boolean bl) {
        this.simulation = bl;
        this.setProductModel(lex.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts(bl);
        this.nextSerialPort = 5;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)array.get(0), (String)array.get(1));
        this.configureOptionSlot(this.getOptionSlot2(), (String)array.get(2), (String)array.get(3));
        this.configurePciSlot();
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector getHardwareRefs() {
        Vector<Object> vector = new Vector<Object>();
        int n = 1;
        while (n <= 12) {
            switch (n) {
                case 1: 
                case 2: {
                    BOptionSlot bOptionSlot = n == 1 ? this.getOptionSlot1() : this.getOptionSlot2();
                    vector.addElement(this.makeSlotRef(n, bOptionSlot));
                    if (bOptionSlot.isEmpty()) break;
                    BPciSlot bPciSlot = (BOptionCard)bOptionSlot.getContents();
                    bPciSlot.lease(1);
                    Class clazz = class$com$tridium$platHwScan$ports$BPort;
                    if (clazz == null) {
                        clazz = BJvlnBoard.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
                    }
                    BPort[] bPortArray = (BPort[])bPciSlot.getChildren(clazz);
                    int n2 = 0;
                    while (n2 < bPortArray.length) {
                        vector.addElement(this.makePortRef(n, n2 + 1, bPortArray[n2]));
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    vector.addElement(this.makeJumperRef(n));
                    break;
                }
                case 4: {
                    BPciSlot bPciSlot = this.getPciSlot();
                    BPort[] bPortArray = new BHardwareRef();
                    bPortArray.setReference(String.valueOf(n));
                    bPortArray.setLocation(lex.getText("HardwareRef.pciSlot"));
                    BValue bValue = bPciSlot.getContents();
                    bPortArray.setDescription(bPciSlot.isEmpty() ? ((BHwScanStatusEnum)bValue).getTag() : ((BPciCard)bValue).getDescription());
                    vector.addElement(bPortArray);
                    break;
                }
                case 5: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM2()));
                    break;
                }
                case 6: {
                    vector.addElement(this.makeBaseboardCommRef(n, this.getCOM1()));
                    break;
                }
                case 7: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.externalBatteryBackup")));
                    break;
                }
                case 8: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.contactInputs")));
                    break;
                }
                case 9: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN1()));
                    break;
                }
                case 10: {
                    vector.addElement(this.makeBaseboardCommRef(n, (BPort)this.getLAN2()));
                    break;
                }
                case 11: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.electricalGround")));
                    break;
                }
                case 12: {
                    vector.addElement(new BHardwareRef(n, this.getBaseUnitText(), lex.getText("HardwareRef.antennaKnockouts")));
                    break;
                }
            }
            ++n;
        }
        return vector;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject bObject) {
        return lex.getText(VIEW);
    }

    private final void configurePciSlot() {
        BPciSlot bPciSlot = this.getPciSlot();
        try {
            Hashtable hashtable = BPciCard.getCardCatalog();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                BPciCard bPciCard = (BPciCard)enumeration.nextElement();
                File file = new File(bPciCard.getLocator());
                if (!file.exists()) continue;
                bPciSlot.addCard((BPciCard)bPciCard.newCopy(true));
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bPciSlot.isEmpty()) {
            bPciSlot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    public void configureOptionSlot(BOptionSlot bOptionSlot, String string, String string2) {
        bOptionSlot.removeAll();
        if (!string.equalsIgnoreCase("FF") || !string2.equalsIgnoreCase("FF")) {
            BOptionCard bOptionCard = BOptionCard.lookup((String)(string + ' ' + string2));
            if (bOptionCard == null) {
                bOptionSlot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{string, string2})));
            } else {
                BOptionCard bOptionCard2 = (BOptionCard)bOptionCard.newCopy(true);
                bOptionSlot.addCard(bOptionCard2);
                BPort[] bPortArray = bOptionCard2.getPorts();
                int n = 0;
                while (n < bPortArray.length) {
                    if (bPortArray[n] != null) {
                        BPort bPort = bPortArray[n];
                        if (bOptionCard2.getUsesCom()) {
                            bOptionCard2.rename(bOptionCard2.getProperty(bPort.getName()), bPort.getPrefix() + (bOptionSlot.getSlotNumber() + 2), null);
                        } else {
                            bOptionCard2.rename(bOptionCard2.getProperty(bPort.getName()), this.makePortName(n + 1, bPort.getPrefix()), null);
                        }
                        if (!this.simulation) {
                            bPort.initOwnerAndStatus();
                        }
                    }
                    ++n;
                }
            }
        }
        if (bOptionSlot.isEmpty()) {
            bOptionSlot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private final void initializeStandardPorts(boolean bl) {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + '1')), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + '2')), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + '1')), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + '2')), null);
        if (!bl) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platHwScanJvln$BJvlnBoard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScanJvln$BJvlnBoard = BJvlnBoard.class("[Lcom.tridium.platHwScanJvln.BJvlnBoard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$platHwScanJvln$BJvlnBoard;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platHwScanJvln$BJvlnBoard = BJvlnBoard.class("[Lcom.tridium.platHwScanJvln.BJvlnBoard;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

