/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfVideo.comm.req.BDdfVideoStreamRequest;
import com.tridium.milestone.BMilestoneCamera;
import com.tridium.milestone.comm.BMilestoneCameraCommunicator;
import com.tridium.milestone.comm.req.ImageServerApiTcpRtfReq;
import com.tridium.milestone.comm.req.MilestoneReqUtil;
import com.tridium.milestone.identify.BMilestoneCameraId;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMilestoneVideoStreamReq
extends BDdfVideoStreamRequest
implements ImageServerApiTcpRtfReq {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$req$BMilestoneVideoStreamReq == null ? (class$com$tridium$milestone$comm$req$BMilestoneVideoStreamReq = BMilestoneVideoStreamReq.class$("com.tridium.milestone.comm.req.BMilestoneVideoStreamReq")) : class$com$tridium$milestone$comm$req$BMilestoneVideoStreamReq));
    public static final int[] SLOW_FWD_RWD_FACTOR_ARRAY = new int[]{90, 80, 70, 60, 50, 40, 30, 20, 10, 5};
    public static final int[] FFWD_RWD_FACTOR_ARRAY = new int[]{200, 400, 600, 800, 1000, 3000, 6000, 60000, 120000, 240000};
    protected MilestonePlaybackInputStream playbackInputStream;
    protected Socket videoSocket;
    private int requestId = -1;
    static /* synthetic */ Class class$com$tridium$milestone$comm$req$BMilestoneVideoStreamReq;

    public Type getType() {
        return TYPE;
    }

    public int getRequestId() {
        if (this.requestId == -1) {
            this.requestId = BMilestoneCameraCommunicator.getNextVideoRequestId();
        }
        return this.requestId;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    public String getMilestoneCameraId() {
        BMilestoneCameraId bMilestoneCameraId = (BMilestoneCameraId)this.getDeviceId();
        return bMilestoneCameraId.getCameraId();
    }

    public void consumeXmlReply(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        while (!(n == 10 && n2 == 10 || n2 == 10 && n3 == 10 || n3 == 10 && n4 == 10 || n == 13 && n2 == 10 && n3 == 13 && n4 == 10)) {
            n = n2;
            n2 = n3;
            n3 = n4;
            n4 = inputStream.read();
        }
    }

    public void setVideoSocket(Socket socket) {
        this.videoSocket = socket;
    }

    public IVideoStream makeVideoStream() {
        if (this.videoSocket == null) {
            return null;
        }
        BPlaybackParams bPlaybackParams = this.getPlaybackParams();
        if (bPlaybackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            try {
                return new MilestoneLiveVideoStream();
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException((Throwable)iOException);
            }
        }
        try {
            this.playbackInputStream = new MilestonePlaybackInputStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new MilestonePlaybackStream();
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        return null;
    }

    protected String getMilestoneCompressionRate() {
        BVideoCompressionEnum bVideoCompressionEnum = this.playbackParams.getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.none) {
            return "100";
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.low) {
            return "66";
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.medium) {
            return "33";
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            return "100";
        }
        throw new IllegalStateException("Unrecognized videoCompressionEnum: " + bVideoCompressionEnum + ". Please have my program fixed.");
    }

    protected String getMilestoneFrameRate() {
        BPlaybackParams bPlaybackParams = this.getPlaybackParams();
        BVideoFrameRateEnum bVideoFrameRateEnum = bPlaybackParams.getFrameRate();
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.high) {
            return "full";
        }
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.medium) {
            return "medium";
        }
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.low) {
            return "low";
        }
        return "full";
    }

    public byte[] toByteArray() {
        BPlaybackParams bPlaybackParams = this.getPlaybackParams();
        if (bPlaybackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + this.getRequestId() + "</requestid>" + "<methodname>live</methodname>" + "<sendinitialimage>no</sendinitialimage>";
            if (bPlaybackParams.getCompression() != BVideoCompressionEnum.high) {
                string = string + "<compressionrate>" + this.getMilestoneCompressionRate() + "</compressionrate>";
            }
            string = string + "<attributes FrameRate=\"" + this.getMilestoneFrameRate() + "\"/>" + "</methodcall>\r\n\r\n";
            return string.getBytes();
        }
        long l = bPlaybackParams.getTimeIndex().getMillis();
        return this.getGotoReqXml(l);
    }

    public String getGotoReqXmlString(long l) {
        String string = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + BMilestoneCameraCommunicator.getNextVideoRequestId() + "</requestid>" + "<methodname>goto</methodname>");
        string = this.getMilestoneCompressionRate() != "100" ? string + "<compressionrate>" + this.getMilestoneCompressionRate() + "</compressionrate>" : string + "<compressionrate>90</compressionrate>";
        string = string + "<time>" + l + "</time>" + "</methodcall>\r\n\r\n";
        return string;
    }

    public byte[] getGotoReqXml(long l) {
        return this.getGotoReqXmlString(l).getBytes();
    }

    public BMilestoneCamera getMilestoneCamera() {
        return (BMilestoneCamera)this.getVideoSource();
    }

    public String getLiveConnectXml(String string, String string2, boolean bl) {
        if (this.getMilestoneCamera().getMilestoneDatabaseId().length() == 0) {
            try {
                this.getMilestoneCamera().doPing();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return MilestoneReqUtil.getCameraConnectXml(string, string2, this.getMilestoneCamera().getMilestoneDatabaseId(), bl);
    }

    public void setCommunicator(BMilestoneCameraCommunicator bMilestoneCameraCommunicator) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MilestoneLiveVideoStream
    implements IVideoStream {
        public MilestoneLiveVideoStream() throws IOException {
            BMilestoneVideoStreamReq.this.consumeXmlReply(BMilestoneVideoStreamReq.this.videoSocket.getInputStream());
        }

        public void closeVideoStream() throws IOException {
            BMilestoneVideoStreamReq.this.videoSocket.close();
        }

        public InputStream getInputStream() {
            try {
                return BMilestoneVideoStreamReq.this.videoSocket.getInputStream();
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException((Throwable)iOException);
            }
        }

        public BPlaybackParams getPlaybackParams() {
            return BMilestoneVideoStreamReq.this.getPlaybackParams();
        }
    }

    public class MilestonePlaybackInputStream
    extends InputStream {
        protected InputStream videoSocketInput;
        protected ByteBuffer headerBuf;
        protected int contentLength = -1;
        protected int remainingContentBytes = -1;
        protected long frameMillis = -1L;
        protected long lastRequestedMillis = -1L;
        protected long nextFrameMillis = Long.MIN_VALUE;
        protected long prevFrameMillis = Long.MAX_VALUE;
        protected boolean paused = false;
        protected long ticksBeforeRequestingFrameInPlaybackMode = -1L;
        protected boolean firstHeader = true;
        public long lastDelta = -1L;

        public MilestonePlaybackInputStream() throws IOException {
            this.videoSocketInput = BMilestoneVideoStreamReq.this.videoSocket.getInputStream();
            this.headerBuf = new ByteBuffer();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                return this.headerBuf.read(byArray, n, n2);
            }
            if (this.remainingContentBytes > 0) {
                int n3 = this.videoSocketInput.read(byArray, n, n2);
                if (n3 > 0) {
                    this.remainingContentBytes -= n3;
                    if (this.remainingContentBytes <= 0) {
                        this.requestNextFrame();
                    }
                } else {
                    this.requestNextFrame();
                }
                return n3;
            }
            this.readVideoFrameHeader();
            return this.headerBuf.read(byArray, n, n2);
        }

        public int read() throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                int n = this.headerBuf.read();
                return n;
            }
            if (this.remainingContentBytes > 0) {
                if (this.remainingContentBytes == this.contentLength) {
                    // empty if block
                }
                --this.remainingContentBytes;
                int n = this.videoSocketInput.read();
                if (n != -1 && this.remainingContentBytes == 0) {
                    this.requestNextFrame();
                }
                return n;
            }
            this.readVideoFrameHeader();
            int n = this.headerBuf.read();
            return n;
        }

        public void requestNextFrame() throws IOException {
            long l = -1L;
            long l2 = 100L;
            if (this.lastRequestedMillis == -1L) {
                this.lastRequestedMillis = this.frameMillis;
            }
            long l3 = Clock.ticks();
            if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play) {
                l = this.frameMillis + 100L;
                if (l < this.nextFrameMillis) {
                    l = this.nextFrameMillis;
                }
                this.ticksBeforeRequestingFrameInPlaybackMode = Clock.ticks();
                l2 = 0L;
            } else if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastFwd) {
                l = this.frameMillis + (long)FFWD_RWD_FACTOR_ARRAY[BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (l < this.nextFrameMillis) {
                    l = this.nextFrameMillis;
                }
            } else if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowFwd) {
                l = this.lastRequestedMillis + (long)SLOW_FWD_RWD_FACTOR_ARRAY[BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (l < this.nextFrameMillis && l - this.nextFrameMillis > 2000L) {
                    l = this.nextFrameMillis;
                }
            } else if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastRew) {
                l = this.frameMillis - (long)FFWD_RWD_FACTOR_ARRAY[BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (l > this.prevFrameMillis) {
                    l = this.prevFrameMillis;
                }
            } else if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowRew) {
                l = this.lastRequestedMillis - (long)SLOW_FWD_RWD_FACTOR_ARRAY[BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (l > this.prevFrameMillis && l - this.prevFrameMillis > 2000L) {
                    l = this.prevFrameMillis;
                }
            } else {
                if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.pause) {
                    this.paused = true;
                    return;
                }
                throw new IllegalStateException("The program should not have flowed to this line of code. Please have my program fixed.");
            }
            String string = BMilestoneVideoStreamReq.this.getGotoReqXmlString(l);
            this.lastRequestedMillis = l;
            BMilestoneVideoStreamReq.this.videoSocket.getOutputStream().write(string.getBytes());
            BMilestoneVideoStreamReq.this.videoSocket.getOutputStream().flush();
            long l4 = Clock.ticks();
            long l5 = l2 - (l4 - l3);
            if (l5 > 10L) {
                try {
                    Thread.sleep(l2 - (l4 - l3));
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException("Interrupted while sleeping to simulate the real time Milestone video stream.");
                }
            }
        }

        protected String readHeaderLine() throws IOException {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n = this.videoSocketInput.read();
            int n3 = -1;
            while (n2 != 10 || n3 != 13) {
                if (n == -1) {
                    throw new EOFException("End of video input stream while reading line of text.");
                }
                this.headerBuf.write(n);
                stringBuffer.append((char)n);
                n = this.videoSocketInput.read();
                n3 = n2;
                n2 = n;
            }
            this.headerBuf.write(n);
            String string = stringBuffer.toString().trim();
            return string;
        }

        public void readVideoFrameHeader() throws IOException {
            this.contentLength = -1;
            this.remainingContentBytes = -1;
            String string = this.readHeaderLine();
            boolean bl = false;
            if (this.firstHeader) {
                bl = true;
                this.firstHeader = false;
            }
            while (!bl || string != null && string.length() > 0) {
                if (string.startsWith("Content-length:")) {
                    this.remainingContentBytes = this.contentLength = Integer.parseInt(string.substring(15).trim());
                } else if (!bl && string.startsWith("ImageResponse")) {
                    bl = true;
                } else if (string.startsWith("Current:")) {
                    this.frameMillis = Long.parseLong(string.substring(8).trim());
                } else if (string.startsWith("Next:")) {
                    this.nextFrameMillis = Long.parseLong(string.substring(5).trim());
                } else if (string.startsWith("Prev:")) {
                    this.prevFrameMillis = Long.parseLong(string.substring(5).trim());
                }
                string = this.readHeaderLine();
            }
            if (BMilestoneVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play && this.ticksBeforeRequestingFrameInPlaybackMode >= 0L) {
                try {
                    long l = Clock.ticks() - this.ticksBeforeRequestingFrameInPlaybackMode;
                    long l2 = this.frameMillis - this.prevFrameMillis - l;
                    if (l2 > 1000L) {
                        l2 = 1000L;
                    }
                    if (l2 > 10L) {
                        Thread.sleep(Math.round((double)l2 * 0.8));
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException("Interrupted while sleeping to simulated Milestone playback timing.");
                }
            }
            if (this.contentLength == -1) {
                throw new IllegalStateException("Error reading milestone image header. Please have my program fixed.");
            }
        }
    }

    public class MilestonePlaybackStream
    implements IVideoStream {
        public void closeVideoStream() throws IOException {
            BMilestoneVideoStreamReq.this.videoSocket.close();
        }

        public InputStream getInputStream() {
            return BMilestoneVideoStreamReq.this.playbackInputStream;
        }

        public BPlaybackParams getPlaybackParams() {
            return BMilestoneVideoStreamReq.this.getPlaybackParams();
        }
    }
}

