/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.milestone.comm.BMilestoneCameraCommunicator;
import com.tridium.milestone.comm.req.ImageServerApiTcpRtfReq;
import com.tridium.milestone.comm.req.MilestoneReqUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BMilestoneCameraConnectReq
extends BDdfRequest
implements ImageServerApiTcpRtfReq,
BIDdfCustomRequest {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$req$BMilestoneCameraConnectReq == null ? (class$com$tridium$milestone$comm$req$BMilestoneCameraConnectReq = BMilestoneCameraConnectReq.class$("com.tridium.milestone.comm.req.BMilestoneCameraConnectReq")) : class$com$tridium$milestone$comm$req$BMilestoneCameraConnectReq));
    protected BMilestoneCameraCommunicator communicator;
    protected String userName;
    protected String password;
    protected String milestoneDatabaseId;
    protected boolean alwaysJpeg = false;
    static /* synthetic */ Class class$com$tridium$milestone$comm$req$BMilestoneCameraConnectReq;

    public Type getType() {
        return TYPE;
    }

    public BMilestoneCameraConnectReq() {
    }

    public BMilestoneCameraConnectReq(String string, String string2, String string3, boolean bl) {
        this.userName = string;
        this.password = string2;
        this.milestoneDatabaseId = string3;
        this.alwaysJpeg = bl;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            XElem xElem = MilestoneReqUtil.getElem(iDdfDataFrame, "methodresponse");
            String string = MilestoneReqUtil.getText(xElem, "connected");
            String string2 = MilestoneReqUtil.getText(xElem, "alwaysstdjpeg");
            if (string.equals("yes")) {
                this.communicator.setMilestonePtzConnectionEstablished(true);
                if (string2.equals("no")) {
                    // empty if block
                }
                return new BDdfResponse();
            }
            throw new DdfResponseException("Milestone Camera Connection Was Denied: \"" + string + "\"");
        }
        catch (Exception exception) {
            throw new DdfResponseException("Error Parsing Milestone Camera Connection Response", (Throwable)exception);
        }
    }

    public byte[] toByteArray() {
        return MilestoneReqUtil.getCameraConnectXml(this.userName, this.password, this.milestoneDatabaseId, this.alwaysJpeg).getBytes();
    }

    public void setCommunicator(BMilestoneCameraCommunicator bMilestoneCameraCommunicator) {
        this.communicator = bMilestoneCameraCommunicator;
    }

    public void processErrorResponse(DdfResponseException ddfResponseException) {
        this.communicator.setMilestonePtzConnectionEstablished(false);
    }

    public void processLateResponse(BIDdfResponse bIDdfResponse) {
        this.communicator.setMilestonePtzConnectionEstablished(true);
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
        this.communicator.setMilestonePtzConnectionEstablished(true);
    }

    public void processTimeout() {
        this.communicator.setMilestonePtzConnectionEstablished(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

