/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm;

import com.tridium.ddf.clock.BDdfScheduler;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfIp.tcp.comm.TcpSocketManager;
import com.tridium.ddfVideo.event.BDdfVideoEventStatus;
import com.tridium.milestone.BMilestoneCamera;
import com.tridium.milestone.BMilestoneDvr;
import com.tridium.milestone.comm.BMilestoneDvrTcpCommunicator;
import com.tridium.milestone.comm.req.BMilestoneCentralLoginReq;
import com.tridium.milestone.comm.req.MilestoneReqUtil;
import com.tridium.milestone.event.BMilestoneEventCameraExt;
import com.tridium.milestone.event.BMilestoneEventPointId;
import com.tridium.milestone.event.BMilestoneEventProxyExt;
import com.tridium.milestone.event.BMilestoneEventTypeEnum;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BMilestoneDvrTcpUnsolicitedMgr
extends BDdfUnsolicitedMgr {
    public static final Action aliveIntervalExpired = BMilestoneDvrTcpUnsolicitedMgr.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$BMilestoneDvrTcpUnsolicitedMgr == null ? (class$com$tridium$milestone$comm$BMilestoneDvrTcpUnsolicitedMgr = BMilestoneDvrTcpUnsolicitedMgr.class$("com.tridium.milestone.comm.BMilestoneDvrTcpUnsolicitedMgr")) : class$com$tridium$milestone$comm$BMilestoneDvrTcpUnsolicitedMgr));
    protected static final Log log = Log.getLog((String)"milestone.tcpUnsolMgr");
    protected int aliveInterval;
    protected Clock.Ticket aliveIntervalTicket;
    static /* synthetic */ Class class$com$tridium$milestone$comm$BMilestoneDvrTcpUnsolicitedMgr;

    public void aliveIntervalExpired() {
        this.invoke(aliveIntervalExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected boolean isTraceOn() {
        BIDdfCommunicator bIDdfCommunicator = this.getDdfCommunicator();
        if (bIDdfCommunicator != null) {
            Log log = bIDdfCommunicator.getLog();
            if (log != null) {
                return log.isTraceOn();
            }
            return false;
        }
        return false;
    }

    protected void trace(String string) {
        this.getDdfCommunicator().getLog().trace(string);
    }

    public void processUnsolicitedFrame(IDdfDataFrame iDdfDataFrame) throws Exception {
        XElem xElem = MilestoneReqUtil.getElem(iDdfDataFrame, "milestoneSurveillance");
        XElem xElem2 = xElem.elem("reply");
        if (xElem2 == null) {
            XElem xElem3 = xElem.elem("bubble");
            if (xElem3 == null) {
                XElem xElem4 = xElem.elem("alive");
                if (xElem4 == null) {
                    if (this.isTraceOn()) {
                        this.trace("The most recently received frame contains an unsupported unsolicited XML message.");
                    }
                } else {
                    this.processAlive(xElem4);
                }
            } else {
                this.processBubble(xElem3);
            }
        } else {
            try {
                this.processReply(xElem2);
            }
            catch (DdfResponseException ddfResponseException) {
                // empty catch block
            }
        }
    }

    protected void processAlive(XElem xElem) {
        if (log.isTraceOn()) {
            log.trace(this.getSlotPath().toDisplayString() + " - Received XML alive notification. ");
        }
        this.resetAlarmIntervalExpirationTimer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processReply(XElem xElem) throws DdfResponseException {
        String string;
        if (log.isTraceOn()) {
            log.trace(this.getSlotPath().toDisplayString() + " Received XML reply message.");
        }
        if (!"XMLSimpleReply".equals(string = MilestoneReqUtil.getText(xElem, "base"))) throw new DdfResponseException("Unrecognized 'base' in reply: base=" + (string.trim().length() > 0 ? string : "<null>"));
        XElem xElem2 = MilestoneReqUtil.getElem(xElem, "object");
        String string2 = MilestoneReqUtil.getText(xElem2, "classification");
        if (!"UserLoginManager".equals(string2)) throw new DdfResponseException("Unrecognized 'classification' in reply: classification=" + (string2.trim().length() > 0 ? string2 : "<null>"));
        String string3 = MilestoneReqUtil.getText(xElem2, "status");
        if (!"Enabled".equals(string3)) throw new DdfResponseException("Unrecognized 'status' in reply: status=" + (string3.trim().length() > 0 ? string3 : "<null>"));
        int n = Integer.parseInt(MilestoneReqUtil.getText(xElem2, "id"));
        if (log.isTraceOn()) {
            log.trace(this.getSlotPath().toDisplayString() + " - Good reply. Status Enabled. userLoginManagerId=" + n);
        }
        BMilestoneDvrTcpCommunicator bMilestoneDvrTcpCommunicator = (BMilestoneDvrTcpCommunicator)this.getDdfCommunicator();
        BMilestoneCentralLoginReq bMilestoneCentralLoginReq = new BMilestoneCentralLoginReq(this, n, bMilestoneDvrTcpCommunicator.getMilestoneCentralCredentials().getUsername(), bMilestoneDvrTcpCommunicator.getMilestoneCentralCredentials().getPassword().getString());
        bMilestoneDvrTcpCommunicator.communicate((BIDdfRequest)bMilestoneCentralLoginReq);
    }

    public void aliveIntervalReceived(int n) {
        this.aliveInterval = n;
        this.resetAlarmIntervalExpirationTimer();
    }

    protected void resetAlarmIntervalExpirationTimer() {
        if (this.aliveIntervalTicket != null) {
            this.aliveIntervalTicket.cancel();
        }
        if (this.aliveInterval > 0) {
            this.aliveIntervalTicket = BDdfScheduler.INSTANCE.schedule((BComponent)this, BRelTime.makeSeconds((int)(3 * this.aliveInterval)), aliveIntervalExpired, null);
        }
    }

    public void doAliveIntervalExpired() {
        TcpSocketManager tcpSocketManager;
        BMilestoneDvrTcpCommunicator bMilestoneDvrTcpCommunicator = (BMilestoneDvrTcpCommunicator)this.getDdfCommunicator();
        if (bMilestoneDvrTcpCommunicator != null && (tcpSocketManager = bMilestoneDvrTcpCommunicator.getTcpSocketManager()) != null) {
            tcpSocketManager.stopSocketManager();
            tcpSocketManager.startSocketManager();
        }
    }

    protected void processExternalEvent(XElem xElem, String string, String string2, String string3) throws DdfResponseException {
        BAbsTime bAbsTime = MilestoneReqUtil.getTime(xElem, "spawnTime");
        BMilestoneDvrTcpCommunicator bMilestoneDvrTcpCommunicator = (BMilestoneDvrTcpCommunicator)this.getDdfCommunicator();
        BMilestoneDvr bMilestoneDvr = (BMilestoneDvr)bMilestoneDvrTcpCommunicator.getDdfCommunicatingParent();
        BIVideoCamera[] bIVideoCameraArray = bMilestoneDvr.getCameras().getAllCameras();
        for (int i = 0; i < bIVideoCameraArray.length; ++i) {
            BMilestoneCamera bMilestoneCamera = (BMilestoneCamera)bIVideoCameraArray[i];
            BMilestoneEventCameraExt bMilestoneEventCameraExt = (BMilestoneEventCameraExt)bMilestoneCamera.getEvents();
            BControlPoint[] bControlPointArray = bMilestoneEventCameraExt.getPoints();
            for (int j = 0; j < bControlPointArray.length; ++j) {
                BMilestoneEventProxyExt bMilestoneEventProxyExt = (BMilestoneEventProxyExt)bControlPointArray[j].getProxyExt();
                BMilestoneEventPointId bMilestoneEventPointId = (BMilestoneEventPointId)bMilestoneEventProxyExt.getPointId();
                if (bMilestoneEventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.external || !bMilestoneEventPointId.getMilestoneEventName().equals(string2) || !bMilestoneEventPointId.getMilestoneEventId().equals(string) || !bMilestoneEventPointId.getMilestoneEventStatus().equals(string3)) continue;
                BVideoEvent bVideoEvent = BVideoEvent.makeOffNormalEvent();
                bVideoEvent.setEventType(BVideoEventTypesEnum.customEvent);
                bVideoEvent.setDescription(string + ':' + string2 + ':' + string3);
                bVideoEvent.setTimestamp(bAbsTime);
                bMilestoneEventProxyExt.readOk((BStatusValue)new BDdfVideoEventStatus(bVideoEvent));
            }
        }
    }

    protected void updateMotionDetectedPointInCamera(XElem xElem, String string) throws DdfResponseException {
        if (string != null && string.length() > 0) {
            BAbsTime bAbsTime = MilestoneReqUtil.getTime(xElem, "spawnTime");
            BMilestoneDvrTcpCommunicator bMilestoneDvrTcpCommunicator = (BMilestoneDvrTcpCommunicator)this.getDdfCommunicator();
            BMilestoneDvr bMilestoneDvr = (BMilestoneDvr)bMilestoneDvrTcpCommunicator.getDdfCommunicatingParent();
            BIVideoCamera[] bIVideoCameraArray = bMilestoneDvr.getCameras().getAllCameras();
            for (int i = 0; i < bIVideoCameraArray.length; ++i) {
                String string2;
                BMilestoneCamera bMilestoneCamera = (BMilestoneCamera)bIVideoCameraArray[i];
                if (!bMilestoneCamera.getStatus().isValid()) continue;
                if (!bMilestoneCamera.getHasPingedAtLeastOnce()) {
                    bMilestoneCamera.ping();
                }
                if (!string.equals(string2 = bMilestoneCamera.getMilestoneGuid())) continue;
                BMilestoneEventCameraExt bMilestoneEventCameraExt = (BMilestoneEventCameraExt)bMilestoneCamera.getEvents();
                BControlPoint[] bControlPointArray = bMilestoneEventCameraExt.getPoints();
                for (int j = 0; j < bControlPointArray.length; ++j) {
                    BMilestoneEventProxyExt bMilestoneEventProxyExt = (BMilestoneEventProxyExt)bControlPointArray[j].getProxyExt();
                    BMilestoneEventPointId bMilestoneEventPointId = (BMilestoneEventPointId)bMilestoneEventProxyExt.getPointId();
                    if (bMilestoneEventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.motionDetected) continue;
                    BVideoEvent bVideoEvent = BVideoEvent.makeMotionStarted();
                    bVideoEvent.setTimestamp(bAbsTime);
                    bMilestoneEventProxyExt.readOk((BStatusValue)new BDdfVideoEventStatus(bVideoEvent));
                }
            }
        }
    }

    protected void processBubble(XElem xElem) throws DdfResponseException {
        XElem xElem2;
        XElem xElem3;
        String string;
        if (log.isTraceOn()) {
            log.trace(this.getSlotPath().toDisplayString() + " - Received XML bubble message.");
        }
        if ("EngineElement".equals(string = MilestoneReqUtil.getText(xElem3 = MilestoneReqUtil.getElem(xElem2 = MilestoneReqUtil.getElem(xElem, "source"), "object"), "classification"))) {
            string = MilestoneReqUtil.getText(xElem3 = MilestoneReqUtil.getElem(xElem3, "object"), "classification");
            if ("CameraElement".equals(string)) {
                String string2 = MilestoneReqUtil.getText(xElem3, "guid");
                this.updateMotionDetectedPointInCamera(xElem, string2);
            } else {
                String string3 = MilestoneReqUtil.getText(xElem3, "id");
                String string4 = MilestoneReqUtil.getText(xElem3, "name");
                String string5 = MilestoneReqUtil.getText(xElem3, "status");
                this.processExternalEvent(xElem, string3, string4, string5);
            }
        } else if (this.isTraceOn()) {
            this.trace("Unexpected primary classification on bubble message: " + string + "\nIgnoring bubble message.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

