/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone.comm;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfIp.tcp.comm.BDdfTcpHelper;
import com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator;
import com.tridium.milestone.BMilestoneCamera;
import com.tridium.milestone.BMilestoneDvr;
import com.tridium.milestone.comm.BMilestoneCameraTcpHelper;
import com.tridium.milestone.comm.BMilestoneCameraTransactionMgr;
import com.tridium.milestone.comm.BMilestoneDvrCommunicator;
import com.tridium.milestone.comm.BMilestoneDvrHttpCommunicator;
import com.tridium.milestone.comm.BMilestoneTcpXmlReceiver;
import com.tridium.milestone.comm.BMilestoneTcpXmlTransmitter;
import com.tridium.milestone.comm.req.BMilestoneCameraConnectReq;
import com.tridium.milestone.comm.req.BMilestoneCameraGetTimeRequest;
import com.tridium.milestone.comm.req.BMilestonePanTiltReq;
import com.tridium.milestone.comm.req.BMilestoneVideoStreamReq;
import com.tridium.milestone.comm.req.BMilestoneZoomReq;
import com.tridium.milestone.comm.req.CentralApiReq;
import com.tridium.milestone.comm.req.ImageServerApiHttpReq;
import com.tridium.milestone.comm.req.ImageServerApiTcpRtfReq;
import com.tridium.milestone.comm.req.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class BMilestoneCameraCommunicator
extends BDdfTcpSitCommunicator {
    public static final Property transmitter = BMilestoneCameraCommunicator.newProperty((int)0, (BValue)new BMilestoneTcpXmlTransmitter(), null);
    public static final Property receiver = BMilestoneCameraCommunicator.newProperty((int)0, (BValue)new BMilestoneTcpXmlReceiver(), null);
    public static final Property transactionManager = BMilestoneCameraCommunicator.newProperty((int)0, (BValue)new BMilestoneCameraTransactionMgr(), null);
    public static final Property tcpIpComm = BMilestoneCameraCommunicator.newProperty((int)4, (BValue)new BMilestoneCameraTcpHelper(), null);
    public static final Property milestonePtzReconnectInterval = BMilestoneCameraCommunicator.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$comm$BMilestoneCameraCommunicator == null ? (class$com$tridium$milestone$comm$BMilestoneCameraCommunicator = BMilestoneCameraCommunicator.class$("com.tridium.milestone.comm.BMilestoneCameraCommunicator")) : class$com$tridium$milestone$comm$BMilestoneCameraCommunicator));
    protected static int videoRequestId = 1;
    protected boolean milestonePtzConnectionEstablished;
    protected boolean establishingMilestonePtzConnection;
    protected ConnectionMaintainer connectionMaintainer;
    protected BMilestoneCamera milestoneCamera;
    static /* synthetic */ Class class$com$tridium$milestone$comm$BMilestoneCameraCommunicator;

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public BDdfTransactionMgr getTransactionManager() {
        return (BDdfTransactionMgr)this.get(transactionManager);
    }

    public void setTransactionManager(BDdfTransactionMgr bDdfTransactionMgr) {
        this.set(transactionManager, (BValue)bDdfTransactionMgr, null);
    }

    public BDdfTcpHelper getTcpIpComm() {
        return (BDdfTcpHelper)this.get(tcpIpComm);
    }

    public void setTcpIpComm(BDdfTcpHelper bDdfTcpHelper) {
        this.set(tcpIpComm, (BValue)bDdfTcpHelper, null);
    }

    public BRelTime getMilestonePtzReconnectInterval() {
        return (BRelTime)this.get(milestonePtzReconnectInterval);
    }

    public void setMilestonePtzReconnectInterval(BRelTime bRelTime) {
        this.set(milestonePtzReconnectInterval, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void tcpCommunicatorStarted() throws Exception {
        this.connectionMaintainer = new ConnectionMaintainer();
        this.connectionMaintainer.start();
    }

    protected void tcpCommunicatorStopped() throws Exception {
        this.connectionMaintainer.stopConnectionMaintainer();
        super.tcpCommunicatorStopped();
    }

    public BMilestoneCameraTcpHelper getMilestoneTcpHelper() {
        return (BMilestoneCameraTcpHelper)this.getTcpIpComm();
    }

    public BMilestoneCamera getMilestoneCamera() {
        if (this.milestoneCamera == null) {
            this.milestoneCamera = (BMilestoneCamera)this.getParent();
        }
        return this.milestoneCamera;
    }

    public void doCommunicate(BIDdfRequest bIDdfRequest) {
        if (!this.getMilestoneCamera().getEnabled()) {
            return;
        }
        if (bIDdfRequest.getType() == BMilestoneVideoStreamReq.TYPE) {
            try {
                this.establishVideoFeed((BMilestoneVideoStreamReq)bIDdfRequest);
            }
            catch (Exception exception) {
                this.getLog().error("Unable to establish Milestone live video feed.", (Throwable)exception);
            }
        } else if (bIDdfRequest.getType() == BMilestoneCameraGetTimeRequest.TYPE) {
            try {
                this.determineCameraTime((BMilestoneCameraGetTimeRequest)bIDdfRequest);
            }
            catch (Exception exception) {
                this.getLog().error("Unable to determine Milestone camera time.", (Throwable)exception);
            }
        } else {
            super.doCommunicate(bIDdfRequest);
        }
    }

    public void communicate(BIDdfRequest bIDdfRequest) {
        if (bIDdfRequest instanceof ImageServerApiHttpReq || bIDdfRequest instanceof CentralApiReq) {
            this.getMilestoneCamera().getMilestoneDvr().getMilestoneDvrCommunicator().communicate(bIDdfRequest);
        } else {
            if (bIDdfRequest instanceof ImageServerApiTcpRtfReq) {
                ((ImageServerApiTcpRtfReq)bIDdfRequest).setCommunicator(this);
            }
            if (bIDdfRequest instanceof BMilestonePanTiltReq || bIDdfRequest instanceof BMilestoneZoomReq) {
                try {
                    this.getDdfTransmitter().forceTransmit(bIDdfRequest);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                super.communicate(bIDdfRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void determineCameraTime(BMilestoneCameraGetTimeRequest bMilestoneCameraGetTimeRequest) throws Exception {
        Object object;
        try {
            object = this.getMilestoneCamera().getMilestoneDvr();
            if (object != null) {
                bMilestoneCameraGetTimeRequest.setVideoSource((BIVideoSource)this.getMilestoneCamera());
                bMilestoneCameraGetTimeRequest.setPlaybackParams(new BPlaybackParams());
                GetCameraTimeHack getCameraTimeHack = new GetCameraTimeHack(bMilestoneCameraGetTimeRequest);
                getCameraTimeHack.start();
                getCameraTimeHack.join(getCameraTimeHack.milestoneDvrCommunicator.getTcpCommunicator().getTcpIpComm().getSocketConnectionTimeout().getMillis());
                if (getCameraTimeHack.isAlive()) {
                    getCameraTimeHack.interrupt();
                }
                getCameraTimeHack.liveVideoSocket.close();
            }
        }
        finally {
            object = bMilestoneCameraGetTimeRequest;
            synchronized (object) {
                bMilestoneCameraGetTimeRequest.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishVideoFeed(BMilestoneVideoStreamReq bMilestoneVideoStreamReq) throws Exception {
        Object object;
        try {
            object = this.getMilestoneCamera().getMilestoneDvr();
            if (object != null) {
                EstablishVideoConnection establishVideoConnection = new EstablishVideoConnection(bMilestoneVideoStreamReq);
                establishVideoConnection.start();
                establishVideoConnection.join(establishVideoConnection.milestoneDvrCommunicator.getTcpCommunicator().getTcpIpComm().getSocketConnectionTimeout().getMillis());
                if (establishVideoConnection.isAlive()) {
                    establishVideoConnection.interrupt();
                }
                if (establishVideoConnection.success) {
                    if (this.getLog().isTraceOn()) {
                        this.getLog().trace(">>>>>>>>>>>>>>>>>>>>>>>>> Success >>>>>");
                    }
                    bMilestoneVideoStreamReq.setVideoSocket(establishVideoConnection.liveVideoSocket);
                } else {
                    bMilestoneVideoStreamReq.getVideoDestination().videoStreamTimeout();
                    if (establishVideoConnection.liveVideoSocket != null) {
                        establishVideoConnection.liveVideoSocket.close();
                    }
                }
            }
        }
        finally {
            object = bMilestoneVideoStreamReq;
            synchronized (object) {
                bMilestoneVideoStreamReq.notifyAll();
            }
        }
    }

    public void considerEstablishingMilestoneCameraConnection(String string) {
        if (!this.milestonePtzConnectionEstablished && !this.establishingMilestonePtzConnection) {
            this.establishMilestonePtzCameraConnection(string);
        }
    }

    public void establishMilestonePtzCameraConnection(String string) {
        this.establishingMilestonePtzConnection = true;
        this.communicate((BIDdfRequest)this.makeCameraConnectReq(string));
    }

    public BMilestoneCameraConnectReq makeCameraPtzConnectReq() {
        return this.makeCameraConnectReq(this.getMilestoneCamera().getMilestoneDatabaseId());
    }

    public BMilestoneCameraConnectReq makeCameraConnectReq(String string) {
        BMilestoneDvrHttpCommunicator bMilestoneDvrHttpCommunicator = this.getMilestoneCamera().getMilestoneDvr().getMilestoneDvrCommunicator().getHttpCommunicator();
        String string2 = bMilestoneDvrHttpCommunicator.getCredentials().getPassword().getString();
        String string3 = bMilestoneDvrHttpCommunicator.getCredentials().getUsername();
        BMilestoneCameraConnectReq bMilestoneCameraConnectReq = new BMilestoneCameraConnectReq(string3, string2, string, true);
        if (this.getReceiver().getResponseTimeout().getMillis() < 10000L) {
            bMilestoneCameraConnectReq.setRemainingRetryCount(1);
            bMilestoneCameraConnectReq.setResponseTimeout(BRelTime.makeSeconds((int)10));
        }
        return bMilestoneCameraConnectReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean grantAccess(BIDdfRequest bIDdfRequest) {
        BMilestoneDvrHttpCommunicator bMilestoneDvrHttpCommunicator = this.getMilestoneCamera().getMilestoneDvr().getMilestoneDvrCommunicator().getHttpCommunicator();
        Object object = bMilestoneDvrHttpCommunicator.access;
        synchronized (object) {
            if (bMilestoneDvrHttpCommunicator.getMilestoneSessionId() == null) {
                return bMilestoneDvrHttpCommunicator.doStartSessionSync();
            }
        }
        if (bIDdfRequest instanceof BMilestonePanTiltReq || bIDdfRequest instanceof BMilestoneZoomReq) {
            object = this.getMilestoneCamera();
            String string = ((BMilestoneCamera)((Object)object)).getMilestoneDatabaseId();
            if (string.length() == 0) {
                object.ping();
                return false;
            }
            if (this.milestonePtzConnectionEstablished) {
                return true;
            }
            this.considerEstablishingMilestoneCameraConnection(string);
            return false;
        }
        return true;
    }

    public static synchronized int getNextVideoRequestId() {
        return videoRequestId++;
    }

    public static boolean receiveMilestoneConnectReply(XElem xElem, Log log) throws IOException {
        String string = xElem.name();
        if (string.equals("methodresponse")) {
            XElem xElem2 = xElem.elem("connected");
            if (xElem2 != null) {
                XText xText = xElem2.text();
                if (xText != null) {
                    String string2 = xText.string();
                    if (string2.equals("yes")) {
                        if (log != null && log.isTraceOn()) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
                            xElem.write(xWriter, 2);
                            xWriter.flush();
                            log.trace("RX <Connection Established to Camera>\n" + new String(byteArrayOutputStream.toByteArray()));
                        }
                        return true;
                    }
                    if (string2.equals("no")) {
                        throw new BajaRuntimeException("ImageServer connection was denied.");
                    }
                    throw new IllegalStateException("Unrecognized ImageServer connection string in reply: " + string2);
                }
                throw new IllegalStateException("No text inside <connected>...</connected> elem!");
            }
            throw new IllegalStateException("No <connected>...</connected> elem under <methodresposne>...</methodresponse>!");
        }
        throw new IllegalStateException("Expected <methodresponse> reply from ImageServer but received <" + string + "> instead!");
    }

    public void setMilestonePtzConnectionEstablished(boolean bl) {
        this.milestonePtzConnectionEstablished = bl;
        this.establishingMilestonePtzConnection = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConnectionMaintainer
    extends Thread {
        protected boolean running = true;

        public ConnectionMaintainer() {
            super("MilestoneCommunicator:MaintainConnection");
        }

        public void start() {
            this.running = true;
            super.start();
        }

        public void stopConnectionMaintainer() {
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    try {
                        this.maintainConnection();
                    }
                    catch (Exception exception) {
                        BMilestoneCameraCommunicator.this.getLog().error("Error while maintaining camera connection for ptz control", (Throwable)exception);
                    }
                    Thread.sleep(BMilestoneCameraCommunicator.this.getMilestonePtzReconnectInterval().getMillis());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                BMilestoneCameraCommunicator.this.getLog().trace("Connection maintainer thread finished.");
            }
        }

        protected void maintainConnection() {
            BMilestoneCamera bMilestoneCamera = BMilestoneCameraCommunicator.this.getMilestoneCamera();
            String string = bMilestoneCamera.getMilestoneDatabaseId();
            if (string.length() == 0) {
                bMilestoneCamera.ping();
            } else {
                BMilestoneCameraCommunicator.this.establishMilestonePtzCameraConnection(string);
            }
        }
    }

    public class EstablishVideoConnection
    extends Thread {
        BMilestoneVideoStreamReq videoStreamReq;
        public BMilestoneDvr dvr;
        BMilestoneDvrCommunicator milestoneDvrCommunicator;
        BMilestoneCameraTcpHelper milestoneTcpHelper;
        Socket liveVideoSocket;
        OutputStream tcpOut;
        InputStream tcpIn;
        public boolean success;

        public EstablishVideoConnection(BMilestoneVideoStreamReq bMilestoneVideoStreamReq) {
            super("LiveVideo.Camera" + bMilestoneVideoStreamReq.getMilestoneCameraId());
            this.videoStreamReq = bMilestoneVideoStreamReq;
            this.dvr = BMilestoneCameraCommunicator.this.milestoneCamera.getMilestoneDvr();
            this.milestoneDvrCommunicator = (BMilestoneDvrCommunicator)this.dvr.getCommunicator();
            this.milestoneDvrCommunicator.lease(Integer.MAX_VALUE);
            try {
                this.milestoneDvrCommunicator.getComponentSpace().sync();
            }
            catch (Exception exception) {
                BMilestoneCameraCommunicator.this.getLog().error("Unable to get a fresh copy of the DVR communicator's properties.", (Throwable)exception);
            }
            this.milestoneTcpHelper = (BMilestoneCameraTcpHelper)BMilestoneCameraCommunicator.this.getTcpIpComm();
        }

        protected void establishTcpConnection() throws IOException {
            this.liveVideoSocket = this.milestoneTcpHelper.createSocket();
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("Video socket connection established. Camera id = " + this.videoStreamReq.getMilestoneCameraId());
            }
            this.tcpOut = this.liveVideoSocket.getOutputStream();
            this.tcpIn = this.liveVideoSocket.getInputStream();
        }

        protected void sendMilestoneConnectReq() throws IOException {
            boolean bl = this.videoStreamReq.getPlaybackParams().getCompression() != BVideoCompressionEnum.high && this.videoStreamReq.getPlaybackParams().getPlaybackType() != BPlaybackTypeEnum.live || BMilestoneCameraCommunicator.this.getMilestoneCamera().getHighCompressionCodec() == BCodecIdEnum.ffmpeg_CODEC_ID_NONE;
            String string = this.videoStreamReq.getLiveConnectXml(this.milestoneDvrCommunicator.getHttpCommunicator().getCredentials().getUsername(), this.milestoneDvrCommunicator.getHttpCommunicator().getCredentials().getPassword().getString(), bl);
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("TX <Establish Camera Connection Req>\n" + string);
            }
            this.tcpOut.write(string.getBytes());
            this.tcpOut.flush();
        }

        protected boolean receiveMilestoneConnectReply() throws Exception {
            XParser xParser = XParser.make((InputStream)this.tcpIn);
            XElem xElem = xParser.parse(false);
            if (xElem != null) {
                return BMilestoneCameraCommunicator.receiveMilestoneConnectReply(xElem, BMilestoneCameraCommunicator.this.getLog());
            }
            throw new IllegalStateException("No reply from ImageServer!");
        }

        protected void sendMilestoneVideoReq() throws IOException {
            byte[] byArray = this.videoStreamReq.toByteArray();
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("TX <Camera Video Req>\n" + new String(byArray));
            }
            this.tcpOut.write(byArray);
            this.tcpOut.flush();
        }

        protected String readLineFromSocket() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = -1;
            while (!bl) {
                int n2 = this.tcpIn.read();
                if (n2 == -1) {
                    bl = true;
                    continue;
                }
                stringBuffer.append((char)n2);
                bl = n2 == 10 && n == 13;
                n = n2;
            }
            String string = stringBuffer.toString();
            if (string.length() > 2) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String string = this.readLineFromSocket();
            while (string != null && string.length() > 0 && !"ImageResponse".equals(string)) {
                if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                    BMilestoneCameraCommunicator.this.getLog().trace("Received line while waiting for video stream: " + string);
                }
                string = this.readLineFromSocket();
                if (!BMilestoneCameraCommunicator.this.getLog().isTraceOn()) continue;
                BMilestoneCameraCommunicator.this.getLog().trace("receiveMilestoneVideoRsp: line=" + string);
            }
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("<Established Video Stream>. TcpIn.available()=" + this.tcpIn.available());
            }
            return true;
        }

        public void run() {
            try {
                this.establishTcpConnection();
                this.sendMilestoneConnectReq();
                this.receiveMilestoneConnectReply();
                this.sendMilestoneVideoReq();
                this.success = this.receiveMilestoneVideoRsp();
            }
            catch (SocketException socketException) {
            }
            catch (Exception exception) {
                BMilestoneCameraCommunicator.this.getLog().error("Unable to establish live video feed to the Milestone ImageServer.", (Throwable)exception);
                this.success = false;
            }
        }
    }

    public class GetCameraTimeHack
    extends EstablishVideoConnection {
        BMilestoneCameraGetTimeRequest getMilestoneCameraTimeReq;

        public GetCameraTimeHack(BMilestoneCameraGetTimeRequest bMilestoneCameraGetTimeRequest) {
            super(bMilestoneCameraGetTimeRequest);
            this.getMilestoneCameraTimeReq = bMilestoneCameraGetTimeRequest;
        }

        protected void establishTcpConnection() throws IOException {
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("Establishing a video connection in order to read the camera's current time.");
            }
            super.establishTcpConnection();
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            final String string = this.readLineFromSocket();
            if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                BMilestoneCameraCommunicator.this.getLog().trace("Retrieved line, hopefully it has the camera time:\n" + string);
            }
            try {
                XElem xElem = MilestoneReqUtil.getElem(new IDdfDataFrame(){

                    public BSimple getFrameTag() {
                        return null;
                    }

                    public int getFrameSize() {
                        return string.length();
                    }

                    public IDdfDataFrame getFrameCopy() {
                        return null;
                    }

                    public byte[] getFrameBytes() {
                        return string.getBytes();
                    }
                }, "livepackage");
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "status");
                String string2 = MilestoneReqUtil.getText(xElem2, "statustime");
                if (BMilestoneCameraCommunicator.this.getLog().isTraceOn()) {
                    BMilestoneCameraCommunicator.this.getLog().trace("Retrieved camera time: " + string2);
                }
                this.getMilestoneCameraTimeReq.setCameraTime(string2);
                this.liveVideoSocket.close();
                return true;
            }
            catch (Exception exception) {
                BMilestoneCameraCommunicator.this.getLog().error("Exception occurred while parsing 'live' request for its time", (Throwable)exception);
                return false;
            }
        }
    }
}

