/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.milestone;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfVideo.camera.BDdfVideoCamera;
import com.tridium.ddfVideo.camera.BDdfVideoSourcePreferences;
import com.tridium.ddfVideo.event.BDdfVideoEventRecall;
import com.tridium.ddfVideo.identify.BDdfVideoCameraInfo;
import com.tridium.milestone.BMilestoneDvr;
import com.tridium.milestone.BMilestoneNetwork;
import com.tridium.milestone.BMilestoneVideoSourcePreferences;
import com.tridium.milestone.MilestoneFfmpegMpeg4Decoder;
import com.tridium.milestone.MilestoneMjpegVideoDecoder;
import com.tridium.milestone.comm.BMilestoneCameraCommunicator;
import com.tridium.milestone.comm.req.BMilestoneCameraGetTimeRequest;
import com.tridium.milestone.comm.req.BMilestoneCameraInitiateRecordingReq;
import com.tridium.milestone.comm.req.BMilestoneCameraPingReq;
import com.tridium.milestone.comm.req.BMilestoneEventRefreshAroundReq;
import com.tridium.milestone.comm.req.BMilestoneFocusControlReq;
import com.tridium.milestone.comm.req.BMilestoneIrisControlReq;
import com.tridium.milestone.comm.req.BMilestoneMoveToPresetReq;
import com.tridium.milestone.comm.req.BMilestonePanTiltReq;
import com.tridium.milestone.comm.req.BMilestoneStorePresetReq;
import com.tridium.milestone.comm.req.BMilestoneVideoStreamReq;
import com.tridium.milestone.comm.req.BMilestoneZoomReq;
import com.tridium.milestone.enums.BMilestoneStopRecordingModeEnum;
import com.tridium.milestone.event.BMilestoneEventCameraExt;
import com.tridium.milestone.identify.BMilestoneCameraId;
import com.tridium.milestone.identify.BMilestoneVideoCameraInfo;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class BMilestoneCamera
extends BDdfVideoCamera
implements BIVideoEventProvider,
BIVideoAlarmRecorder {
    public static final Property pingParameters = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoCameraInfo(), (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    public static final Property communicator = BMilestoneCamera.newProperty((int)4, (BValue)new BMilestoneCameraCommunicator(), null);
    public static final Property deviceId = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneCameraId(), (BFacets)MGR_INCLUDE);
    public static final Property videoPreferences = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoSourcePreferences(), (BFacets)MGR_INCLUDE);
    public static final Property milestoneDatabaseId = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property milestoneGuid = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property autoSetPtzSupport = BMilestoneCamera.newProperty((int)0, (boolean)false, (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    public static final Property stopRecordingMode = BMilestoneCamera.newProperty((int)0, (BValue)BMilestoneStopRecordingModeEnum.onTimer, (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    public static final Property eventRecaller = BMilestoneCamera.newProperty((int)6, (BValue)new BDdfVideoEventRecall(BMilestoneEventRefreshAroundReq.TYPE), null);
    public static final Property presetText = BMilestoneCamera.newProperty((int)0, (BValue)BEnumRange.make((String[])new String[]{EscUtil.slot.escape("???")}), null);
    public static final Property highCompressionCodec = BMilestoneCamera.newProperty((int)0, (BValue)BCodecIdEnum.ffmpeg_CODEC_ID_MPEG4, null);
    public static final Property events = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneEventCameraExt(), null);
    public static final Action moveToPreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action storePreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action forceStartRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Action forceStopRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$milestone$BMilestoneCamera == null ? (class$com$tridium$milestone$BMilestoneCamera = BMilestoneCamera.class$("com.tridium.milestone.BMilestoneCamera")) : class$com$tridium$milestone$BMilestoneCamera));
    protected boolean hasPingedAtLeastOnce;
    static /* synthetic */ Class class$com$tridium$milestone$BMilestoneCamera;

    public BDdfIdParams getPingParameters() {
        return (BDdfIdParams)this.get(pingParameters);
    }

    public void setPingParameters(BDdfIdParams bDdfIdParams) {
        this.set(pingParameters, (BValue)bDdfIdParams, null);
    }

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue bValue) {
        this.set(communicator, bValue, null);
    }

    public BDdfIdParams getDeviceId() {
        return (BDdfIdParams)this.get(deviceId);
    }

    public void setDeviceId(BDdfIdParams bDdfIdParams) {
        this.set(deviceId, (BValue)bDdfIdParams, null);
    }

    public BDdfVideoSourcePreferences getVideoPreferences() {
        return (BDdfVideoSourcePreferences)this.get(videoPreferences);
    }

    public void setVideoPreferences(BDdfVideoSourcePreferences bDdfVideoSourcePreferences) {
        this.set(videoPreferences, (BValue)bDdfVideoSourcePreferences, null);
    }

    public String getMilestoneDatabaseId() {
        return this.getString(milestoneDatabaseId);
    }

    public void setMilestoneDatabaseId(String string) {
        this.setString(milestoneDatabaseId, string, null);
    }

    public String getMilestoneGuid() {
        return this.getString(milestoneGuid);
    }

    public void setMilestoneGuid(String string) {
        this.setString(milestoneGuid, string, null);
    }

    public boolean getAutoSetPtzSupport() {
        return this.getBoolean(autoSetPtzSupport);
    }

    public void setAutoSetPtzSupport(boolean bl) {
        this.setBoolean(autoSetPtzSupport, bl, null);
    }

    public BMilestoneStopRecordingModeEnum getStopRecordingMode() {
        return (BMilestoneStopRecordingModeEnum)this.get(stopRecordingMode);
    }

    public void setStopRecordingMode(BMilestoneStopRecordingModeEnum bMilestoneStopRecordingModeEnum) {
        this.set(stopRecordingMode, (BValue)bMilestoneStopRecordingModeEnum, null);
    }

    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    public void setEventRecaller(BVideoEventRecall bVideoEventRecall) {
        this.set(eventRecaller, (BValue)bVideoEventRecall, null);
    }

    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    public void setPresetText(BEnumRange bEnumRange) {
        this.set(presetText, (BValue)bEnumRange, null);
    }

    public BCodecIdEnum getHighCompressionCodec() {
        return (BCodecIdEnum)this.get(highCompressionCodec);
    }

    public void setHighCompressionCodec(BCodecIdEnum bCodecIdEnum) {
        this.set(highCompressionCodec, (BValue)bCodecIdEnum, null);
    }

    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    public void setEvents(BPointDeviceExt bPointDeviceExt) {
        this.set(events, (BValue)bPointDeviceExt, null);
    }

    public void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public void forceStartRecording() {
        this.invoke(forceStartRecording, null, null);
    }

    public void forceStopRecording() {
        this.invoke(forceStopRecording, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void videoCameraStarted() throws Exception {
        BDeviceNetwork bDeviceNetwork = this.getNetwork();
        String string = (String)bDeviceNetwork.fw(501, (Object)"camera.limit", null, null, null);
        if (string != null) {
            this.configFatal(string);
        }
        this.milestoneCameraStarted();
        super.videoCameraStarted();
    }

    protected void milestoneCameraStarted() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = (BDdfVideoCameraInfo)this.getPingParameters();
        bDdfVideoCameraInfo.setSupportsStorePreset(false);
    }

    public BMilestoneCameraCommunicator getMilestoneCameraCommunicator() {
        return (BMilestoneCameraCommunicator)this.getCommunicator();
    }

    public void stopped() throws Exception {
        try {
            this.getMilestoneCameraCommunicator().stopCommunicating();
            super.stopped();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(autoSetPtzSupport)) {
            BDdfVideoCameraInfo bDdfVideoCameraInfo;
            boolean bl = (bDdfVideoCameraInfo = (BDdfVideoCameraInfo)this.getPingParameters()).getSupportsPanTilt();
            bDdfVideoCameraInfo.setSupportsPanTilt(!bl);
            bDdfVideoCameraInfo.setSupportsPanTilt(bl);
        }
    }

    public void descendantsStarted() throws Exception {
        String string = this.getMilestoneDatabaseId();
        if (string.length() > 0) {
            this.getMilestoneCameraCommunicator().considerEstablishingMilestoneCameraConnection(string);
        }
    }

    public boolean getHasPingedAtLeastOnce() {
        return this.hasPingedAtLeastOnce;
    }

    public void pingFail(String string) {
        this.hasPingedAtLeastOnce = true;
        super.pingFail(string);
    }

    public void pingOk() {
        this.hasPingedAtLeastOnce = true;
        this.getMilestoneCameraCommunicator().establishMilestonePtzCameraConnection(this.getMilestoneDatabaseId());
        super.pingOk();
    }

    public BMilestoneDvr getMilestoneDvr() {
        return (BMilestoneDvr)this.getDvr();
    }

    protected Type getFocusCtrlReqType() {
        return BMilestoneFocusControlReq.TYPE;
    }

    protected Type getIrisCtrlReqType() {
        return BMilestoneIrisControlReq.TYPE;
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    protected Type getMoveToPresetReqType() {
        return BMilestoneMoveToPresetReq.TYPE;
    }

    protected Type getPanTiltReqType() {
        return BMilestonePanTiltReq.TYPE;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    protected Type getStorePresetReqType() {
        return BMilestoneStorePresetReq.TYPE;
    }

    protected Type getVideoStreamRequestType() {
        return BMilestoneVideoStreamReq.TYPE;
    }

    protected Type getZoomReqType() {
        return BMilestoneZoomReq.TYPE;
    }

    public void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        if (bPlaybackParams.getCompression() == BVideoCompressionEnum.high && bPlaybackParams.getPlaybackType() == BPlaybackTypeEnum.live && this.getHighCompressionCodec() != BCodecIdEnum.ffmpeg_CODEC_ID_NONE) {
            return new MilestoneFfmpegMpeg4Decoder(this.getHighCompressionCodec());
        }
        return new MilestoneMjpegVideoDecoder();
    }

    public Type getNetworkType() {
        return BMilestoneNetwork.TYPE;
    }

    public BIDdfPingRequest makePingRequest() {
        BMilestoneCameraPingReq bMilestoneCameraPingReq = (BMilestoneCameraPingReq)super.makePingRequest();
        bMilestoneCameraPingReq.setCamera(this);
        return bMilestoneCameraPingReq;
    }

    public void onMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        if (bVideoPanTiltEnum != BVideoPanTiltEnum.none) {
            super.onMove(bVideoPanTiltEnum);
        }
    }

    public void onZoom(BVideoZoomEnum bVideoZoomEnum) {
        if (bVideoZoomEnum != BVideoZoomEnum.none) {
            super.onZoom(bVideoZoomEnum);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(moveToPreset) || action.equals(storePreset)) {
            BEnumRange bEnumRange = this.getPresetText();
            int[] nArray = bEnumRange.getOrdinals();
            int n = nArray == null || nArray.length == 0 ? 0 : nArray[0];
            return BDynamicEnum.make((int)n, (BEnumRange)bEnumRange);
        }
        return super.getActionParameterDefault(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecordingAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord.getSourceState() == BSourceState.normal) {
            BMilestoneStopRecordingModeEnum bMilestoneStopRecordingModeEnum = this.getStopRecordingMode();
            if (bMilestoneStopRecordingModeEnum == BMilestoneStopRecordingModeEnum.onTimer) return;
            if (bMilestoneStopRecordingModeEnum != BMilestoneStopRecordingModeEnum.onAlarmToNormal) throw new IllegalStateException("Unrecognized BMilestoneStopRecordingModeEnum: " + (Object)((Object)bMilestoneStopRecordingModeEnum) + ". Please have my program fixed.");
            this.doForceStopRecording();
            return;
        } else {
            this.doForceStartRecording();
        }
    }

    public void doForceStartRecording() {
        BMilestoneCameraInitiateRecordingReq bMilestoneCameraInitiateRecordingReq = new BMilestoneCameraInitiateRecordingReq();
        bMilestoneCameraInitiateRecordingReq.setDeviceId((BDdfIdParams)((BMilestoneCameraId)this.getDeviceId().newCopy()));
        bMilestoneCameraInitiateRecordingReq.setStartRecording(true);
        this.getMilestoneDvr().getMilestoneDvrCommunicator().communicate((BIDdfRequest)bMilestoneCameraInitiateRecordingReq);
    }

    public void doForceStopRecording() {
        BMilestoneCameraInitiateRecordingReq bMilestoneCameraInitiateRecordingReq = new BMilestoneCameraInitiateRecordingReq();
        bMilestoneCameraInitiateRecordingReq.setDeviceId((BDdfIdParams)((BMilestoneCameraId)this.getDeviceId().newCopy()));
        bMilestoneCameraInitiateRecordingReq.setStartRecording(false);
        this.getMilestoneDvr().getMilestoneDvrCommunicator().communicate((BIDdfRequest)bMilestoneCameraInitiateRecordingReq);
    }

    public Type getCameraTimeReqType() {
        return BMilestoneCameraGetTimeRequest.TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

