/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.px.editor.BPxEditorPane;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BLayerTag;
import javax.baja.ui.px.PxLayer;

public class LayerManager {
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public LayerManager(BPxEditor bPxEditor, BPxEditorPane bPxEditorPane) {
        this.editor = bPxEditor;
        this.editorPane = bPxEditorPane;
    }

    public void insert(int n, PxLayer pxLayer, CommandArtifact commandArtifact) {
        if (pxLayer.getName().length() == 0) {
            throw new IllegalArgumentException("Layer name must be defined.");
        }
        Array array = new Array((Object[])this.editor.getPxLayers());
        array.add(n, (Object)pxLayer);
        this.editor.setPxLayers((PxLayer[])array.trim());
        if (commandArtifact != null) {
            try {
                commandArtifact.undo();
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public CommandArtifact remove(BPxEditorPane bPxEditorPane, PxLayer pxLayer) {
        Array array = new Array((Object[])this.editor.getPxLayers());
        array.remove((Object)pxLayer);
        this.editor.setPxLayers((PxLayer[])array.trim());
        RemoveTagsArtifact removeTagsArtifact = new RemoveTagsArtifact(pxLayer);
        try {
            removeTagsArtifact.redo();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return removeTagsArtifact;
    }

    public PxLayer getLayerByName(String string) {
        if (string.equals("")) {
            return null;
        }
        PxLayer[] pxLayerArray = this.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            if (!string.equals(pxLayerArray[i].getName())) continue;
            return pxLayerArray[i];
        }
        return null;
    }

    public BLayerTag getTag(BWidget bWidget) {
        SlotCursor slotCursor = bWidget.getProperties();
        while (slotCursor.next()) {
            BValue bValue = bWidget.get(slotCursor.property());
            if (!(bValue instanceof BLayerTag)) continue;
            return (BLayerTag)bValue;
        }
        return BLayerTag.NULL;
    }

    public BLayerTag getCommonTag(BWidget[] bWidgetArray) {
        if (bWidgetArray.length == 0) {
            return BLayerTag.NULL;
        }
        BLayerTag bLayerTag = this.getTag(bWidgetArray[0]);
        for (int i = 1; i < bWidgetArray.length; ++i) {
            BLayerTag bLayerTag2 = this.getTag(bWidgetArray[i]);
            if (bLayerTag == null && bLayerTag2 != null) {
                return BLayerTag.NULL;
            }
            if (bLayerTag != null && bLayerTag2 == null) {
                return BLayerTag.NULL;
            }
            if (bLayerTag == null && bLayerTag2 == null || bLayerTag.getLayerName().equals(bLayerTag2.getLayerName())) continue;
            return BLayerTag.NULL;
        }
        return bLayerTag;
    }

    public BWidget[] getLayerWidgets(PxLayer pxLayer) {
        Array array = new Array(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = LayerManager.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
        this.doGetWidgets(pxLayer, (BWidget)this.editorPane.getRootContainer(), array);
        return (BWidget[])array.trim();
    }

    public void renameLayerTag(String string, String string2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Layer name must be defined.");
        }
        this.doRenameLayerTag(string, string2, (BWidget)this.editorPane.getRootContainer());
    }

    public boolean allNormal(BWidget[] bWidgetArray) {
        if (bWidgetArray == null) {
            return true;
        }
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i] == null || this.isNormal(bWidgetArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isNormal(BWidget bWidget) {
        BLayerTag bLayerTag = this.getTag(bWidget);
        if (bLayerTag.isNull()) {
            return true;
        }
        PxLayer pxLayer = this.getLayerByName(bLayerTag.getLayerName());
        return pxLayer.getStatus().equals((Object)BLayerStatus.normal);
    }

    public BWidget[] trimToNormal(BWidget[] bWidgetArray) {
        Array array = new Array(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = LayerManager.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!this.isNormal(bWidgetArray[i])) continue;
            array.add((Object)bWidgetArray[i]);
        }
        if (array.size() == 0) {
            return null;
        }
        return (BWidget[])array.trim();
    }

    public void adjustInvisibleWidgets(boolean bl) {
        PxLayer[] pxLayerArray = this.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            if (!pxLayerArray[i].getStatus().equals((Object)BLayerStatus.invisible)) continue;
            this.doAdjustVisibility(pxLayerArray[i].getName(), bl, (BWidget)this.editorPane.getRootContainer());
        }
    }

    public void addTag(BWidget bWidget, PxLayer pxLayer) {
        bWidget.add(null, (BValue)new BLayerTag(pxLayer.getName()));
        if (pxLayer.getStatus().equals((Object)BLayerStatus.invisible)) {
            bWidget.setVisible(false);
        }
    }

    public void removeTag(BWidget bWidget) {
        SlotCursor slotCursor = bWidget.getProperties();
        while (slotCursor.next()) {
            BValue bValue = bWidget.get(slotCursor.property());
            if (!(bValue instanceof BLayerTag)) continue;
            BLayerTag bLayerTag = (BLayerTag)bValue;
            PxLayer pxLayer = this.getLayerByName(bLayerTag.getLayerName());
            if (pxLayer != null && pxLayer.getStatus().equals((Object)BLayerStatus.invisible)) {
                bWidget.setVisible(true);
            }
            bWidget.remove(slotCursor.property());
            break;
        }
    }

    public void setLayerStatus(PxLayer pxLayer, BLayerStatus bLayerStatus) {
        BLayerStatus bLayerStatus2 = pxLayer.getStatus();
        if (!bLayerStatus2.equals((Object)bLayerStatus)) {
            pxLayer.setStatus(bLayerStatus);
            if (bLayerStatus2.equals((Object)BLayerStatus.invisible)) {
                this.doAdjustVisibility(pxLayer.getName(), true, (BWidget)this.editorPane.getRootContainer());
            } else if (bLayerStatus.equals((Object)BLayerStatus.invisible)) {
                this.doAdjustVisibility(pxLayer.getName(), false, (BWidget)this.editorPane.getRootContainer());
            }
        }
    }

    public void stripMissingLayer(BWidget bWidget) {
        BLayerTag bLayerTag = this.getTag(bWidget);
        if (bLayerTag == null) {
            return;
        }
        String string = bLayerTag.getLayerName();
        if (string.equals("")) {
            return;
        }
        PxLayer[] pxLayerArray = this.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            if (!string.equals(pxLayerArray[i].getName())) continue;
            return;
        }
        SlotCursor slotCursor = bWidget.getProperties();
        while (slotCursor.next()) {
            BValue bValue = bWidget.get(slotCursor.property());
            if (!(bValue instanceof BLayerTag)) continue;
            bWidget.remove(slotCursor.property());
            break;
        }
    }

    private void doAdjustVisibility(String string, boolean bl, BWidget bWidget) {
        BLayerTag bLayerTag = this.getTag(bWidget);
        if (bLayerTag != null && bLayerTag.getLayerName().equals(string)) {
            bWidget.setVisible(bl);
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.doAdjustVisibility(string, bl, bWidgetArray[i]);
        }
    }

    private void doRenameLayerTag(String string, String string2, BWidget bWidget) {
        BLayerTag bLayerTag = this.getTag(bWidget);
        if (bLayerTag != null && bLayerTag.getLayerName().equals(string)) {
            bLayerTag.setLayerName(string2);
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.doRenameLayerTag(string, string2, bWidgetArray[i]);
        }
    }

    private void doGetWidgets(PxLayer pxLayer, BWidget bWidget, Array array) {
        BLayerTag bLayerTag = this.getTag(bWidget);
        if (bLayerTag != null && bLayerTag.getLayerName().equals(pxLayer.getName())) {
            array.add((Object)bWidget);
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.doGetWidgets(pxLayer, bWidgetArray[i], array);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RemoveTagsArtifact
    implements CommandArtifact {
        private PxLayer layer;
        private BWidget[] widgets;

        private RemoveTagsArtifact(PxLayer pxLayer) {
            this.layer = pxLayer;
            this.widgets = LayerManager.this.getLayerWidgets(pxLayer);
        }

        public void redo() throws Exception {
            for (int i = 0; i < this.widgets.length; ++i) {
                LayerManager.this.removeTag(this.widgets[i]);
            }
        }

        public void undo() throws Exception {
            for (int i = 0; i < this.widgets.length; ++i) {
                LayerManager.this.addTag(this.widgets[i], this.layer);
            }
        }
    }
}

