/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.BStudio;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.studio.trackers.HitSelectedTracker;
import com.tridium.px.editor.studio.trackers.MoveTracker;
import com.tridium.px.editor.studio.trackers.PassThroughTracker;
import com.tridium.px.editor.studio.trackers.RubberBandTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.gx.Point;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTabbedPane;

public class UnpressedTracker
extends Tracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;

    public UnpressedTracker(BPxEditorPane bPxEditorPane) {
        this(bPxEditorPane, bPxEditorPane.getTrackerStudio());
    }

    public UnpressedTracker(BPxEditorPane bPxEditorPane, TrackerStudio trackerStudio) {
        super(bPxEditorPane);
        this.studio = trackerStudio;
        this.selected = bPxEditorPane.getSelectedWidgets();
        trackerStudio.setMouseCursor(MouseCursor.normal);
    }

    public Tracker mouseMoved(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        Handle handle = this.editorPane.getSelectedWidgets().getHandle(d, d2);
        if (handle == null) {
            BWidget bWidget = this.studio.rootDescendant(new Point(d, d2));
            if (bWidget != null && bWidget instanceof BSplitPane) {
                Point point = this.studio.translateFromRoot(bWidget, new Point(d, d2));
                MouseCursor mouseCursor = (MouseCursor)((BSplitPane)bWidget).fw(304, (Object)point, null, null, null);
                this.studio.setMouseCursor(mouseCursor == null ? MouseCursor.normal : mouseCursor);
            } else {
                this.studio.setMouseCursor(MouseCursor.normal);
            }
        } else if (this.editorPane.getLayerManager().isNormal(handle.widget)) {
            this.studio.setMouseCursor(handle.cursor);
        }
        return this;
    }

    public Tracker mousePressed(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        UnpressedTracker.setAnchorX(d);
        UnpressedTracker.setAnchorY(d2);
        switch (bMouseEvent.getClickCount()) {
            case 1: {
                if (bMouseEvent.isButton1Down()) {
                    return this.handleLeftClick(bMouseEvent);
                }
                if (!bMouseEvent.isButton3Down()) break;
                return this.handleRightClick(bMouseEvent);
            }
            case 2: {
                if (!bMouseEvent.isButton1Down()) break;
                return this.handleDoubleClick(bMouseEvent);
            }
        }
        return this;
    }

    public Tracker keyPressed(BKeyEvent bKeyEvent) {
        BWidget[] bWidgetArray = this.selected.getWidgets();
        if (!this.editorPane.getLayerManager().allNormal(bWidgetArray)) {
            return this;
        }
        this.studio.setShiftDown(bKeyEvent.isShiftDown());
        Artisan artisan = Artisan.instance();
        double d = bKeyEvent.isControlDown() ? 1 : 5;
        switch (bKeyEvent.getKeyCode()) {
            case 37: 
            case 226: {
                BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
                if (bCanvasPane == null) break;
                double d2 = MoveWidget.getMinX(bWidgetArray, artisan);
                if (d2 > 0.0) {
                    d = Math.min(d2, d);
                    new MoveWidget(this.editorPane, bWidgetArray, -d, 0.0).invoke();
                }
                bKeyEvent.consume();
                break;
            }
            case 39: 
            case 227: {
                BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
                if (bCanvasPane == null) break;
                double d3 = MoveWidget.getMaxX(bWidgetArray, artisan);
                if (d3 < bCanvasPane.getWidth() - 1.0) {
                    d = Math.min(bCanvasPane.getWidth() - 1.0 - d3, d);
                    new MoveWidget(this.editorPane, bWidgetArray, d, 0.0).invoke();
                }
                bKeyEvent.consume();
                break;
            }
            case 38: 
            case 224: {
                BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
                if (bCanvasPane == null) break;
                double d4 = MoveWidget.getMinY(bWidgetArray, artisan);
                if (d4 > 0.0) {
                    d = Math.min(d4, d);
                    new MoveWidget(this.editorPane, bWidgetArray, 0.0, -d).invoke();
                }
                bKeyEvent.consume();
                break;
            }
            case 40: 
            case 225: {
                BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
                if (bCanvasPane == null) break;
                double d5 = MoveWidget.getMaxY(bWidgetArray, artisan);
                if (d5 < bCanvasPane.getHeight() - 1.0) {
                    d = Math.min(bCanvasPane.getHeight() - 1.0 - d5, d);
                    new MoveWidget(this.editorPane, bWidgetArray, 0.0, d).invoke();
                }
                bKeyEvent.consume();
            }
        }
        return this;
    }

    private Tracker handleLeftClick(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX();
        Handle handle = this.selected.getHandle(d2, d = bMouseEvent.getY());
        if (handle == null) {
            BWidget[] bWidgetArray = this.studio.rootDescendants(new Point(d2, d));
            if (bWidgetArray == null) {
                this.selected.deselectAll();
                this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
                return this;
            }
            return this.hitLeftSingleWidget(bMouseEvent, bWidgetArray[0]);
        }
        if (handle.cursor == MouseCursor.doNotEnter) {
            return this;
        }
        if (!this.editorPane.getLayerManager().isNormal(handle.widget)) {
            return this;
        }
        boolean bl = bMouseEvent.isControlDown();
        return Artisan.instance().makeHandleTracker(this.editorPane, handle, bl);
    }

    private Tracker hitLeftSingleWidget(BMouseEvent bMouseEvent, BWidget bWidget) {
        if (bWidget instanceof BCanvasPane) {
            return new RubberBandTracker(this.editorPane, (BCanvasPane)bWidget, bMouseEvent.isControlDown());
        }
        if (bWidget instanceof BTabbedPane) {
            bWidget.mousePressed(this.makeMouseEvent(this.studio, bWidget, bMouseEvent));
            this.editorPane.forceRootLayout();
        } else if (bWidget instanceof BScrollBar || bWidget instanceof BSplitPane) {
            if (this.editorPane.getLayerManager().isNormal(bWidget)) {
                return this.passThrough(bMouseEvent, bWidget);
            }
            return this;
        }
        if (this.selected.isSelected(bWidget)) {
            return new HitSelectedTracker(this.editorPane, bWidget);
        }
        return this.hitLeftUnselected(bMouseEvent, bWidget);
    }

    private Tracker passThrough(BMouseEvent bMouseEvent, BWidget bWidget) {
        bWidget.mousePressed(this.makeMouseEvent(this.studio, bWidget, bMouseEvent));
        if (bWidget instanceof BSplitPane) {
            double d;
            double d2 = bMouseEvent.getX();
            Point point = this.studio.translateFromRoot(bWidget, new Point(d2, d = bMouseEvent.getY()));
            MouseCursor mouseCursor = (MouseCursor)((BSplitPane)bWidget).fw(304, (Object)point, null, null, null);
            this.studio.setMouseCursor(mouseCursor == null ? MouseCursor.normal : mouseCursor);
        } else {
            this.studio.setMouseCursor(MouseCursor.normal);
        }
        this.selected.deselectAll();
        this.selected.select(bWidget instanceof BSplitPane ? bWidget : bWidget.getParentWidget());
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        return new PassThroughTracker(this.editorPane, bWidget);
    }

    private Tracker hitLeftUnselected(BMouseEvent bMouseEvent, BWidget bWidget) {
        if (!bMouseEvent.isControlDown() || !this.selected.canSelect(bWidget)) {
            this.selected.deselectAll();
        }
        this.selected.select(bWidget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        if (this.editor.isReadonly()) {
            return this;
        }
        if (!this.editorPane.getLayerManager().isNormal(bWidget)) {
            return this;
        }
        BWidget bWidget2 = bWidget.getParentWidget();
        BCanvasPane bCanvasPane = Reflector.canvas(bWidget2);
        if (bCanvasPane == null) {
            return this;
        }
        return UnpressedTracker.makeMoveTracker(this.editorPane, bCanvasPane, bWidget2);
    }

    static MoveTracker makeMoveTracker(BPxEditorPane bPxEditorPane, BCanvasPane bCanvasPane, BWidget bWidget) {
        if (bCanvasPane == bWidget) {
            return new MoveTracker(bPxEditorPane, bCanvasPane, bPxEditorPane.getSelectedWidgets().getWidgets());
        }
        BWidget bWidget2 = bWidget.getParentWidget();
        while (bWidget2 != bCanvasPane) {
            bWidget = bWidget2;
            bWidget2 = bWidget.getParentWidget();
        }
        return new MoveTracker(bPxEditorPane, bCanvasPane, new BWidget[]{bWidget});
    }

    private Tracker handleRightClick(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX();
        Handle handle = this.selected.getHandle(d2, d = bMouseEvent.getY());
        if (handle == null) {
            BWidget[] bWidgetArray = this.studio.rootDescendants(new Point(d2, d));
            if (bWidgetArray == null) {
                return this;
            }
            if (bWidgetArray.length == 1) {
                return this.hitRightSingleWidget(bMouseEvent, bWidgetArray[0]);
            }
            return this.hitRightWidgetStack(bMouseEvent, bWidgetArray);
        }
        this.studio.showPopupMenu(bMouseEvent);
        return this;
    }

    private Tracker hitRightSingleWidget(BMouseEvent bMouseEvent, BWidget bWidget) {
        if (bWidget == null) {
            return this;
        }
        if (bWidget instanceof BScrollBar) {
            bWidget = bWidget.getParentWidget();
        }
        if (this.selected.isSelected(bWidget)) {
            this.studio.showPopupMenu(bMouseEvent);
            return this;
        }
        return this.hitRightUnselected(bMouseEvent, bWidget);
    }

    private Tracker hitRightUnselected(BMouseEvent bMouseEvent, BWidget bWidget) {
        if (!bMouseEvent.isControlDown() || !this.selected.canSelect(bWidget)) {
            this.selected.deselectAll();
        }
        this.selected.select(bWidget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        this.studio.showPopupMenu(bMouseEvent);
        return this;
    }

    private Tracker hitRightWidgetStack(BMouseEvent bMouseEvent, BWidget[] bWidgetArray) {
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!this.selected.isSelected(bWidgetArray[i])) continue;
            this.studio.showPopupMenu(bMouseEvent);
            return this;
        }
        return this.hitRightUnselected(bMouseEvent, bWidgetArray[0]);
    }

    private Tracker handleDoubleClick(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX();
        Handle handle = this.selected.getHandle(d2, d = bMouseEvent.getY());
        if (handle == null) {
            BWidget[] bWidgetArray = this.studio.rootDescendants(new Point(d2, d));
            if (bWidgetArray == null) {
                return this;
            }
            return this.editSingleWidget(bWidgetArray[0], bMouseEvent);
        }
        return this.editSingleWidget(handle.widget, bMouseEvent);
    }

    private Tracker editSingleWidget(BWidget bWidget, BMouseEvent bMouseEvent) {
        if (bWidget == null) {
            return this;
        }
        if (bWidget instanceof BScrollBar) {
            bWidget = bWidget.getParentWidget();
        }
        this.selected.deselectAll();
        this.selected.select(bWidget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        Command command = this.editor.getController().getDoubleClickCommand((BStudio)this.studio, bMouseEvent);
        if (command != null) {
            command.invoke();
        }
        return this;
    }
}

