/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import javax.baja.gx.Point;
import javax.baja.px.editor.BPxEditor;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public abstract class Tracker {
    static final int NEAR = 3;
    protected BPxEditorPane editorPane;
    protected BPxEditor editor;
    static double anchorX;
    static double anchorY;

    protected Tracker(BPxEditorPane bPxEditorPane) {
        this.editorPane = bPxEditorPane;
        this.editor = bPxEditorPane.getPxEditor();
    }

    public Tracker mouseMoved(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker mousePressed(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker mouseEntered(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker mouseExited(BMouseEvent bMouseEvent) {
        return this;
    }

    public Tracker keyPressed(BKeyEvent bKeyEvent) {
        this.editorPane.getTrackerStudio().setShiftDown(bKeyEvent.isShiftDown());
        return this;
    }

    public Tracker keyReleased(BKeyEvent bKeyEvent) {
        this.editorPane.getTrackerStudio().setShiftDown(bKeyEvent.isShiftDown());
        return this;
    }

    public Tracker keyTyped(BKeyEvent bKeyEvent) {
        this.editorPane.getTrackerStudio().setShiftDown(bKeyEvent.isShiftDown());
        return this;
    }

    protected static double getAnchorX() {
        return anchorX;
    }

    protected static double getAnchorY() {
        return anchorY;
    }

    protected static void setAnchorX(double d) {
        anchorX = d;
    }

    protected static void setAnchorY(double d) {
        anchorY = d;
    }

    protected boolean moved(BMouseEvent bMouseEvent) {
        return Math.abs(bMouseEvent.getX() - Tracker.getAnchorX()) > 3.0 || Math.abs(bMouseEvent.getY() - Tracker.getAnchorY()) > 3.0;
    }

    protected final BMouseEvent makeMouseEvent(TrackerStudio trackerStudio, BWidget bWidget, BMouseEvent bMouseEvent) {
        Point point = trackerStudio.translateFromRoot(bWidget, new Point(bMouseEvent.getX(), bMouseEvent.getY()));
        return new BMouseEvent(bMouseEvent.getId(), bWidget, bMouseEvent.getModifiers(), point.x, point.y, bMouseEvent.getClickCount(), bMouseEvent.isPopupTrigger());
    }
}

