/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.gx.util.GeomUtil;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.painters.DefaultPainter;
import com.tridium.px.editor.studio.painters.GeomPainter;
import com.tridium.px.editor.studio.trackers.GeomSupplier;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.gx.Geom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;

public class RubberBandTracker
extends Tracker
implements GeomSupplier {
    private SelectedWidgets selected;
    private TrackerStudio studio;
    private BCanvasPane canvas;
    private boolean wasShiftDown;
    private RectGeom[] rubberBand = new RectGeom[1];
    private boolean dragged = false;
    private Point anchor;

    public RubberBandTracker(BPxEditorPane bPxEditorPane, BCanvasPane bCanvasPane, boolean bl) {
        super(bPxEditorPane);
        this.studio = bPxEditorPane.getTrackerStudio();
        this.canvas = bCanvasPane;
        this.wasShiftDown = bl;
        this.selected = bPxEditorPane.getSelectedWidgets();
        this.anchor = this.studio.toViewbox(RubberBandTracker.getAnchorX(), RubberBandTracker.getAnchorY(), bCanvasPane);
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        if (!this.dragged && this.moved(bMouseEvent)) {
            this.dragged = true;
            if (!this.wasShiftDown) {
                this.selected.deselectAll();
            }
            this.studio.setPainter(new GeomPainter(this.editorPane.getPainterStudio(), this, this.canvas.getScaleTransform(), this.studio.translateToRoot((BWidget)this.canvas, new Point(0.0, 0.0))));
        }
        this.makeRubberBand(bMouseEvent);
        this.editorPane.repaint();
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        if (this.dragged) {
            this.dragged = false;
            this.makeRubberBand(bMouseEvent);
            this.studio.selectWidgets(this.rubberBand[0], this.canvas);
            this.studio.setPainter(new DefaultPainter(this.editorPane.getPainterStudio()));
        } else {
            boolean bl = this.selected.isSelected((BWidget)this.canvas);
            this.selected.deselectAll();
            if (!bl) {
                this.selected.select((BWidget)this.canvas);
            }
        }
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        return new UnpressedTracker(this.editorPane);
    }

    public Tracker keyPressed(BKeyEvent bKeyEvent) {
        this.studio.setShiftDown(bKeyEvent.isShiftDown());
        if (bKeyEvent.getKeyCode() == 27) {
            this.studio.setPainter(new DefaultPainter(this.editorPane.getPainterStudio()));
            return new UnpressedTracker(this.editorPane);
        }
        return this;
    }

    private void makeRubberBand(BMouseEvent bMouseEvent) {
        Point point = this.studio.toViewbox(bMouseEvent.getX(), bMouseEvent.getY(), this.canvas);
        this.rubberBand[0] = GeomUtil.makeRectangle((double)this.anchor.x, (double)this.anchor.y, (double)point.x, (double)point.y);
    }

    public Geom[] geoms() {
        return this.rubberBand;
    }
}

