/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BSplitPane;

public class PassThroughTracker
extends Tracker {
    private TrackerStudio studio;
    private BWidget widget;
    private double beforeDivWidth;

    public PassThroughTracker(BPxEditorPane bPxEditorPane, BWidget bWidget) {
        super(bPxEditorPane);
        this.widget = bWidget;
        this.studio = bPxEditorPane.getTrackerStudio();
        if (bWidget instanceof BSplitPane) {
            this.beforeDivWidth = ((BSplitPane)bWidget).getDividerPosition();
        }
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        this.widget.mouseDragged(this.makeMouseEvent(this.studio, this.widget, bMouseEvent));
        this.editorPane.forceRootLayout();
        this.editorPane.repaint();
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        this.widget.mouseReleased(this.makeMouseEvent(this.studio, this.widget, bMouseEvent));
        this.studio.setMouseCursor(MouseCursor.normal);
        if (this.widget instanceof BSplitPane) {
            double d = ((BSplitPane)this.widget).getDividerPosition();
            new ChangeDividerPosition((BSplitPane)this.widget, this.beforeDivWidth, d).invoke();
        } else {
            this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        }
        return new UnpressedTracker(this.editorPane);
    }

    class ChangeDividerPosition
    extends Command {
        BSplitPane pane;
        double before;
        double after;

        ChangeDividerPosition(BSplitPane bSplitPane, double d, double d2) {
            super((BWidget)PassThroughTracker.this.editorPane, "changeDividerPosition");
            this.pane = bSplitPane;
            this.before = d;
            this.after = d2;
        }

        public CommandArtifact doInvoke() throws Exception {
            Artifact artifact = new Artifact();
            artifact.redo();
            return artifact;
        }

        class Artifact
        implements CommandArtifact {
            Artifact() {
            }

            public void redo() throws Exception {
                ChangeDividerPosition.this.pane.setDividerPosition(ChangeDividerPosition.this.after);
                this.update();
            }

            public void undo() throws Exception {
                ChangeDividerPosition.this.pane.setDividerPosition(ChangeDividerPosition.this.before);
                this.update();
            }

            void update() {
                ((ChangeDividerPosition)ChangeDividerPosition.this).PassThroughTracker.this.editorPane.getSelectedWidgets().deselectAll();
                ((ChangeDividerPosition)ChangeDividerPosition.this).PassThroughTracker.this.editorPane.getSelectedWidgets().select((BWidget)ChangeDividerPosition.this.pane);
                ((ChangeDividerPosition)ChangeDividerPosition.this).PassThroughTracker.this.editor.firePxEvent(new PxWidgetEvent(2, (BWidget)ChangeDividerPosition.this.pane, "dividerPosition", ChangeDividerPosition.this.pane.get("dividerPosition")));
            }
        }
    }
}

