/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.PathArtisan;
import com.tridium.px.editor.studio.artisans.PolygonArtisan;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.commands.MorphWidget;
import com.tridium.px.editor.studio.painters.PointPainter;
import com.tridium.px.editor.studio.trackers.GeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;
import javax.baja.ui.shape.BPolygon;

public class DeletePointTracker
extends GeometryTracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;

    public DeletePointTracker(BPxEditorPane bPxEditorPane, TrackerStudio trackerStudio) {
        super(bPxEditorPane);
        this.studio = trackerStudio;
        this.selected = bPxEditorPane.getSelectedWidgets();
        this.selected.deselectAll();
        trackerStudio.setPainter(new PointPainter(bPxEditorPane.getPainterStudio(), this.selected));
        this.selectShapes(this.selected, (BWidget)bPxEditorPane.getRootContainer());
        bPxEditorPane.repaint();
    }

    public Tracker mousePressed(BMouseEvent bMouseEvent) {
        double d;
        if (bMouseEvent.getClickCount() != 1 || !bMouseEvent.isButton1Down()) {
            return this;
        }
        double d2 = bMouseEvent.getX();
        Handle handle = this.selected.getHandle(d2, d = bMouseEvent.getY());
        if (handle != null) {
            if (!(handle.widget instanceof BPath) && !(handle.widget instanceof BPolygon)) {
                throw new IllegalStateException();
            }
            this.deletePoint(handle);
        }
        this.editorPane.repaint();
        return this;
    }

    private void deletePoint(Handle handle) {
        if (handle.widget instanceof BPath) {
            PathArtisan pathArtisan = new PathArtisan();
            BPath bPath = (BPath)handle.widget;
            BPathGeom bPathGeom = bPath.getGeom();
            if (bPathGeom.size() <= 2) {
                return;
            }
            Array array = new Array((Object[])bPathGeom.segments());
            Role role = (Role)handle.role;
            array.remove(role.idx);
            IPathGeom.Segment[] segmentArray = (IPathGeom.Segment[])array.trim();
            if (role.idx == 0) {
                Point point = pathArtisan.artisan.point(null, segmentArray[0]);
                segmentArray[0] = new IPathGeom.MoveTo(true, point.x, point.y);
            }
            bPathGeom = BPathGeom.make((IPathGeom.Segment[])segmentArray);
            new MorphWidget(this.editorPane, (BWidget)bPath, (IGeom)bPath.getGeom(), (IGeom)bPathGeom, pathArtisan).invoke();
        } else if (handle.widget instanceof BPolygon) {
            int n;
            BPolygon bPolygon = (BPolygon)handle.widget;
            BPolygonGeom bPolygonGeom = bPolygon.getGeom();
            if (bPolygonGeom.size() <= 3) {
                return;
            }
            double[] dArray = bPolygonGeom.x();
            double[] dArray2 = bPolygonGeom.y();
            for (int i = n = ((Integer)handle.role).intValue(); i < bPolygonGeom.size() - 1; ++i) {
                dArray[i] = dArray[i + 1];
                dArray2[i] = dArray2[i + 1];
            }
            bPolygonGeom = BPolygonGeom.make((double[])dArray, (double[])dArray2, (int)(bPolygonGeom.size() - 1));
            new MorphWidget(this.editorPane, (BWidget)bPolygon, (IGeom)bPolygon.getGeom(), (IGeom)bPolygonGeom, new PolygonArtisan()).invoke();
        } else {
            throw new IllegalStateException();
        }
    }
}

