/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.trackers.AddGeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Geom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.PathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;

public class AddPathTracker
extends AddGeometryTracker {
    private boolean dragged = false;

    public AddPathTracker(BPxEditorPane bPxEditorPane, TrackerStudio trackerStudio) {
        super(bPxEditorPane, trackerStudio);
    }

    protected boolean widgetMakeable() {
        return this.handles.size() >= 2;
    }

    protected BWidget makeWidget() {
        BPath bPath = new BPath((IPathGeom)this.pathGeom(false));
        bPath.setStroke(BBrush.makeSolid((BColor)BColor.black));
        return bPath;
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        if (!this.dragged && this.moved(bMouseEvent)) {
            this.dragged = true;
        }
        if (this.dragged) {
            Point point = this.studio.toViewbox(bMouseEvent.getX(), bMouseEvent.getY(), this.canvas);
            point = this.studio.snap(point.x, point.y);
            this.bars.set(this.bars.size() - 1, (Object)point);
        }
        this.editorPane.repaint();
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        if (this.dragged) {
            Point point = this.studio.toViewbox(bMouseEvent.getX(), bMouseEvent.getY(), this.canvas);
            point = this.studio.snap(point.x, point.y);
            this.bars.set(this.bars.size() - 1, (Object)point);
            this.dragged = false;
        }
        this.editorPane.repaint();
        return this;
    }

    public Geom[] geoms() {
        if (this.handles.size() == 0) {
            return new Geom[0];
        }
        return new Geom[]{this.pathGeom(true)};
    }

    private PathGeom pathGeom(boolean bl) {
        int n = this.handles.size();
        if (n == 0) {
            return null;
        }
        int n2 = bl ? n + 1 : n;
        Point[] pointArray = new Point[n2];
        Point[] pointArray2 = new Point[n2];
        Point[] pointArray3 = new Point[n2];
        for (int i = 0; i < n; ++i) {
            Point point = (Point)this.handles.get(i);
            pointArray[i] = new Point(point.x, point.y);
            point = (Point)this.bars.get(i);
            if (point == null) continue;
            pointArray2[i] = new Point(point.x, point.y);
            double d = pointArray2[i].x - pointArray[i].x;
            double d2 = pointArray2[i].y - pointArray[i].y;
            pointArray3[i] = new Point(pointArray[i].x - d, pointArray[i].y - d2);
        }
        if (bl) {
            pointArray[n] = new Point(this.mouse.x, this.mouse.y);
        }
        IPathGeom.Segment[] segmentArray = new IPathGeom.Segment[n2];
        segmentArray[0] = new IPathGeom.MoveTo(true, pointArray[0].x, pointArray[0].y);
        segmentArray[1] = pointArray2[0] == null ? (pointArray2[1] == null ? new IPathGeom.LineTo(true, pointArray[1].x, pointArray[1].y) : new IPathGeom.QuadTo(true, pointArray3[1].x, pointArray3[1].y, pointArray[1].x, pointArray[1].y)) : (pointArray2[1] == null ? new IPathGeom.QuadTo(true, pointArray2[0].x, pointArray2[0].y, pointArray[1].x, pointArray[1].y) : new IPathGeom.CurveTo(true, pointArray2[0].x, pointArray2[0].y, pointArray3[1].x, pointArray3[1].y, pointArray[1].x, pointArray[1].y));
        for (int i = 2; i < n2; ++i) {
            if (pointArray2[i - 1] == null) {
                if (pointArray2[i] == null) {
                    segmentArray[i] = new IPathGeom.LineTo(true, pointArray[i].x, pointArray[i].y);
                    continue;
                }
                segmentArray[i] = new IPathGeom.QuadTo(true, pointArray3[i].x, pointArray3[i].y, pointArray[i].x, pointArray[i].y);
                continue;
            }
            segmentArray[i] = pointArray2[i] == null ? new IPathGeom.SmoothQuadTo(true, pointArray[i].x, pointArray[i].y) : new IPathGeom.SmoothCurveTo(true, pointArray3[i].x, pointArray3[i].y, pointArray[i].x, pointArray[i].y);
        }
        return new PathGeom(segmentArray, n2);
    }
}

