/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.InsertDynamic;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.painters.AddGeometryPainter;
import com.tridium.px.editor.studio.trackers.GeomSupplier;
import com.tridium.px.editor.studio.trackers.GeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Reflector;
import javax.baja.gx.BTransform;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;

public abstract class AddGeometryTracker
extends GeometryTracker
implements GeomSupplier {
    protected TrackerStudio studio;
    private AddGeometryPainter painter;
    protected BCanvasPane canvas;
    protected Array handles = new Array(class$javax$baja$gx$Point == null ? (class$javax$baja$gx$Point = AddGeometryTracker.class$("javax.baja.gx.Point")) : class$javax$baja$gx$Point);
    protected Array bars = new Array(class$javax$baja$gx$Point == null ? (class$javax$baja$gx$Point = AddGeometryTracker.class$("javax.baja.gx.Point")) : class$javax$baja$gx$Point);
    protected Point mouse;
    public BTransform scaleTransform;
    public Point pageOffset;
    static /* synthetic */ Class class$javax$baja$gx$Point;

    public AddGeometryTracker(BPxEditorPane bPxEditorPane, TrackerStudio trackerStudio) {
        super(bPxEditorPane);
        this.studio = trackerStudio;
        bPxEditorPane.getSelectedWidgets().deselectAll();
        this.painter = new AddGeometryPainter(bPxEditorPane.getPainterStudio(), this);
        trackerStudio.setPainter(this.painter);
        this.editor.firePxEvent(new PxSelectionEvent(bPxEditorPane.getSelectedWidgets().getWidgets()));
    }

    protected abstract boolean widgetMakeable();

    protected abstract BWidget makeWidget();

    public Tracker mouseMoved(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (this.canvas != null) {
            this.mouse = this.studio.toViewbox(d, d2, this.canvas);
            this.mouse = this.studio.snap(this.mouse.x, this.mouse.y);
            this.editorPane.repaint();
        }
        return this;
    }

    public Tracker mousePressed(BMouseEvent bMouseEvent) {
        double d;
        if (bMouseEvent.getClickCount() != 1 || !bMouseEvent.isButton1Down()) {
            return this;
        }
        double d2 = bMouseEvent.getX();
        BWidget bWidget = this.studio.rootDescendant(new Point(d2, d = bMouseEvent.getY()));
        BCanvasPane bCanvasPane = Reflector.canvas(bWidget);
        if (bCanvasPane != null) {
            if (bCanvasPane != this.canvas) {
                this.handles.clear();
                this.bars.clear();
                this.canvas = bCanvasPane;
            }
            this.mouse = this.studio.toViewbox(d2, d, bCanvasPane);
            this.mouse = this.studio.snap(this.mouse.x, this.mouse.y);
            this.handles.add((Object)this.mouse);
            this.bars.add(null);
            this.scaleTransform = bCanvasPane.getScaleTransform();
            this.pageOffset = this.studio.translateToRoot((BWidget)bCanvasPane, new Point(0.0, 0.0));
            this.editorPane.repaint();
        }
        return this;
    }

    public Tracker keyTyped(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyChar() == '\u001b') {
            if (this.widgetMakeable()) {
                BWidget[] bWidgetArray = new BWidget[]{this.makeWidget()};
                try {
                    InsertDynamic insertDynamic = new InsertDynamic(this.editor, this.editorPane, (BWidget)this.canvas, bWidgetArray);
                    if (insertDynamic.checkMedia()) {
                        insertDynamic.doInvoke();
                    }
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
                this.editorPane.getSelectedWidgets().deselectAll();
                this.painter.reset();
            }
            this.handles.clear();
            this.bars.clear();
            this.editorPane.repaint();
        }
        return this;
    }

    public Point[] handles() {
        return this.convert((Point[])this.handles.trim());
    }

    public Point[] bars() {
        return this.convert((Point[])this.bars.trim());
    }

    private Point[] convert(Point[] pointArray) {
        Point[] pointArray2 = new Point[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            if (pointArray[i] == null) continue;
            pointArray2[i] = this.studio.fromViewbox(pointArray[i].x, pointArray[i].y, this.canvas);
        }
        return pointArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

