/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.painters;

import com.tridium.px.editor.studio.PainterStudio;
import com.tridium.px.editor.studio.painters.Painter;
import com.tridium.px.editor.studio.trackers.GeomSupplier;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Geom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;

public class GeomPainter
extends Painter {
    private PainterStudio studio;
    private GeomSupplier supplier;
    private BTransform scaleTransform;
    private Point pageOffset;

    public GeomPainter(PainterStudio painterStudio, GeomSupplier geomSupplier, BTransform bTransform, Point point) {
        this.studio = painterStudio;
        this.supplier = geomSupplier;
        this.scaleTransform = bTransform;
        this.pageOffset = point;
        painterStudio.buffer();
    }

    public synchronized void doPaint(Graphics graphics) {
        this.studio.paintBuffer(graphics);
        graphics.setBrush(BColor.black);
        graphics.setPen(BPen.DEFAULT);
        graphics.translate(this.pageOffset.x, this.pageOffset.y);
        graphics.transform(this.scaleTransform);
        Geom[] geomArray = this.supplier.geoms();
        for (int i = 0; i < geomArray.length; ++i) {
            if (geomArray[i] == null) continue;
            graphics.stroke((IGeom)geomArray[i]);
        }
        graphics.transform(this.scaleTransform.getInverse());
        graphics.translate(-this.pageOffset.x, -this.pageOffset.y);
    }
}

