/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.util.EventUtil;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class MoveWidget
extends Command {
    private BPxEditorPane editorPane;
    private BWidget[] widgets;
    private double deltaX;
    private double deltaY;
    private Artifact artifact = new Artifact();

    public MoveWidget(BPxEditorPane bPxEditorPane, BWidget[] bWidgetArray, double d, double d2) {
        super((BWidget)bPxEditorPane, BPxEditorPane.lexicon(), "commands.move");
        this.editorPane = bPxEditorPane;
        this.widgets = bWidgetArray;
        this.deltaX = d;
        this.deltaY = d2;
    }

    public CommandArtifact doInvoke() throws Exception {
        this.artifact.redo();
        return this.artifact;
    }

    public static double getMinX(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.x;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.min(d, rectGeom.x);
        }
        return d;
    }

    public static double getMaxX(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.x + rectGeom.width;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.max(d, rectGeom.x + rectGeom.width);
        }
        return d;
    }

    public static double getCenterX(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.x;
        double d2 = rectGeom.x + rectGeom.width;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.min(rectGeom.x, d);
            d2 = Math.max(rectGeom.x + rectGeom.width, d2);
        }
        return (d2 + d) / 2.0;
    }

    public static double getMinY(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.y;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.min(d, rectGeom.y);
        }
        return d;
    }

    public static double getMaxY(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.y + rectGeom.height;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.max(d, rectGeom.y + rectGeom.height);
        }
        return d;
    }

    public static double getCenterY(BWidget[] bWidgetArray, Artisan artisan) {
        RectGeom rectGeom = artisan.bounds(bWidgetArray[0]);
        double d = rectGeom.y;
        double d2 = rectGeom.y + rectGeom.height;
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = artisan.bounds(bWidgetArray[i]);
            d = Math.min(rectGeom.y, d);
            d2 = Math.max(rectGeom.y + rectGeom.height, d2);
        }
        return (d2 + d) / 2.0;
    }

    public static String[] shiftWidgets(BWidget[] bWidgetArray, Artisan artisan, double d, double d2) {
        String[] stringArray = new String[bWidgetArray.length];
        for (int i = 0; i < bWidgetArray.length; ++i) {
            stringArray[i] = artisan.move(bWidgetArray[i], d, d2);
        }
        return stringArray;
    }

    public static void toZero(BWidget[] bWidgetArray, Artisan artisan) {
        for (int i = 0; i < bWidgetArray.length; ++i) {
            artisan.zero(bWidgetArray[i]);
        }
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            this.doCmd(MoveWidget.this.deltaX, MoveWidget.this.deltaY);
        }

        public void undo() throws Exception {
            this.doCmd(-MoveWidget.this.deltaX, -MoveWidget.this.deltaY);
        }

        private void doCmd(double d, double d2) throws Exception {
            Artisan artisan = Artisan.instance();
            MoveWidget.this.editorPane.getSelectedWidgets().setWidgets(MoveWidget.this.widgets);
            String[] stringArray = MoveWidget.shiftWidgets(MoveWidget.this.widgets, artisan, d, d2);
            for (int i = 0; i < MoveWidget.this.widgets.length; ++i) {
                MoveWidget.this.widgets[i].getParentWidget().relayout();
            }
            MoveWidget.this.editorPane.getPxEditor().firePxEvent(EventUtil.widgetsChanged(MoveWidget.this.widgets, stringArray));
        }
    }
}

