/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.util.EventUtil;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class Align
extends Command {
    private BPxEditorPane editorPane;
    private boolean horiz;
    private int type;
    private Artisan artisan = Artisan.instance();
    private BWidget[] widgets;
    private double[] deltaX;
    private double[] deltaY;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int CENTER = 2;

    public Align(BPxEditorPane bPxEditorPane, boolean bl, int n) {
        super((BWidget)bPxEditorPane, BPxEditorPane.lexicon(), bl ? (n == 0 ? "commands.align.left" : (n == 1 ? "commands.align.right" : "commands.align.center")) : (n == 0 ? "commands.align.top" : (n == 1 ? "commands.align.bottom" : "commands.align.middle")));
        this.editorPane = bPxEditorPane;
        this.type = n;
        this.horiz = bl;
    }

    public CommandArtifact doInvoke() throws Exception {
        block17: {
            double d;
            block16: {
                this.widgets = this.editorPane.getSelectedWidgets().getWidgets();
                this.deltaX = new double[this.widgets.length];
                this.deltaY = new double[this.widgets.length];
                if (!this.horiz) break block16;
                switch (this.type) {
                    case 0: {
                        d = MoveWidget.getMinX(this.widgets, this.artisan);
                        for (int i = 0; i < this.widgets.length; ++i) {
                            RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                            this.deltaX[i] = d - rectGeom.x;
                        }
                        break block17;
                    }
                    case 1: {
                        d = MoveWidget.getMaxX(this.widgets, this.artisan);
                        for (int i = 0; i < this.widgets.length; ++i) {
                            RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                            this.deltaX[i] = d - (rectGeom.x + rectGeom.width);
                        }
                        break block17;
                    }
                    case 2: {
                        d = MoveWidget.getCenterX(this.widgets, this.artisan);
                        for (int i = 0; i < this.widgets.length; ++i) {
                            RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                            this.deltaX[i] = d - (rectGeom.x + rectGeom.width / 2.0);
                        }
                        break;
                    }
                }
                break block17;
            }
            switch (this.type) {
                case 0: {
                    d = MoveWidget.getMinY(this.widgets, this.artisan);
                    for (int i = 0; i < this.widgets.length; ++i) {
                        RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                        this.deltaY[i] = d - rectGeom.y;
                    }
                    break;
                }
                case 1: {
                    d = MoveWidget.getMaxY(this.widgets, this.artisan);
                    for (int i = 0; i < this.widgets.length; ++i) {
                        RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                        this.deltaY[i] = d - (rectGeom.y + rectGeom.height);
                    }
                    break;
                }
                case 2: {
                    d = MoveWidget.getCenterY(this.widgets, this.artisan);
                    for (int i = 0; i < this.widgets.length; ++i) {
                        RectGeom rectGeom = this.artisan.bounds(this.widgets[i]);
                        this.deltaY[i] = d - (rectGeom.y + rectGeom.height / 2.0);
                    }
                    break;
                }
            }
        }
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            String[] stringArray = new String[Align.this.widgets.length];
            for (int i = 0; i < Align.this.widgets.length; ++i) {
                stringArray[i] = Align.this.artisan.move(Align.this.widgets[i], Align.this.deltaX[i], Align.this.deltaY[i]);
            }
            this.update(stringArray);
        }

        public void undo() throws Exception {
            String[] stringArray = new String[Align.this.widgets.length];
            for (int i = 0; i < Align.this.widgets.length; ++i) {
                stringArray[i] = Align.this.artisan.move(Align.this.widgets[i], -Align.this.deltaX[i], -Align.this.deltaY[i]);
            }
            this.update(stringArray);
        }

        private void update(String[] stringArray) {
            Align.this.editorPane.getSelectedWidgets().setWidgets(Align.this.widgets);
            Align.this.editorPane.getPxEditor().firePxEvent(EventUtil.widgetsChanged(Align.this.widgets, stringArray));
        }
    }
}

