/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class QuadTo
extends SegmentArtisan {
    public Point point(Point point, IPathGeom.Segment segment) {
        IPathGeom.QuadTo quadTo = (IPathGeom.QuadTo)segment;
        return new Point(quadTo.getX(), quadTo.getY());
    }

    public IPathGeom.Segment move(Point point, IPathGeom.Segment segment, double d, double d2) {
        if (segment.isRelative()) {
            return segment;
        }
        IPathGeom.QuadTo quadTo = (IPathGeom.QuadTo)segment;
        return new IPathGeom.QuadTo(quadTo.isAbsolute(), quadTo.getX1() + d, quadTo.getY1() + d2, quadTo.getX() + d, quadTo.getY() + d2);
    }

    public Point paintBars(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment) {
        IPathGeom.QuadTo quadTo = (IPathGeom.QuadTo)segment;
        Point point2 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX(), quadTo.getY());
        Point point3 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX1(), quadTo.getY1());
        QuadTo.paintBar(graphics, trackerStudio, bPath, point2, point3, BColor.fuchsia);
        return point2;
    }

    public Point paintHandles(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment) {
        IPathGeom.QuadTo quadTo = (IPathGeom.QuadTo)segment;
        Point point2 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX(), quadTo.getY());
        Point point3 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX1(), quadTo.getY1());
        QuadTo.paintHandle(graphics, trackerStudio, bPath, point2, BColor.lime);
        return point2;
    }

    public Point addHandles(TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment, int n, PointMap pointMap) {
        IPathGeom.QuadTo quadTo = (IPathGeom.QuadTo)segment;
        Point point2 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX(), quadTo.getY());
        Point point3 = QuadTo.nextPoint(point, quadTo.isAbsolute(), quadTo.getX1(), quadTo.getY1());
        Point point4 = QuadTo.mirror(point2, point3);
        QuadTo.addHandle(trackerStudio, bPath, point2, pointMap, MouseCursor.move, new QuadToRole(point2, n, 0, point2, point3));
        QuadTo.addHandle(trackerStudio, bPath, point3, pointMap, MouseCursor.move, new QuadToRole(point3, n, 1, point2, point3, false));
        QuadTo.addHandle(trackerStudio, bPath, point4, pointMap, MouseCursor.move, new QuadToRole(point4, n, 1, point2, point4, true));
        return point2;
    }

    static class QuadToRole
    extends Role {
        int which;
        Point p0;
        Point p1;
        boolean mirror;

        QuadToRole(Point point, int n, int n2, Point point2, Point point3) {
            super(point, n);
            this.which = n2;
            this.p0 = point2;
            this.p1 = point3;
        }

        QuadToRole(Point point, int n, int n2, Point point2, Point point3, boolean bl) {
            super(point, n);
            this.which = n2;
            this.p0 = point2;
            this.p1 = point3;
            this.mirror = bl;
        }

        public IPathGeom.Segment apply(double d, double d2) {
            if (this.which == 0) {
                return new IPathGeom.QuadTo(true, this.p1.x, this.p1.y, this.orig.x + d, this.orig.y + d2);
            }
            if (this.mirror) {
                Point point = new Point(this.orig.x + d, this.orig.y + d2);
                point = SegmentArtisan.mirror(this.p0, point);
                return new IPathGeom.QuadTo(true, point.x, point.y, this.p0.x, this.p0.y);
            }
            return new IPathGeom.QuadTo(true, this.orig.x + d, this.orig.y + d2, this.p0.x, this.p0.y);
        }
    }
}

