/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class ArcTo
extends SegmentArtisan {
    public Point point(Point point, IPathGeom.Segment segment) {
        IPathGeom.ArcTo arcTo = (IPathGeom.ArcTo)segment;
        return new Point(arcTo.getX(), arcTo.getY());
    }

    public IPathGeom.Segment move(Point point, IPathGeom.Segment segment, double d, double d2) {
        if (segment.isRelative()) {
            return segment;
        }
        IPathGeom.ArcTo arcTo = (IPathGeom.ArcTo)segment;
        return new IPathGeom.ArcTo(arcTo.isAbsolute(), arcTo.getRadiusX() + d, arcTo.getRadiusY() + d2, arcTo.getXAxisRotation(), arcTo.getLargeArcFlag(), arcTo.getSweepFlag(), arcTo.getX() + d, arcTo.getY() + d2);
    }

    public Point paintBars(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment) {
        IPathGeom.ArcTo arcTo = (IPathGeom.ArcTo)segment;
        Point point2 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getX(), arcTo.getY());
        Point point3 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getRadiusX(), arcTo.getRadiusY());
        Point point4 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point3.x, point3.y));
        Point point5 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point.x, point.y));
        Point point6 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point2.x, point2.y));
        graphics.setBrush(BColor.fuchsia);
        graphics.strokeLine(point5.x, point5.y, point4.x, point4.y);
        graphics.strokeLine(point6.x, point6.y, point4.x, point4.y);
        return point2;
    }

    public Point paintHandles(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment) {
        IPathGeom.ArcTo arcTo = (IPathGeom.ArcTo)segment;
        Point point2 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getX(), arcTo.getY());
        Point point3 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getRadiusX(), arcTo.getRadiusY());
        ArcTo.paintHandle(graphics, trackerStudio, bPath, point2, BColor.lime);
        ArcTo.paintHandle(graphics, trackerStudio, bPath, point3, BColor.fuchsia);
        return point2;
    }

    public Point addHandles(TrackerStudio trackerStudio, BPath bPath, Point point, IPathGeom.Segment segment, int n, PointMap pointMap) {
        IPathGeom.ArcTo arcTo = (IPathGeom.ArcTo)segment;
        Point point2 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getX(), arcTo.getY());
        Point point3 = ArcTo.nextPoint(point, arcTo.isAbsolute(), arcTo.getRadiusX(), arcTo.getRadiusY());
        ArcTo.addHandle(trackerStudio, bPath, point2, pointMap, MouseCursor.move, new Next(n, point2, arcTo));
        ArcTo.addHandle(trackerStudio, bPath, point3, pointMap, MouseCursor.move, new Radius(n, point3, arcTo));
        return point2;
    }

    static class Radius
    extends Role {
        Point rad;
        IPathGeom.ArcTo arc;

        Radius(int n, Point point, IPathGeom.ArcTo arcTo) {
            super(point, n);
            this.rad = point;
            this.arc = arcTo;
        }

        public IPathGeom.Segment apply(double d, double d2) {
            return new IPathGeom.ArcTo(this.arc.isAbsolute(), this.rad.x + d, this.rad.y + d2, this.arc.getXAxisRotation(), this.arc.getLargeArcFlag(), this.arc.getSweepFlag(), this.arc.getX(), this.arc.getY());
        }
    }

    static class Next
    extends Role {
        Point next;
        IPathGeom.ArcTo arc;

        Next(int n, Point point, IPathGeom.ArcTo arcTo) {
            super(point, n);
            this.next = point;
            this.arc = arcTo;
        }

        public IPathGeom.Segment apply(double d, double d2) {
            return new IPathGeom.ArcTo(this.arc.isAbsolute(), this.arc.getRadiusX() + d, this.arc.getRadiusY() + d2, this.arc.getXAxisRotation(), this.arc.getLargeArcFlag(), this.arc.getSweepFlag(), this.next.x + d, this.next.y + d2);
        }
    }
}

