/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.RectangularHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;

public abstract class RectangularArtisan
extends Artisan {
    private static final MouseCursor DNE = MouseCursor.doNotEnter;

    protected final void paintRect(RectGeom rectGeom, Graphics graphics) {
        double d = rectGeom.width;
        double d2 = rectGeom.height;
        graphics.setPen(BPen.DEFAULT);
        graphics.setBrush(BColor.lime);
        graphics.strokeRect(rectGeom.x, rectGeom.y, d, d2);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x, rectGeom.y);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x + d, rectGeom.y);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x, rectGeom.y + d2);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x + d, rectGeom.y + d2);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x, rectGeom.y + d2 / 2.0);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x + d, rectGeom.y + d2 / 2.0);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x + d / 2.0, rectGeom.y);
        RectangularArtisan.paintHandle(graphics, BColor.lime, rectGeom.x + d / 2.0, rectGeom.y + d2);
    }

    protected final void addRectHandles(BWidget bWidget, PointMap pointMap, RectGeom rectGeom, boolean bl) {
        double d = rectGeom.width;
        double d2 = rectGeom.height;
        RectangularArtisan.addHandle(rectGeom.x, rectGeom.y, pointMap, bWidget, bl ? DNE : MouseCursor.nwResize, bl ? DNE : MouseCursor.nwResize);
        RectangularArtisan.addHandle(rectGeom.x + d, rectGeom.y, pointMap, bWidget, bl ? DNE : MouseCursor.neResize, bl ? DNE : MouseCursor.neResize);
        RectangularArtisan.addHandle(rectGeom.x, rectGeom.y + d2, pointMap, bWidget, bl ? DNE : MouseCursor.swResize, bl ? DNE : MouseCursor.swResize);
        RectangularArtisan.addHandle(rectGeom.x + d, rectGeom.y + d2, pointMap, bWidget, bl ? DNE : MouseCursor.seResize, bl ? DNE : MouseCursor.seResize);
        RectangularArtisan.addHandle(rectGeom.x, rectGeom.y + d2 / 2.0, pointMap, bWidget, bl ? DNE : MouseCursor.wResize, bl ? DNE : MouseCursor.wResize);
        RectangularArtisan.addHandle(rectGeom.x + d, rectGeom.y + d2 / 2.0, pointMap, bWidget, bl ? DNE : MouseCursor.eResize, bl ? DNE : MouseCursor.eResize);
        RectangularArtisan.addHandle(rectGeom.x + d / 2.0, rectGeom.y, pointMap, bWidget, bl ? DNE : MouseCursor.nResize, bl ? DNE : MouseCursor.nResize);
        RectangularArtisan.addHandle(rectGeom.x + d / 2.0, rectGeom.y + d2, pointMap, bWidget, bl ? DNE : MouseCursor.sResize, bl ? DNE : MouseCursor.sResize);
    }

    public IGeom translateGeom(BWidget bWidget, double d, double d2) {
        RectGeom rectGeom = this.bounds(bWidget);
        rectGeom.x += d;
        rectGeom.y += d2;
        return rectGeom;
    }

    public HandleTracker makeHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, boolean bl) {
        return RectangularHandleTracker.make(bPxEditorPane, handle, this, bl);
    }
}

