/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.awt.se.AwtUtil;
import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.artisans.path.Router;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.PathHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.PathGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.shape.BPath;

public class PathArtisan
extends Artisan {
    public SegmentArtisan artisan = new Router();

    public void paintSelected(TrackerStudio trackerStudio, BWidget bWidget, Graphics graphics) {
        int n;
        BPath bPath = (BPath)bWidget;
        BPathGeom bPathGeom = bPath.getGeom();
        Point point = this.newPen(bPathGeom);
        for (n = 0; n < bPathGeom.size(); ++n) {
            point = this.artisan.paintBars(graphics, trackerStudio, bPath, point, bPathGeom.segment(n));
        }
        point = this.newPen(bPathGeom);
        for (n = 0; n < bPathGeom.size(); ++n) {
            point = this.artisan.paintHandles(graphics, trackerStudio, bPath, point, bPathGeom.segment(n));
        }
    }

    public RectGeom bounds(BWidget bWidget) {
        BPath bPath = (BPath)bWidget;
        BPathGeom bPathGeom = bPath.getGeom();
        Point[] pointArray = AwtUtil.flatten((BPathGeom)bPathGeom, (double)3.0);
        RectGeom rectGeom = new RectGeom(pointArray[0].x, pointArray[0].y, 0.0, 0.0);
        for (int i = 1; i < pointArray.length; ++i) {
            rectGeom = RectGeom.bounds((double)rectGeom.x, (double)rectGeom.y, (double)rectGeom.width, (double)rectGeom.height, (double)pointArray[i].x, (double)pointArray[i].y, (double)0.0, (double)0.0, (RectGeom)rectGeom);
        }
        return rectGeom;
    }

    public String move(BWidget bWidget, double d, double d2) {
        BPath bPath = (BPath)bWidget;
        BPathGeom bPathGeom = bPath.getGeom();
        IPathGeom.Segment[] segmentArray = bPathGeom.segments();
        Point point = this.newPen(bPathGeom);
        for (int i = 0; i < segmentArray.length; ++i) {
            segmentArray[i] = this.artisan.move(point, segmentArray[i], d, d2);
            point = this.artisan.point(point, segmentArray[i]);
        }
        bPath.setGeom(BPathGeom.make((IPathGeom.Segment[])segmentArray));
        return "geom";
    }

    public String zero(BWidget bWidget) {
        RectGeom rectGeom = this.bounds(bWidget);
        return this.move(bWidget, -rectGeom.x, -rectGeom.y);
    }

    public IGeom translateGeom(BWidget bWidget, double d, double d2) {
        BPath bPath = (BPath)bWidget;
        BPathGeom bPathGeom = bPath.getGeom();
        IPathGeom.Segment[] segmentArray = bPathGeom.segments();
        Point point = this.newPen(bPathGeom);
        for (int i = 0; i < segmentArray.length; ++i) {
            segmentArray[i] = this.artisan.move(point, segmentArray[i], d, d2);
            point = this.artisan.point(point, segmentArray[i]);
        }
        return new PathGeom(segmentArray, segmentArray.length);
    }

    public void addHandles(TrackerStudio trackerStudio, BWidget bWidget, PointMap pointMap) {
        BPath bPath = (BPath)bWidget;
        BPathGeom bPathGeom = bPath.getGeom();
        IPathGeom.Segment[] segmentArray = bPathGeom.segments();
        Point point = this.newPen(bPathGeom);
        for (int i = 0; i < segmentArray.length; ++i) {
            point = this.artisan.addHandles(trackerStudio, bPath, point, segmentArray[i], i, pointMap);
        }
    }

    public HandleTracker makeHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, boolean bl) {
        return new PathHandleTracker(bPxEditorPane, handle, this);
    }

    public String setGeom(BWidget bWidget, IGeom iGeom) {
        BPath bPath = (BPath)bWidget;
        IPathGeom iPathGeom = (IPathGeom)iGeom;
        bPath.setGeom(BPathGeom.make((IPathGeom.Segment[])iPathGeom.segments()));
        return "geom";
    }

    private Point newPen(BPathGeom bPathGeom) {
        int n = bPathGeom.size();
        if (n < 2) {
            throw new IllegalStateException();
        }
        IPathGeom.Segment segment = bPathGeom.segment(0);
        if (!(segment instanceof IPathGeom.MoveTo)) {
            throw new IllegalStateException();
        }
        if (!segment.isAbsolute()) {
            throw new IllegalStateException();
        }
        IPathGeom.MoveTo moveTo = (IPathGeom.MoveTo)segment;
        return new Point(moveTo.getX(), moveTo.getY());
    }
}

