/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.ArtisanRouter;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;

public abstract class Artisan {
    private static Artisan router = new ArtisanRouter();
    private static final int LARGE = 3;
    private static final int SMALL = 2;
    private static int handleSize = 3;

    public abstract RectGeom bounds(BWidget var1);

    public abstract String setGeom(BWidget var1, IGeom var2);

    public abstract void paintSelected(TrackerStudio var1, BWidget var2, Graphics var3);

    public abstract String move(BWidget var1, double var2, double var4);

    public abstract String zero(BWidget var1);

    public abstract IGeom translateGeom(BWidget var1, double var2, double var4);

    public abstract void addHandles(TrackerStudio var1, BWidget var2, PointMap var3);

    public abstract HandleTracker makeHandleTracker(BPxEditorPane var1, Handle var2, boolean var3);

    public RectGeom rootBounds(TrackerStudio trackerStudio, BWidget bWidget) {
        RectGeom rectGeom = this.bounds(bWidget);
        double d = rectGeom.x;
        double d2 = rectGeom.y;
        double d3 = rectGeom.width;
        double d4 = rectGeom.height;
        Point point = trackerStudio.translateToRoot(bWidget, new Point(d, d2));
        Point point2 = trackerStudio.translateToRoot(bWidget, new Point(d + d3, d2 + d4));
        return new RectGeom(point.x, point.y, point2.x - point.x, point2.y - point.y);
    }

    public static void paintHandle(Graphics graphics, BColor bColor, double d, double d2) {
        int n = handleSize * 2 + 1;
        graphics.setBrush(bColor);
        graphics.fillRect(d - (double)handleSize, d2 - (double)handleSize, (double)n, (double)n);
        if (handleSize == 3) {
            graphics.setBrush(BColor.black);
            graphics.strokeRect(d - (double)handleSize, d2 - (double)handleSize, (double)n, (double)n);
        }
    }

    public static void addHandle(double d, double d2, PointMap pointMap, BWidget bWidget, MouseCursor mouseCursor, Object object) {
        pointMap.put(d, d2, (Object)new Handle(new Point(d, d2), bWidget, mouseCursor, object));
    }

    public static RectGeom boundsUnion(Artisan artisan, BWidget[] bWidgetArray) {
        if (bWidgetArray.length == 0) {
            return null;
        }
        RectGeom rectGeom = new RectGeom((IRectGeom)artisan.bounds(bWidgetArray[0]));
        for (int i = 1; i < bWidgetArray.length; ++i) {
            rectGeom = RectGeom.bounds((IRectGeom)rectGeom, (IRectGeom)artisan.bounds(bWidgetArray[i]), (RectGeom)rectGeom);
        }
        return rectGeom;
    }

    public static Artisan instance() {
        return router;
    }

    public static void largeHandles() {
        handleSize = 3;
    }

    public static void smallHandles() {
        handleSize = 2;
    }
}

