/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio;

import com.tridium.gx.util.GeomUtil;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.Delete;
import com.tridium.px.editor.commands.EditPropertiesContext;
import com.tridium.px.editor.commands.Insert;
import com.tridium.px.editor.commands.InsertDynamic;
import com.tridium.px.editor.commands.InsertFrozen;
import com.tridium.px.editor.commands.Rename;
import com.tridium.px.editor.studio.CommandStudio;
import com.tridium.px.editor.studio.PainterStudio;
import com.tridium.px.editor.studio.RootStudio;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.TreeStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.studio.commands.PreferredSize;
import com.tridium.px.editor.studio.commands.Select;
import com.tridium.px.editor.studio.painters.DefaultPainter;
import com.tridium.px.editor.studio.painters.Painter;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import com.tridium.px.editor.util.MenuBuilder;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.px.editor.BIPxTransferWidget;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.factory.WidgetInserter;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;

public class BStudio
extends BTransferWidget
implements BIPxTransferWidget,
TreeStudio,
CommandStudio,
TrackerStudio,
RootStudio,
PainterStudio {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$studio$BStudio == null ? (class$com$tridium$px$editor$studio$BStudio = BStudio.class$("com.tridium.px.editor.studio.BStudio")) : class$com$tridium$px$editor$studio$BStudio));
    private static final int DRAG_LINE = 50;
    private static final BBrush DRAG_BRUSH = BColor.lime.toBrush();
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private Artisan artisan;
    private SelectedWidgets selected;
    private boolean isShiftDown;
    private Painter painter;
    private Tracker tracker;
    private boolean duplicating;
    private BWidget duplParent;
    private RectGeom[] duplBounds;
    private double popupX;
    private double popupY;
    private Point dragPoint;
    private RectGeom dragRect;
    private BImage bufferImage = null;
    static /* synthetic */ Class class$com$tridium$px$editor$studio$BStudio;

    public Type getType() {
        return TYPE;
    }

    public BStudio(BPxEditor bPxEditor, BPxEditorPane bPxEditorPane) {
        this.editor = bPxEditor;
        this.editorPane = bPxEditorPane;
        this.artisan = Artisan.instance();
        this.selected = bPxEditorPane.getSelectedWidgets();
        this.tracker = new UnpressedTracker(bPxEditorPane, this);
        this.painter = new DefaultPainter(this);
    }

    public void computePreferredSize() {
        this.editorPane.getRootContainer().computePreferredSize();
        this.setPreferredSize(this.editorPane.getRootContainer().getPreferredWidth(), this.editorPane.getRootContainer().getPreferredHeight());
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.editorPane.getRootContainer().setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        this.editorPane.forceRootLayout();
    }

    public void paint(Graphics graphics) {
        this.editorPane.getRootShellMgr().layoutWidgets();
        this.painter.doPaint(graphics);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX();
        BWidget bWidget = this.rootDescendant(new Point(d2, d = bMouseEvent.getY()));
        BCanvasPane bCanvasPane = Reflector.canvas(bWidget);
        if (bCanvasPane == null) {
            this.editorPane.updateStatus("");
        } else {
            Point point = this.toViewbox(d2, d, bCanvasPane);
            BSize bSize = bCanvasPane.getViewSize();
            if (new RectGeom(0.0, 0.0, bSize.width, bSize.height).contains(point.x, point.y)) {
                this.editorPane.updateStatus((int)point.x + ", " + (int)point.y);
            } else {
                this.editorPane.updateStatus("");
            }
        }
        this.tracker = this.tracker.mouseMoved(bMouseEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.requestFocus();
        this.tracker = this.tracker.mousePressed(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.tracker = this.tracker.mouseDragged(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.tracker = this.tracker.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.tracker = this.tracker.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.tracker = this.tracker.mouseExited(bMouseEvent);
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
        this.editor.setTransferWidget(this);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        this.tracker = this.tracker.keyPressed(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        this.tracker = this.tracker.keyReleased(bKeyEvent);
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        this.tracker = this.tracker.keyTyped(bKeyEvent);
    }

    public CommandArtifact doDuplicate() throws Exception {
        this.duplicating = true;
        return super.doDuplicate();
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.duplicating) {
            this.duplParent = this.selected.get(0).getParentWidget();
            BWidget[] bWidgetArray = this.selected.getWidgets();
            this.duplBounds = new RectGeom[bWidgetArray.length];
            for (int i = 0; i < bWidgetArray.length; ++i) {
                this.duplBounds[i] = this.artisan.bounds(bWidgetArray[i]);
            }
        }
        return this.selected.envelope();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return this.doDelete();
    }

    public CommandArtifact doDelete() throws Exception {
        if (this.selected.size() > 0 && this.editorPane.getLayerManager().allNormal(this.selected.getWidgets())) {
            return new Delete(this.editorPane).doInvoke();
        }
        return null;
    }

    public int dragOver(TransferContext transferContext) {
        if (this.preventEdits() || !this.editor.getController().allowDrop(this, transferContext)) {
            return 0;
        }
        BWidget bWidget = this.findDroppable(this.rootDescendant(new Point(transferContext.getX(), transferContext.getY())));
        if (!this.preventEdits() && bWidget != null && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            this.dragPoint = new Point(transferContext.getX(), transferContext.getY());
            if (bWidget instanceof BCanvasPane) {
                BCanvasPane bCanvasPane = (BCanvasPane)bWidget;
                Point point = this.toViewbox(transferContext.getX(), transferContext.getY(), bCanvasPane);
                Point point2 = this.snap(point.x, point.y);
                this.dragPoint = this.fromViewbox(point2.x, point2.y, bCanvasPane);
            }
            this.checkDrag();
            return 16;
        }
        this.dragPoint = null;
        this.checkDrag();
        return 0;
    }

    public void dragExit(TransferContext transferContext) {
        this.dragPoint = null;
        this.checkDrag();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        WidgetInserter widgetInserter;
        BWidget bWidget;
        BObject[] bObjectArray = ((Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues();
        BWidget bWidget2 = bWidget = this.duplicating ? this.duplParent : this.selected.get(0);
        if (!Reflector.isDroppable(bWidget)) {
            throw new IllegalStateException();
        }
        if (!Reflector.isFreeFormPane(bWidget)) {
            bObjectArray = new BObject[]{bObjectArray[0]};
        }
        if ((widgetInserter = this.editor.getController().getWidgetInserter(this, bObjectArray)) == null) {
            return null;
        }
        if (widgetInserter.getWidgets() == null) {
            return null;
        }
        if (widgetInserter.getWidgets().length == 0) {
            return null;
        }
        Insert insert = this.makeInsertCommand(bWidget, widgetInserter.getWidgets());
        this.popupX = 0.0;
        this.popupY = 0.0;
        this.duplicating = false;
        return this.makeInsertArtifact(insert, widgetInserter.getAuxillaryCommand());
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        WidgetInserter widgetInserter;
        if (this.preventEdits() || !this.editor.getController().allowDrop(this, transferContext)) {
            throw new IllegalStateException();
        }
        BObject[] bObjectArray = ((Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues();
        this.dragPoint = null;
        this.checkDrag();
        BWidget bWidget = this.findDroppable(this.rootDescendant(new Point(transferContext.getX(), transferContext.getY())));
        if (bWidget == null) {
            throw new IllegalStateException();
        }
        if (!Reflector.isFreeFormPane(bWidget)) {
            bObjectArray = new BObject[]{bObjectArray[0]};
        }
        if ((widgetInserter = this.editor.getController().getWidgetInserter(this, bObjectArray)) == null) {
            return null;
        }
        if (widgetInserter.getWidgets() == null) {
            return null;
        }
        if (widgetInserter.getWidgets().length == 0) {
            return null;
        }
        Insert insert = this.makeDropCommand(transferContext, bWidget, widgetInserter.getWidgets(), widgetInserter.getColumnCount());
        return this.makeInsertArtifact(insert, widgetInserter.getAuxillaryCommand());
    }

    public BMenu getDefaultPopupMenu(BMouseEvent bMouseEvent) {
        BMenu bMenu = new BMenu();
        this.populatePopupMenu(bMenu);
        return bMenu;
    }

    public void populatePopupMenu(BMenu bMenu) {
        BMenu bMenu2;
        BCanvasPane bCanvasPane = this.getCurrentCanvas();
        BPane bPane = this.getCurrentFreeForm();
        BSubMenuItem bSubMenuItem = new BSubMenuItem(UiLexicon.bajaui.getText("menu.new.label"));
        CutCommand cutCommand = new CutCommand((BTransferWidget)this);
        CopyCommand copyCommand = new CopyCommand((BTransferWidget)this);
        PasteCommand pasteCommand = new PasteCommand((BTransferWidget)this);
        DuplicateCommand duplicateCommand = new DuplicateCommand((BTransferWidget)this);
        DeleteCommand deleteCommand = new DeleteCommand((BTransferWidget)this);
        EditPropertiesContext editPropertiesContext = new EditPropertiesContext(this.editor);
        PreferredSize preferredSize = new PreferredSize(this.editorPane, bPane);
        if (this.selected.size() == 0) {
            cutCommand.setEnabled(false);
            copyCommand.setEnabled(false);
            pasteCommand.setEnabled(false);
            bSubMenuItem.setEnabled(false);
            duplicateCommand.setEnabled(false);
            deleteCommand.setEnabled(false);
            editPropertiesContext.setEnabled(false);
            preferredSize.setEnabled(false);
        } else {
            if (this.selected.size() != 1 || !Reflector.isDroppable(this.selected.get(0))) {
                pasteCommand.setEnabled(false);
                bSubMenuItem.setEnabled(false);
            }
            if (!Reflector.isFreeFormPane(this.selected.get(0).getParentWidget())) {
                duplicateCommand.setEnabled(false);
            }
        }
        boolean bl = this.preventEdits();
        if (cutCommand.isEnabled()) {
            cutCommand.setEnabled(!bl);
        }
        if (pasteCommand.isEnabled()) {
            pasteCommand.setEnabled(!bl);
        }
        if (bSubMenuItem.isEnabled()) {
            bSubMenuItem.setEnabled(!bl);
        }
        if (duplicateCommand.isEnabled()) {
            duplicateCommand.setEnabled(!bl);
        }
        if (deleteCommand.isEnabled()) {
            deleteCommand.setEnabled(!bl);
        }
        if (editPropertiesContext.isEnabled()) {
            editPropertiesContext.setEnabled(!bl);
        }
        if (preferredSize.isEnabled()) {
            preferredSize.setEnabled(!bl);
        }
        if (bSubMenuItem.isEnabled()) {
            bMenu2 = MenuBuilder.newMenu(this.editorPane, this);
            if (bMenu2 == null) {
                bSubMenuItem.setEnabled(false);
            } else {
                bSubMenuItem.setMenu(bMenu2);
            }
        }
        bMenu2 = new BSubMenuItem(BPxEditorPane.text("commands.align"), MenuBuilder.alignMenu(this.editorPane, this.alignable(bCanvasPane)));
        BSubMenuItem bSubMenuItem2 = new BSubMenuItem(BPxEditorPane.text("commands.distribute"), MenuBuilder.distributeMenu(this.editorPane, this.distributable(bCanvasPane)));
        BSubMenuItem bSubMenuItem3 = new BSubMenuItem(BPxEditorPane.text("commands.reorder"), MenuBuilder.reorgMenu(this.editorPane, this.reorgable(bPane)));
        BSubMenuItem bSubMenuItem4 = new BSubMenuItem(BPxEditorPane.text("commands.select"), this.selectMenu(bPane));
        BSubMenuItem bSubMenuItem5 = new BSubMenuItem(BPxEditorPane.text("commands.border"), MenuBuilder.borderMenu(this.editorPane, this.selected));
        bMenu.add(null, (BValue)bSubMenuItem);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)cutCommand);
        bMenu.add(null, (Command)copyCommand);
        bMenu.add(null, (Command)pasteCommand);
        bMenu.add(null, (Command)duplicateCommand);
        bMenu.add(null, (Command)deleteCommand);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)editPropertiesContext);
        bMenu.add(null, (BValue)bMenu2);
        bMenu.add(null, (BValue)bSubMenuItem2);
        bMenu.add(null, (BValue)bSubMenuItem3);
        bMenu.add(null, (BValue)bSubMenuItem4);
        bMenu.add(null, (BValue)bSubMenuItem5);
        bMenu.add(null, (Command)preferredSize);
        if (this.editorPane.getOptions().getPreserveIdentities()) {
            Rename rename = new Rename(this.editorPane);
            if (this.selected.size() != 1 || !Reflector.isFreeFormPane(this.selected.get(0).getParentWidget())) {
                rename.setEnabled(false);
            }
            if (rename.isEnabled()) {
                rename.setEnabled(!this.preventEdits());
            }
            bMenu.add(null, (Command)rename);
        }
    }

    private CommandArtifact makeInsertArtifact(Insert insert, Command command) throws Exception {
        if (insert == null) {
            return null;
        }
        if (!insert.checkMedia()) {
            return null;
        }
        if (command == null) {
            return insert.doInvoke();
        }
        return new CompoundCommand((BWidget)this.editor, "compound", new Command[]{insert, command}).doInvoke();
    }

    private Insert makeInsertCommand(BWidget bWidget, BWidget[] bWidgetArray) {
        if (Reflector.isFreeFormPane(bWidget)) {
            if (bWidget instanceof BCanvasPane) {
                BCanvasPane bCanvasPane = (BCanvasPane)bWidget;
                if (this.duplicating) {
                    MoveWidget.toZero(bWidgetArray, this.artisan);
                    for (int i = 0; i < bWidgetArray.length; ++i) {
                        this.artisan.move(bWidgetArray[i], this.duplBounds[i].x + 10.0, this.duplBounds[i].y + 10.0);
                    }
                } else {
                    RectGeom rectGeom = this.artisan.bounds(bWidgetArray[0]);
                    for (int i = 1; i < bWidgetArray.length; ++i) {
                        rectGeom = RectGeom.bounds((IRectGeom)this.artisan.bounds(bWidgetArray[i]), (IRectGeom)rectGeom, (RectGeom)rectGeom);
                    }
                    Point point = this.toViewbox(this.popupX, this.popupY, bCanvasPane);
                    Point point2 = this.snap(point.x, point.y);
                    MoveWidget.shiftWidgets(bWidgetArray, this.artisan, point2.x - rectGeom.x, point2.y - rectGeom.y);
                }
            } else if (bWidget instanceof BTabbedPane) {
                MoveWidget.toZero(bWidgetArray, this.artisan);
                bWidgetArray = this.makeTabs(bWidgetArray);
            }
            return new InsertDynamic(this.editor, this.editorPane, bWidget, bWidgetArray);
        }
        if (bWidget instanceof BBorderPane) {
            MoveWidget.toZero(bWidgetArray, this.artisan);
            return new InsertFrozen(this.editor, this.editorPane, bWidget, bWidgetArray[0], "content");
        }
        if (bWidget instanceof BEdgePane) {
            MoveWidget.toZero(bWidgetArray, this.artisan);
            return new InsertFrozen(this.editor, this.editorPane, bWidget, bWidgetArray[0], "center");
        }
        throw new IllegalStateException();
    }

    private Insert makeDropCommand(TransferContext transferContext, BWidget bWidget, BWidget[] bWidgetArray, int n) {
        if (Reflector.isFreeFormPane(bWidget)) {
            if (bWidget instanceof BCanvasPane) {
                BCanvasPane bCanvasPane = (BCanvasPane)bWidget;
                Point point = this.toViewbox(transferContext.getX(), transferContext.getY(), bCanvasPane);
                Point point2 = this.snap(point.x, point.y);
                this.dropWidgetsInCanvas(point2.x, point2.y, bWidgetArray, n);
            } else if (bWidget instanceof BTabbedPane) {
                bWidgetArray = this.makeTabs(bWidgetArray);
            }
            return new InsertDynamic(this.editor, this.editorPane, bWidget, bWidgetArray);
        }
        if (bWidget instanceof BBorderPane) {
            return new InsertFrozen(this.editor, this.editorPane, bWidget, bWidgetArray[0], "content");
        }
        if (bWidget instanceof BEdgePane) {
            return new InsertFrozen(this.editor, this.editorPane, bWidget, bWidgetArray[0], "center");
        }
        throw new IllegalStateException();
    }

    private BMenu selectMenu(BPane bPane) {
        BMenu bMenu = new BMenu();
        BWidget[] bWidgetArray = this.rootDescendants(new Point(this.popupX, this.popupY));
        int n = this.isSelected(this.selected, bWidgetArray);
        bMenu.add(null, (Command)new Select(this.editorPane, bWidgetArray, n, true, false));
        bMenu.add(null, (Command)new Select(this.editorPane, bWidgetArray, n, true, true));
        bMenu.add(null, (Command)new Select(this.editorPane, bWidgetArray, n, false, true));
        bMenu.add(null, (Command)new Select(this.editorPane, bWidgetArray, n, false, false));
        bMenu.setEnabled(this.selectable(bPane, bWidgetArray, n));
        return bMenu;
    }

    private int isSelected(SelectedWidgets selectedWidgets, BWidget[] bWidgetArray) {
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!selectedWidgets.isSelected(bWidgetArray[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean selectable(BPane bPane, BWidget[] bWidgetArray, int n) {
        return !this.preventEdits() && bPane != null && bPane instanceof BCanvasPane && bWidgetArray != null && bWidgetArray.length > 1 && n != -1;
    }

    public void dropWidgetsInCanvas(double d, double d2, BWidget[] bWidgetArray, int n) {
        if (n == 1) {
            int n2 = 0;
            for (int i = 0; i < bWidgetArray.length; ++i) {
                this.artisan.move(bWidgetArray[i], d, d2 + (double)n2);
                n2 = (int)((double)n2 + bWidgetArray[i].getLayout().getHeight());
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < bWidgetArray.length; ++i) {
                this.artisan.move(bWidgetArray[i], d + (double)n3, d2 + (double)n4);
                n5 = (int)Math.max(bWidgetArray[i].getLayout().getHeight(), (double)n5);
                if (i % n == n - 1) {
                    n3 = 0;
                    n4 += n5;
                    n5 = 0;
                    continue;
                }
                n3 = (int)((double)n3 + bWidgetArray[i].getLayout().getWidth());
            }
        }
    }

    public BLabelPane[] makeTabs(BWidget[] bWidgetArray) {
        BLabelPane[] bLabelPaneArray = new BLabelPane[bWidgetArray.length];
        for (int i = 0; i < bWidgetArray.length; ++i) {
            Object object;
            BWidget bWidget = bWidgetArray[i];
            if (bWidget instanceof BLabelPane) {
                object = (BLabelPane)bWidget;
                bWidget = this.editor.cloneWidget(object.getContent());
            }
            object = Reflector.displayName((BComplex)bWidget, false);
            bLabelPaneArray[i] = new BLabelPane((String)object, bWidget);
        }
        return bLabelPaneArray;
    }

    public boolean alignable(BCanvasPane bCanvasPane) {
        return !this.preventEdits() && bCanvasPane != null && this.selected.size() > 1;
    }

    public boolean distributable(BCanvasPane bCanvasPane) {
        return !this.preventEdits() && bCanvasPane != null && this.selected.size() > 2;
    }

    public boolean reorgable(BPane bPane) {
        return !this.preventEdits() && bPane != null && this.selected.size() > 0;
    }

    public BPane getCurrentFreeForm() {
        int n = this.selected.size();
        if (n == 0) {
            return null;
        }
        BWidget bWidget = this.selected.get(0).getParentWidget();
        return Reflector.isFreeFormPane(bWidget) ? (BPane)bWidget : null;
    }

    public Point translateToRoot(BWidget bWidget, Point point) {
        return bWidget.translateToAncestor((BWidget)this.editorPane.getRootContainer(), point);
    }

    public Point translateFromRoot(BWidget bWidget, Point point) {
        return bWidget.translateFromAncestor((BWidget)this.editorPane.getRootContainer(), point);
    }

    public BWidget rootDescendant(Point point) {
        return this.descendantAt((BWidget)this.editorPane.getRootContainer(), point);
    }

    public BWidget[] rootDescendants(Point point) {
        Point point2 = new Point((IPoint)point);
        BWidget bWidget = this.descendantAt((BWidget)this.editorPane.getRootContainer(), point);
        if (bWidget == null) {
            return null;
        }
        BWidget bWidget2 = bWidget.getParentWidget();
        if (!(bWidget2 instanceof BCanvasPane)) {
            return new BWidget[]{bWidget};
        }
        BCanvasPane bCanvasPane = (BCanvasPane)bWidget2;
        BWidget[] bWidgetArray = bCanvasPane.childrenAt(this.translateFromRoot((BWidget)bCanvasPane, point2));
        return this.editorPane.getLayerManager().trimToNormal(bWidgetArray);
    }

    private BWidget descendantAt(BWidget bWidget, Point point) {
        if (!this.editorPane.getLayerManager().isNormal(bWidget)) {
            return null;
        }
        if (Reflector.isLeaf(bWidget)) {
            return bWidget;
        }
        BWidget bWidget2 = bWidget.childAt(point);
        if (bWidget2 != null) {
            BWidget bWidget3 = this.descendantAt(bWidget2, bWidget.translateToChild(bWidget2, point));
            if (bWidget3 == null) {
                if (this.editorPane.getLayerManager().isNormal(bWidget2)) {
                    return bWidget2;
                }
                return bWidget;
            }
            return bWidget3;
        }
        return null;
    }

    public Point toViewbox(double d, double d2, BCanvasPane bCanvasPane) {
        Point point = this.translateFromRoot((BWidget)bCanvasPane, new Point(d, d2));
        return bCanvasPane.getScaleTransform().getInverse().transform((IPoint)point, null);
    }

    public Point fromViewbox(double d, double d2, BCanvasPane bCanvasPane) {
        Point point = new Point(d, d2);
        Point point2 = bCanvasPane.getScaleTransform().transform((IPoint)point, null);
        return this.translateToRoot((BWidget)bCanvasPane, point2);
    }

    public void selectWidgets(RectGeom rectGeom, BCanvasPane bCanvasPane) {
        BWidget[] bWidgetArray = bCanvasPane.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!GeomUtil.contains((IRectGeom)rectGeom, (IRectGeom)this.artisan.bounds(bWidgetArray[i])) || !this.editorPane.getLayerManager().isNormal(bWidgetArray[i])) continue;
            this.selected.select(bWidgetArray[i]);
        }
    }

    public BCanvasPane getCurrentCanvas() {
        int n = this.selected.size();
        if (n == 0) {
            return null;
        }
        BWidget bWidget = this.selected.get(0).getParentWidget();
        return bWidget instanceof BCanvasPane ? (BCanvasPane)bWidget : null;
    }

    public Point snap(double d, double d2) {
        if (!this.editorPane.getOptions().getUseSnap() || this.isShiftDown()) {
            return new Point(d, d2);
        }
        int n = this.editorPane.getOptions().getSnapSize();
        if (n < 1) {
            n = 1;
        }
        int n2 = (int)d;
        int n3 = (int)d2;
        n2 = (n2 + n / 2) / n * n;
        n3 = (n3 + n / 2) / n * n;
        return new Point((double)n2, (double)n3);
    }

    public void showPopupMenu(BMouseEvent bMouseEvent) {
        this.popupX = bMouseEvent.getX();
        this.popupY = bMouseEvent.getY();
        BMenu bMenu = this.editor.getController().getPopupMenu(this, bMouseEvent);
        if (bMenu != null) {
            bMenu.open((BWidget)this, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    public void buffer() {
        try {
            if (this.bufferImage != null) {
                this.bufferImage.dispose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.bufferImage = BImage.make((double)this.getWidth(), (double)this.getHeight());
        Graphics graphics = this.bufferImage.getGraphics();
        graphics.clip(0.0, 0.0, this.getWidth(), this.getHeight());
        this.paintPage(graphics);
        this.paintSelected(graphics);
    }

    public void unbuffer() {
        try {
            if (this.bufferImage != null) {
                this.bufferImage.dispose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.bufferImage = null;
    }

    public void paintBuffer(Graphics graphics) {
        graphics.drawImage(this.bufferImage, 0.0, 0.0);
    }

    public void paintPage(Graphics graphics) {
        this.editorPane.getRootContainer().paint(graphics);
    }

    public void paintSelected(Graphics graphics) {
        for (int i = 0; i < this.selected.size(); ++i) {
            Artisan.instance().paintSelected(this, this.selected.get(i), graphics);
        }
    }

    public void paintDrag(Graphics graphics) {
        Point point = this.dragPoint;
        if (point == null) {
            return;
        }
        graphics.setBrush(DRAG_BRUSH);
        graphics.strokeLine(point.x, point.y, point.x + 50.0, point.y);
        graphics.strokeLine(point.x, point.y, point.x, point.y + 50.0);
    }

    private void checkDrag() {
        RectGeom rectGeom = this.dragRect;
        if (this.dragPoint == null) {
            rectGeom = this.dragRect;
            this.dragRect = null;
        } else {
            RectGeom rectGeom2 = new RectGeom(this.dragPoint.x, this.dragPoint.y, 52.0, 52.0);
            RectGeom rectGeom3 = this.dragRect == null ? rectGeom2 : this.dragRect;
            rectGeom = RectGeom.bounds((IRectGeom)rectGeom2, (IRectGeom)rectGeom3, (RectGeom)new RectGeom());
            this.dragRect = rectGeom2;
        }
        if (rectGeom != null) {
            this.repaint(rectGeom.x, rectGeom.y, rectGeom.width, rectGeom.height);
        }
    }

    private BWidget findDroppable(BWidget bWidget) {
        while (bWidget != null) {
            if (Reflector.isDroppable(bWidget)) {
                return bWidget;
            }
            bWidget = bWidget.getParentWidget();
        }
        return null;
    }

    private boolean preventEdits() {
        return this.editor.isReadonly() || !this.editorPane.getLayerManager().allNormal(this.selected.getWidgets());
    }

    public Painter getPainter() {
        return this.painter;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public void setTracker(Tracker tracker) {
        this.tracker = tracker;
    }

    public boolean isShiftDown() {
        return this.isShiftDown;
    }

    public void setShiftDown(boolean bl) {
        this.isShiftDown = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

