/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.tree;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.tree.BPxTree;
import com.tridium.px.editor.sidebars.tree.WidgetNode;
import com.tridium.px.editor.studio.TreeStudio;
import com.tridium.px.editor.studio.commands.Reorg;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;

public class PxTreeController
extends TreeController {
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private BPxTree tree;
    private SelectedWidgets selected;
    private TreeStudio studio;
    private BWidget[] oldSel;

    public PxTreeController(BPxEditor bPxEditor, BPxEditorPane bPxEditorPane, BPxTree bPxTree, SelectedWidgets selectedWidgets) {
        this.editor = bPxEditor;
        this.editorPane = bPxEditorPane;
        this.tree = bPxTree;
        this.selected = selectedWidgets;
        this.studio = bPxEditorPane.getTreeStudio();
    }

    public TreeNode getFocus() {
        return super.getFocus();
    }

    public void setFocus(TreeNode treeNode) {
        super.setFocus(treeNode);
    }

    protected void popup(BMouseEvent bMouseEvent, TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        WidgetNode widgetNode = (WidgetNode)treeNode;
        this.tree.setPopupNode(widgetNode);
        BMenu bMenu = this.editor.getController().getPopupMenu(this.tree, bMouseEvent);
        if (bMenu != null) {
            bMenu.open((BWidget)this.tree, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    protected void doSelectAction(TreeNode treeNode, double d, double d2) {
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getClickCount() == 2 && bMouseEvent.isButton1Down() && this.selected.size() > 0) {
            Command command = this.editor.getController().getDoubleClickCommand(this.tree, bMouseEvent);
            if (command != null) {
                command.invoke();
            }
        } else {
            this.oldSel = this.selected.getWidgets();
            super.mousePressed(bMouseEvent);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        super.mouseReleased(bMouseEvent);
        BWidget[] bWidgetArray = this.selected.getWidgets();
        if (!this.selEquals(this.oldSel, bWidgetArray)) {
            this.editorPane.getPxEditor().firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        }
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.isControlDown()) {
            BPane bPane = this.studio.getCurrentFreeForm();
            switch (bKeyEvent.getKeyCode()) {
                case 38: {
                    if (this.studio.reorgable(bPane)) {
                        new Reorg(this.editorPane, true, true).invoke();
                    }
                    bKeyEvent.consume();
                    break;
                }
                case 40: {
                    if (this.studio.reorgable(bPane)) {
                        new Reorg(this.editorPane, false, true).invoke();
                    }
                    bKeyEvent.consume();
                    break;
                }
                default: {
                    super.keyPressed(bKeyEvent);
                    break;
                }
            }
        } else {
            super.keyPressed(bKeyEvent);
        }
    }

    private boolean selEquals(BWidget[] bWidgetArray, BWidget[] bWidgetArray2) {
        if (bWidgetArray.length != bWidgetArray2.length) {
            return false;
        }
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i] == bWidgetArray2[i]) continue;
            return false;
        }
        return true;
    }
}

