/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.propsheet;

import com.tridium.px.editor.sidebars.propsheet.BPxPropSheet;
import com.tridium.util.ObjectUtil;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.Lexicon;

class RenamePxProperty
extends Command
implements ObjectUtil.NameContainer {
    private static final Lexicon lex = Lexicon.make((String)"pxEditor");
    private static final String title = lex.getText("commands.rename.label");
    private static final String defaultPxPropertyName = lex.getText("pxPropSheet.defaultPxPropertyName");
    private static final String alreadyExists = lex.getText("pxPropSheet.alreadyExists");
    private BPxPropSheet sheet;

    RenamePxProperty(BPxPropSheet bPxPropSheet) {
        super((BWidget)bPxPropSheet, Lexicon.make((String)"pxEditor"), "commands.rename");
        this.sheet = bPxPropSheet;
        this.setEnabled(!bPxPropSheet.readonly);
    }

    public boolean contains(String string) {
        PxProperty[] pxPropertyArray = this.sheet.editor.getPxProperties();
        for (int i = 0; i < pxPropertyArray.length; ++i) {
            if (!pxPropertyArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public CommandArtifact doInvoke() throws Exception {
        PxProperty[] pxPropertyArray = this.sheet.editor.getPxProperties();
        final int n = this.sheet.table.getSelection().getRow();
        final PxProperty pxProperty = pxPropertyArray[n];
        final String string = pxProperty.getName();
        BTextField bTextField = new BTextField(ObjectUtil.generateUniqueName((String)defaultPxPropertyName, (ObjectUtil.NameContainer)this), 20);
        int n2 = BDialog.open((BWidget)this.sheet, (String)title, (Object)bTextField, (int)3);
        if (n2 != 1) {
            return null;
        }
        final String string2 = bTextField.getText();
        if (string.equals(string2)) {
            return null;
        }
        for (int i = 0; i < pxPropertyArray.length; ++i) {
            PxProperty pxProperty2 = pxPropertyArray[i];
            if (pxProperty2 == pxProperty || !pxProperty2.getName().equals(string2)) continue;
            BDialog.error((BWidget)this.sheet, (String)title, (Object)alreadyExists);
            return null;
        }
        CommandArtifact commandArtifact = new CommandArtifact(){

            public void redo() throws Exception {
                pxProperty.setName(string2);
                ((RenamePxProperty)RenamePxProperty.this).sheet.table.setRowName(n, string2);
                RenamePxProperty.this.sheet.updateUI(pxProperty, new PxPropertyEvent(3, pxProperty));
            }

            public void undo() throws Exception {
                pxProperty.setName(string);
                ((RenamePxProperty)RenamePxProperty.this).sheet.table.setRowName(n, string);
                RenamePxProperty.this.sheet.updateUI(pxProperty, new PxPropertyEvent(3, pxProperty));
            }
        };
        commandArtifact.redo();
        return commandArtifact;
    }
}

