/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.propsheet;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.property.PxPropertyComponentArray;
import com.tridium.px.editor.property.PxPropertyUtil;
import com.tridium.px.editor.sidebars.propsheet.AddPxProperty;
import com.tridium.px.editor.sidebars.propsheet.ChangePxPropertyValue;
import com.tridium.px.editor.sidebars.propsheet.RemovePxProperty;
import com.tridium.px.editor.sidebars.propsheet.RenamePxProperty;
import com.tridium.workbench.celltable.BAbstractCellTable;
import com.tridium.workbench.celltable.BLabeledCellTable;
import com.tridium.workbench.celltable.CellController;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BDrawingTool;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxSideBar;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BPxPropSheet
extends BPxSideBar
implements PxListener {
    public static final Action tableSelectionModified = BPxPropSheet.newAction((int)0, null);
    public static final Action cellModified = BPxPropSheet.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet == null ? (class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet = BPxPropSheet.class$("com.tridium.px.editor.sidebars.propsheet.BPxPropSheet")) : class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet));
    private static Lexicon LEX = Lexicon.make((String)"pxEditor");
    private static String DESC = LEX.getText("pxPropSheet.label");
    private static BImage ICON = BImage.make((String)LEX.getText("pxPropSheet.icon"));
    private static String VALUE = Lexicon.make((String)"bajaui").getText("value");
    BPxEditorPane editorPane;
    BPxEditor editor;
    BLabeledCellTable table;
    boolean readonly = false;
    private PxPropertyComponentArray gcomps;
    private BAbstractButton btnAdd;
    private BAbstractButton btnRemove;
    private Array rows = new Array(class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet$Row == null ? (class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet$Row = BPxPropSheet.class$("com.tridium.px.editor.sidebars.propsheet.BPxPropSheet$Row")) : class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet$Row);
    private Map ceToRow = new HashMap();
    static /* synthetic */ Class class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet;
    static /* synthetic */ Class class$com$tridium$px$editor$sidebars$propsheet$BPxPropSheet$Row;

    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    public void cellModified(BWidgetEvent bWidgetEvent) {
        this.invoke(cellModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPxPropSheet(BPxEditor bPxEditor) {
        super(bPxEditor);
        this.editor = bPxEditor;
        this.editorPane = (BPxEditorPane)bPxEditor.getContent();
        bPxEditor.addPxListener(this);
        this.table = new BLabeledCellTable(new String[]{VALUE});
        this.table.setController((TableController)new BAbstractCellTable.Controller(){

            protected BMenu makePopup(TableSubject tableSubject) {
                return tableSubject.getActiveRow() == -1 ? null : BPxPropSheet.this.makeMenu();
            }
        });
        this.table.setCellController(new CellController(){

            public void showCellPopup(BWbCellEditor bWbCellEditor, BMouseEvent bMouseEvent) {
                Point point = bWbCellEditor.translateToAncestor((BWidget)BPxPropSheet.this, new Point(bMouseEvent.getX(), bMouseEvent.getY()));
                BPxPropSheet.this.makeMenu().open((BWidget)BPxPropSheet.this, point.x, point.y);
            }
        });
        BToolBar bToolBar = new BToolBar();
        this.btnAdd = this.newButton(new AddPxProperty(this));
        bToolBar.add(null, (BValue)this.btnAdd);
        this.btnRemove = this.newButton(new RemovePxProperty(this));
        bToolBar.add(null, (BValue)this.btnRemove);
        this.btnRemove.setEnabled(false);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setRight((BWidget)bToolBar);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)bEdgePane);
        bEdgePane2.setCenter((BWidget)this.table);
        this.setContent((BWidget)bEdgePane2);
        this.linkTo("linkTable", (BComponent)this.table, (Slot)BLabeledCellTable.selectionModified, (Slot)tableSelectionModified);
    }

    public void pxEvent(PxEvent pxEvent) {
        block0 : switch (pxEvent.getEventType()) {
            case 0: {
                PxEditorEvent pxEditorEvent = (PxEditorEvent)pxEvent;
                switch (pxEditorEvent.getEventId()) {
                    case 0: {
                        this.setReadonly(this.editor.isReadonly());
                        this.loadProps();
                        break block0;
                    }
                    case 3: {
                        BDrawingTool bDrawingTool = (BDrawingTool)((Object)pxEditorEvent.getEventValue());
                        this.setReadonly(!bDrawingTool.isNormal());
                        this.loadProps();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void loadProps() {
        this.gcomps = this.editorPane.getPxPropertyComponents();
        PxProperty[] pxPropertyArray = this.editor.getPxProperties();
        this.table.clearRows();
        for (int i = 0; i < pxPropertyArray.length; ++i) {
            PxProperty pxProperty = pxPropertyArray[i];
            this.table.addRow(pxProperty.getName(), new Row(pxProperty).toArray());
        }
    }

    public void doTableSelectionModified() {
        this.editorPane.getSelectedWidgets().deselectAll();
        PxProperty[] pxPropertyArray = this.editor.getPxProperties();
        int n = this.table.getSelection().getRow();
        this.btnRemove.setEnabled(n != -1 && !this.readonly);
        if (n != -1) {
            this.editorPane.getSelectedWidgets().setWidgets(this.gcomps.getWidgets(pxPropertyArray[n]));
        }
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
    }

    public void doCellModified(BWidgetEvent bWidgetEvent) {
        try {
            BWbCellEditor bWbCellEditor = (BWbCellEditor)bWidgetEvent.getWidget();
            BValue bValue = (BValue)bWbCellEditor.saveValue();
            Row row = (Row)this.ceToRow.get(bWbCellEditor);
            new ChangePxPropertyValue(this.editorPane, this, bWbCellEditor, row.prop, bValue).invoke();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    void insertProperty(int n, PxProperty pxProperty, CommandArtifact commandArtifact) {
        PxPropertyUtil.insert(this.editor, n, pxProperty, commandArtifact);
        this.gcomps.setValue(pxProperty);
        this.table.insertRow(n, pxProperty.getName(), new Row(pxProperty).toArray());
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(n);
        this.table.relayout();
        this.updateUI(pxProperty, new PxPropertyEvent(0, pxProperty));
    }

    CommandArtifact removeProperty(int n) {
        PxProperty[] pxPropertyArray = this.editor.getPxProperties();
        PxProperty pxProperty = pxPropertyArray[n];
        this.gcomps.setDefaultValue(pxProperty);
        CommandArtifact commandArtifact = PxPropertyUtil.remove(this.editor, pxProperty, this.gcomps);
        Row row = (Row)this.rows.get(n);
        this.remove((BComplex)row.link);
        this.ceToRow.remove(row.ce);
        this.rows.remove(n);
        this.table.removeRow(n);
        this.table.getSelection().deselectAll();
        this.table.relayout();
        this.updateUI(pxProperty, new PxPropertyEvent(1, pxProperty));
        return commandArtifact;
    }

    void updateUI(PxProperty pxProperty, PxEvent pxEvent) {
        block0 : switch (pxEvent.getEventType()) {
            case 1: {
                switch (((PxPropertyEvent)pxEvent).getEventId()) {
                    case 1: {
                        this.editorPane.getSelectedWidgets().setWidgets(this.gcomps.getWidgets(pxProperty));
                        break block0;
                    }
                }
                break;
            }
        }
        this.editor.firePxEvent(pxEvent);
    }

    private BMenu makeMenu() {
        BMenu bMenu = new BMenu();
        bMenu.add(null, (Command)new RenamePxProperty(this));
        bMenu.add(null, (Command)new RemovePxProperty(this));
        return bMenu;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.table.setCellsEnabled(!bl);
        this.btnAdd.setEnabled(!bl);
        int n = this.table.getSelection().getRow();
        this.btnRemove.setEnabled(n != -1 && !bl);
    }

    public BImage getSideBarIcon() {
        return ICON;
    }

    public String getSideBarDescription() {
        return DESC;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Row {
        PxProperty prop;
        BWbCellEditor ce;
        BLink link;

        Row(PxProperty pxProperty) {
            this.prop = pxProperty;
            this.ce = BWbCellEditor.makeFor((BObject)pxProperty.getValue());
            this.ce.loadValue((BObject)pxProperty.getValue());
            this.link = BPxPropSheet.this.linkTo((BComponent)this.ce, (Slot)BWbCellEditor.pluginModified, (Slot)cellModified);
            BPxPropSheet.this.rows.add((Object)this);
            BPxPropSheet.this.ceToRow.put(this.ce, this);
        }

        BWbCellEditor[] toArray() {
            return new BWbCellEditor[]{this.ce};
        }
    }
}

