/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.layersheet;

import com.tridium.px.editor.sidebars.layersheet.BPxLayerSheet;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.PxLayer;
import javax.baja.util.Lexicon;

class RemovePxLayer
extends Command {
    private BPxLayerSheet sheet;

    RemovePxLayer(BPxLayerSheet bPxLayerSheet) {
        super((BWidget)bPxLayerSheet, Lexicon.make((String)"pxEditor"), "commands.remove");
        this.sheet = bPxLayerSheet;
        this.setEnabled(!bPxLayerSheet.readonly);
    }

    public CommandArtifact doInvoke() throws Exception {
        PxLayer[] pxLayerArray = this.sheet.editor.getPxLayers();
        final int n = this.sheet.table.getSelection().getRow();
        final PxLayer pxLayer = pxLayerArray[n];
        CommandArtifact commandArtifact = new CommandArtifact(){
            CommandArtifact removeTags;

            public void redo() throws Exception {
                this.removeTags = RemovePxLayer.this.sheet.removeLayer(n);
            }

            public void undo() throws Exception {
                RemovePxLayer.this.sheet.insertLayer(n, pxLayer, this.removeTags);
            }
        };
        commandArtifact.redo();
        return commandArtifact;
    }
}

