/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.layersheet;

import com.tridium.px.editor.sidebars.layersheet.BPxLayerSheet;
import com.tridium.util.ObjectUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.px.PxLayer;
import javax.baja.util.Lexicon;

class AddPxLayer
extends Command
implements ObjectUtil.NameContainer {
    private static final Lexicon lex = Lexicon.make((String)"pxEditor");
    private static String lastName = "newLayer";
    private static final String alreadyExists = lex.getText("pxLayerSheet.alreadyExists");
    private BPxLayerSheet sheet;

    AddPxLayer(BPxLayerSheet bPxLayerSheet) {
        super((BWidget)bPxLayerSheet, Lexicon.make((String)"pxEditor"), "commands.add");
        this.sheet = bPxLayerSheet;
        this.setEnabled(!bPxLayerSheet.readonly);
    }

    public boolean contains(String string) {
        PxLayer[] pxLayerArray = this.sheet.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            if (!pxLayerArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public CommandArtifact doInvoke() throws Exception {
        Object object;
        String string = ObjectUtil.generateUniqueName((String)lastName, (ObjectUtil.NameContainer)this);
        BTextField bTextField = new BTextField(string, 25);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setHalign(BHalign.left);
        bGridPane.add(null, (BValue)bTextField);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, "Name");
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.add(null, (BValue)bBorderPane);
        String string2 = this.getLabel();
        int n = 3;
        if (BDialog.open((BWidget)this.sheet, (String)string2, (Object)bGridPane2, (int)n, null) == 2) {
            return null;
        }
        lastName = bTextField.getText();
        string = SlotPath.escape((String)bTextField.getText());
        final PxLayer[] pxLayerArray = this.sheet.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            object = pxLayerArray[i];
            if (!object.getName().equals(string)) continue;
            BDialog.error((BWidget)this.sheet, (String)string2, (Object)alreadyExists);
            return null;
        }
        final PxLayer pxLayer = new PxLayer(string);
        object = new CommandArtifact(){

            public void redo() throws Exception {
                AddPxLayer.this.sheet.insertLayer(pxLayerArray.length, pxLayer, null);
            }

            public void undo() throws Exception {
                AddPxLayer.this.sheet.removeLayer(pxLayerArray.length);
            }
        };
        object.redo();
        return object;
    }
}

