/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.cellsheet.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import javax.baja.px.editor.event.PxBindingEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class ChangeBinding
extends Command {
    private BPxEditorPane editorPane;
    private BPxCellSheet cellSheet;
    private BBinding binding;
    private Property prop;
    private BValue oldValue;
    private BValue newValue;

    public ChangeBinding(BPxEditorPane bPxEditorPane, BPxCellSheet bPxCellSheet, BBinding bBinding, Property property, BValue bValue) {
        super((BWidget)bPxEditorPane, BPxEditorPane.lexicon(), "commands.changeProperty");
        this.editorPane = bPxEditorPane;
        this.cellSheet = bPxCellSheet;
        this.binding = bBinding;
        this.prop = property;
        this.oldValue = bBinding.get(property);
        this.newValue = bValue.newCopy();
    }

    public CommandArtifact doInvoke() throws Exception {
        Artifact artifact = new Artifact();
        if (this.prop.getName().equals("ord")) {
            artifact.initialInvocation = false;
        }
        artifact.redo();
        return artifact;
    }

    private class Artifact
    implements CommandArtifact {
        private boolean initialInvocation = true;

        private Artifact() {
        }

        public void redo() throws Exception {
            this.perform(ChangeBinding.this.newValue);
        }

        public void undo() throws Exception {
            this.perform(ChangeBinding.this.oldValue);
        }

        private void perform(BValue bValue) {
            ChangeBinding.this.binding.set(ChangeBinding.this.prop, bValue);
            PxBindingEvent pxBindingEvent = new PxBindingEvent(2, ChangeBinding.this.binding, ChangeBinding.this.prop.getName(), bValue);
            ChangeBinding.this.editorPane.getSelectedWidgets().setWidgets(new BWidget[]{(BWidget)ChangeBinding.this.binding.getParent()});
            if (this.initialInvocation) {
                ChangeBinding.this.editorPane.getPxEditor().removePxListener(ChangeBinding.this.cellSheet);
                ChangeBinding.this.editorPane.getPxEditor().firePxEvent(pxBindingEvent);
                ChangeBinding.this.editorPane.getPxEditor().addPxListener(ChangeBinding.this.cellSheet);
                this.initialInvocation = false;
            } else {
                ChangeBinding.this.editorPane.getPxEditor().firePxEvent(pxBindingEvent);
            }
        }
    }
}

