/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.cellsheet;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import com.tridium.px.editor.sidebars.cellsheet.CellTableContext;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.CellController;
import com.tridium.workbench.celltable.CellEditorContainer;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BPxCellTable
extends BTable
implements CellEditorContainer {
    public static final Action handleSelectionModified = BPxCellTable.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$sidebars$cellsheet$BPxCellTable == null ? (class$com$tridium$px$editor$sidebars$cellsheet$BPxCellTable = BPxCellTable.class$("com.tridium.px.editor.sidebars.cellsheet.BPxCellTable")) : class$com$tridium$px$editor$sidebars$cellsheet$BPxCellTable));
    protected BPxEditorPane editorPane;
    protected final BPxCellSheet sheet;
    private Model model = new Model();
    private boolean dragging = false;
    private boolean ignoreModified = false;
    private CellController cellController;
    static /* synthetic */ Class class$com$tridium$px$editor$sidebars$cellsheet$BPxCellTable;
    static /* synthetic */ Class class$javax$baja$workbench$celleditor$BWbCellEditor;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPxCellTable(BPxEditorPane bPxEditorPane, BPxCellSheet bPxCellSheet) {
        this.editorPane = bPxEditorPane;
        this.sheet = bPxCellSheet;
        this.setMultipleSelection(false);
        this.setHeaderVisible(false);
        this.setExtendedResize(true);
        this.setHscrollBarVisible(false);
        this.setVscrollBarVisible(false);
        this.setGridBrush(Theme.widget().getControlShadow());
        this.setCellRenderer(new CellRenderer());
        this.setModel(this.model);
        this.setController(new Controller());
        this.setCellController(new PxCellController());
        this.linkTo("lnkHandleMod", (BComponent)this, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
    }

    public void doHandleSelectionModified() {
        if (this.ignoreModified) {
            return;
        }
        BPxCellTable[] bPxCellTableArray = this.sheet.getCellTables();
        for (int i = 0; i < bPxCellTableArray.length; ++i) {
            if (bPxCellTableArray[i] == this) continue;
            bPxCellTableArray[i].ignoreModified = true;
            bPxCellTableArray[i].getSelection().deselectAll();
            bPxCellTableArray[i].ignoreModified = false;
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        for (int i = 0; i < this.model.cellEditors.size(); ++i) {
            BWbCellEditor bWbCellEditor = (BWbCellEditor)this.model.cellEditors.get(i);
            bWbCellEditor.setBounds(this.getCellWidth(0), this.getCellRenderer().getCellHeight() * (double)bWbCellEditor.getRowIndex(), this.getCellWidth(1), this.getCellRenderer().getCellHeight());
        }
    }

    public BWidget childAt(Point point) {
        if (this.dragging) {
            return null;
        }
        return super.childAt(point);
    }

    void addCellEditor(BWbCellEditor bWbCellEditor) {
        this.model.cellEditors.add((Object)bWbCellEditor);
        this.add(null, (BValue)bWbCellEditor);
    }

    public CellController getCellController() {
        return this.cellController;
    }

    public void setCellController(CellController cellController) {
        this.installSupport((BTable.TableSupport)this.cellController, (BTable.TableSupport)cellController);
        this.cellController = cellController;
    }

    private void installSupport(BTable.TableSupport tableSupport, BTable.TableSupport tableSupport2) {
        if (tableSupport2 == null) {
            throw new NullPointerException();
        }
        if (tableSupport == tableSupport2) {
            return;
        }
        if (tableSupport2.getTable() != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (tableSupport != null) {
            tableSupport.setTable(null);
        }
        tableSupport2.setTable((BTable)this);
    }

    protected CellTableContext makeContext(final BWbCellEditor bWbCellEditor) {
        return new CellTableContext(){

            public boolean allowAnimate() {
                return true;
            }

            public BComponent[] getGroupableComponents() {
                Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BPxCellTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
                array.addAll((Object[])BPxCellTable.this.sheet.getAllWidgets());
                return (BComponent[])array.trim();
            }

            public void doPaste() {
                BPxCellTable.this.sheet.getCellContext().cellModified(bWbCellEditor);
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Model
    extends TableModel {
        private Array cellEditors = new Array(class$javax$baja$workbench$celleditor$BWbCellEditor == null ? (class$javax$baja$workbench$celleditor$BWbCellEditor = BPxCellTable.class$("javax.baja.workbench.celleditor.BWbCellEditor")) : class$javax$baja$workbench$celleditor$BWbCellEditor);

        private Model() {
        }

        public int getRowCount() {
            return this.cellEditors.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((BWbCellEditor)this.cellEditors.get(n)).getPropertyName();
                }
                case 1: {
                    return this.cellEditors.get(n);
                }
            }
            throw new IllegalStateException();
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        private CellRenderer() {
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return BPxCellTable.this.sheet.getColumnWidth();
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                super.paintCell(graphics, cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void resizeHotspotPressed(BMouseEvent bMouseEvent, int n) {
            BPxCellTable.this.dragging = true;
        }

        protected void resizeHotspotDragged(BMouseEvent bMouseEvent, int n) {
            BPxCellTable[] bPxCellTableArray = BPxCellTable.this.sheet.getCellTables();
            for (int i = 0; i < bPxCellTableArray.length; ++i) {
                bPxCellTableArray[i].setColumnPosition(n, bMouseEvent.getX());
                bPxCellTableArray[i].relayoutSync();
            }
        }

        protected void resizeHotspotReleased(BMouseEvent bMouseEvent, int n) {
            BPxCellTable.this.dragging = false;
            BPxCellTable.this.sheet.setColumnWidth(BPxCellTable.this.getCellWidth(0));
            BPxCellTable.this.relayoutSync();
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BWbCellEditor bWbCellEditor = (BWbCellEditor)BPxCellTable.this.model.cellEditors.get(n);
            BMenu bMenu = BPxCellTable.this.sheet.makePopup(bWbCellEditor, BPxCellTable.this.makeContext(bWbCellEditor));
            Point point = BPxCellTable.this.translateToAncestor((BWidget)BPxCellTable.this.sheet, new Point(bMouseEvent.getX(), bMouseEvent.getY()));
            bMenu.open((BWidget)BPxCellTable.this.sheet, point.x, point.y);
        }
    }

    private class PxCellController
    extends CellController {
        private PxCellController() {
        }

        public void showCellPopup(BWbCellEditor bWbCellEditor, BMouseEvent bMouseEvent) {
            BMenu bMenu = BPxCellTable.this.sheet.makePopup(bWbCellEditor, BPxCellTable.this.makeContext(bWbCellEditor));
            Point point = bWbCellEditor.translateToAncestor((BWidget)BPxCellTable.this.sheet, new Point(bMouseEvent.getX(), bMouseEvent.getY()));
            bMenu.open((BWidget)BPxCellTable.this.sheet, point.x, point.y);
        }
    }
}

