/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.binding;

import com.tridium.px.editor.util.Reflector;
import com.tridium.ui.theme.Theme;
import java.util.HashSet;
import java.util.Set;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

public abstract class BOrdChanger
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$sidebars$binding$BOrdChanger == null ? (class$com$tridium$px$editor$sidebars$binding$BOrdChanger = BOrdChanger.class$("com.tridium.px.editor.sidebars.binding.BOrdChanger")) : class$com$tridium$px$editor$sidebars$binding$BOrdChanger));
    private static Lexicon lexicon = Lexicon.make((String)"pxEditor");
    private static final BImage OK = BOrdChanger.icon("boundOrds.ok");
    private static final BImage STOP = BOrdChanger.icon("boundOrds.stop");
    BPxEditor editor;
    protected BEdgePane edge = new BEdgePane();
    BOrd[] before;
    BOrd[] after;
    boolean[] selected;
    BTable table = new BTable();
    static /* synthetic */ Class class$com$tridium$px$editor$sidebars$binding$BOrdChanger;

    public Type getType() {
        return TYPE;
    }

    public BOrdChanger(BPxEditor bPxEditor, BOrd[] bOrdArray) {
        this.editor = bPxEditor;
        this.before = bOrdArray;
        this.after = new BOrd[bOrdArray.length];
        this.selected = new boolean[bOrdArray.length];
        this.table.setModel((TableModel)new Model());
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BScrollPane((BWidget)this.table));
        bConstrainedPane.setMaxHeight(400.0);
        this.edge.setCenter((BWidget)bConstrainedPane);
        this.setContent((BWidget)this.edge);
    }

    protected abstract BOrd after(BOrd var1);

    protected abstract boolean selectable(int var1);

    protected final void init() {
        for (int i = 0; i < this.before.length; ++i) {
            this.after[i] = this.after(this.before[i]);
            this.selected[i] = true;
        }
    }

    Set selected() {
        HashSet<BOrd> hashSet = new HashSet<BOrd>();
        for (int i = 0; i < this.before.length; ++i) {
            if (!this.selected[i]) continue;
            hashSet.add(this.before[i]);
        }
        return hashSet;
    }

    private static String text(String string) {
        return lexicon.getText(string);
    }

    private static BImage icon(String string) {
        return BImage.make((String)lexicon.getText(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (BOrdChanger.this.selectable(cell.row) && BOrdChanger.this.selected[cell.row]) {
                return super.getForeground(cell);
            }
            return Theme.widget().getControlShadow();
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                this.paintCellBackground(graphics, cell);
                if (BOrdChanger.this.selectable(cell.row)) {
                    if (BOrdChanger.this.selected[cell.row]) {
                        double d = 2.0;
                        double d2 = (cell.height - 16.0) / 2.0;
                        graphics.drawImage(OK, d, d2);
                    }
                } else {
                    double d = 2.0;
                    double d3 = (cell.height - 16.0) / 2.0;
                    graphics.drawImage(STOP, d, d3);
                }
            } else {
                super.paintCell(graphics, cell);
            }
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return super.getPreferredCellWidth(cell);
            }
            String string = BOrdChanger.this.before[cell.row].toString();
            return Theme.table().getCellFont().width(string) + 12.0;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 != 0) {
                return;
            }
            if (!BOrdChanger.this.selectable(n)) {
                return;
            }
            BOrdChanger.this.selected[n] = !BOrdChanger.this.selected[n];
            BOrdChanger.this.after[n] = BOrdChanger.this.selected[n] ? BOrdChanger.this.after(BOrdChanger.this.before[n]) : BOrdChanger.this.before[n];
            BOrdChanger.this.repaint();
        }

        protected BMenu makeOptionsMenu() {
            return Reflector.optionsMenu(this.getTable());
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BOrdChanger.this.selected.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "  ";
                }
                case 1: {
                    return BOrdChanger.text("boundOrds.relativize.before");
                }
                case 2: {
                    return BOrdChanger.text("boundOrds.relativize.after");
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BOrdChanger.this.before[n];
                }
                case 2: {
                    return BOrdChanger.this.after[n];
                }
            }
            throw new IllegalStateException();
        }
    }
}

