/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.RootStudio;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import java.util.Collection;
import java.util.HashMap;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;

public class RootShellManager
implements ShellManager {
    private BPxEditorPane editorPane;
    private RootStudio studio;
    private HashMap relayoutQueue = new HashMap();
    private Thread layoutThread;

    RootShellManager(BPxEditorPane bPxEditorPane, RootStudio rootStudio) {
        this.editorPane = bPxEditorPane;
        this.studio = rootStudio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutWidgets() {
        BWidget[] bWidgetArray = null;
        HashMap hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.relayoutQueue.size() > 0) {
                Collection collection = this.relayoutQueue.values();
                bWidgetArray = collection.toArray(new BWidget[collection.size()]);
                this.relayoutQueue.clear();
            }
        }
        if (bWidgetArray != null) {
            this.layoutThread = Thread.currentThread();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bWidgetArray[i].layout();
            }
            this.layoutThread = null;
            this.checkMouseOver();
        }
    }

    public void repaint() {
        this.studio.repaint();
    }

    public void repaint(BWidget bWidget, int n, int n2, int n3, int n4) {
        Point point = this.studio.translateToRoot(bWidget, new Point((double)n, (double)n2));
        Point point2 = this.studio.translateToRoot(bWidget, new Point((double)(n + n3), (double)(n2 + n4)));
        if (point.x < 0.0) {
            point.x = 0.0;
        }
        if (point.y < 0.0) {
            point.y = 0.0;
        }
        if (point2.x < 0.0) {
            point2.x = 0.0;
        }
        if (point2.y < 0.0) {
            point2.y = 0.0;
        }
        this.studio.repaint(point.x, point.y, point2.x - point.x, point2.y - point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relayout(BWidget bWidget, boolean bl) {
        HashMap hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(bWidget) == null) {
                this.relayoutQueue.put(bWidget, bWidget);
            }
        }
        if (bl) {
            this.layoutWidgets();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueRelayout(BWidget bWidget) {
        HashMap hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(bWidget) == null) {
                this.relayoutQueue.put(bWidget, bWidget);
                return true;
            }
        }
        return false;
    }

    public void setHoldLayout(boolean bl) {
    }

    public BWidget getShell() {
        return null;
    }

    public ShellPeer getShellPeer() {
        throw new IllegalStateException();
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public Point translateToScreen(BWidget bWidget, Point point) {
        throw new IllegalStateException();
    }

    public boolean hasFocus(BWidget bWidget) {
        return false;
    }

    public void requestFocus(BWidget bWidget) {
    }

    public BWidget getCurrentFocus() {
        throw new IllegalStateException();
    }

    public void resetHover(BWidget bWidget) {
    }

    public void startDragOperation(BTransferWidget bTransferWidget, BMouseEvent bMouseEvent, TransferContext transferContext, DragRenderer dragRenderer) {
    }

    public void checkMouseOver() {
    }

    public void updateMouseCursor() {
    }

    public void enterBusy(BWidget bWidget) {
    }

    public void exitBusy(BWidget bWidget) {
    }

    public boolean isDesignTime() {
        return true;
    }
}

