/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.TypeInfoSpec;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.options.BMruTextDropDown;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.xml.XWriter;

public class BNewPxViewDialog
extends BEdgePane {
    public static final Action viewNameChanged = BNewPxViewDialog.newAction((int)0, null);
    public static final Action fileNameChanged = BNewPxViewDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$BNewPxViewDialog == null ? (class$com$tridium$px$editor$BNewPxViewDialog = BNewPxViewDialog.class$("com.tridium.px.editor.BNewPxViewDialog")) : class$com$tridium$px$editor$BNewPxViewDialog));
    static Lexicon lex = Lexicon.make((String)"pxEditor");
    static final BImage headerIcon = BPxEditorPane.icon("newPxView.iconHeader");
    static final BImage browseIcon = BPxEditorPane.icon("newPxView.iconBrowse");
    static final String lexBrowse = BPxEditorPane.text("newPxView.browse");
    static final String lexCancel = BPxEditorPane.text("newPxView.cancel");
    static final String lexDescription = BPxEditorPane.text("newPxView.description");
    static final String lexExporter = BPxEditorPane.text("newPxView.dynamic");
    static final String lexFileAlreadyExists = BPxEditorPane.text("newPxView.fileAlreadyExists");
    static final String lexMedia = BPxEditorPane.text("newPxView.media");
    static final String lexOverwrite = BPxEditorPane.text("newPxView.overwrite");
    static final String lexPxFile = BPxEditorPane.text("newPxView.pxFile");
    static final String lexSource = BPxEditorPane.text("newPxView.source");
    static final String lexReuse = BPxEditorPane.text("newPxView.reuse");
    static final String lexReuseOrOverwrite = BPxEditorPane.text("newPxView.reuseOrOverwrite");
    static final String lexSaveError = BPxEditorPane.text("newPxView.saveError");
    static final String lexTitle = BPxEditorPane.text("newPxView.title");
    static final String lexViewIcon = BPxEditorPane.text("newPxView.viewIcon");
    static final String lexViewName = BPxEditorPane.text("newPxView.viewName");
    static BFileChooser openChooser;
    static BFileChooser saveChooser;
    BComponent component;
    BWidget owner;
    BDialog existingDialog;
    boolean reuse = false;
    boolean overwrite = false;
    boolean cancelled = false;
    BMruTextDropDown name;
    BWbFieldEditor icon;
    BListDropDown media;
    BDirectory currentDir = null;
    boolean useFile;
    BMruTextDropDown file;
    BButton browse;
    BTextDropDown dynamic;
    TypeInfo[] dynamicTypes;
    static /* synthetic */ Class class$com$tridium$px$editor$BNewPxViewDialog;

    public void viewNameChanged() {
        this.invoke(viewNameChanged, null, null);
    }

    public void fileNameChanged() {
        this.invoke(fileNameChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static CommandArtifact invoke(BWidget bWidget, BComponent bComponent) throws Exception {
        BNewPxViewDialog bNewPxViewDialog = new BNewPxViewDialog(bComponent);
        bNewPxViewDialog.owner = bWidget;
        String string = null;
        do {
            int n;
            if ((n = BDialog.open((BWidget)bWidget, (String)lexTitle, (Object)((Object)bNewPxViewDialog), (int)3)) == 1) continue;
            return null;
        } while ((string = bNewPxViewDialog.save()) == null);
        String string2 = "view:" + string;
        if (!bNewPxViewDialog.reuse && bNewPxViewDialog.useFile) {
            string2 = string2 + "/editor";
        }
        BWbShell bWbShell = (BWbShell)bWidget.getShell();
        bWbShell.hyperlink(BOrd.make((BOrd)bComponent.getNavOrd(), (String)string2));
        return null;
    }

    public BNewPxViewDialog(BComponent bComponent) {
        this.component = bComponent;
        this.name = this.buildName();
        this.icon = this.buildIcon();
        this.media = this.buildMedia();
        ToggleCommand toggleCommand = new ToggleCommand((BWidget)this, lexPxFile){

            public CommandArtifact doInvoke() throws Exception {
                if (this.isSelected()) {
                    BNewPxViewDialog.this.useFile = true;
                    BNewPxViewDialog.this.file.setEnabled(true);
                    BNewPxViewDialog.this.dynamic.setEnabled(false);
                }
                return null;
            }
        };
        ToggleCommand toggleCommand2 = new ToggleCommand((BWidget)this, lexExporter){

            public CommandArtifact doInvoke() throws Exception {
                if (this.isSelected()) {
                    BNewPxViewDialog.this.useFile = false;
                    BNewPxViewDialog.this.file.setEnabled(false);
                    BNewPxViewDialog.this.dynamic.setEnabled(true);
                }
                return null;
            }
        };
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        toggleCommandGroup.add(toggleCommand);
        toggleCommandGroup.add(toggleCommand2);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BRadioButton(toggleCommand));
        bGridPane.add(null, (BValue)this.buildFile());
        bGridPane.add(null, (BValue)new BRadioButton(toggleCommand2));
        bGridPane.add(null, (BValue)this.buildDynamic());
        this.useFile = true;
        this.file.setEnabled(true);
        this.dynamic.setEnabled(false);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setColumnGap(10.0);
        bGridPane2.add(null, (BValue)new BLabel(lexViewName));
        bGridPane2.add(null, (BValue)this.name);
        bGridPane2.add(null, (BValue)new BLabel(lexViewIcon));
        bGridPane2.add(null, (BValue)this.icon);
        bGridPane2.add(null, (BValue)new BLabel(lexMedia));
        bGridPane2.add(null, (BValue)this.media);
        bGridPane2.add(null, (BValue)new BLabel(lexSource));
        bGridPane2.add(null, (BValue)bGridPane);
        this.setTop((BWidget)new BWizardHeader(headerIcon, lexTitle, lexDescription));
        this.setCenter((BWidget)new BBorderPane((BWidget)bGridPane2));
        this.linkTo((BComponent)this.name.getEditor(), (Slot)BTextEditor.textModified, (Slot)viewNameChanged);
        this.linkTo((BComponent)this.file.getEditor(), (Slot)BTextEditor.textModified, (Slot)fileNameChanged);
    }

    public BMruTextDropDown buildName() {
        BMruTextDropDown bMruTextDropDown = new BMruTextDropDown("newPxViewName", 20);
        String string = bMruTextDropDown.getText();
        if (string.length() == 0) {
            string = "Graphic";
        }
        string = CompToComp.getUniqueName((BComponent)this.component, (String)string);
        bMruTextDropDown.setText(string);
        return bMruTextDropDown;
    }

    public BWbFieldEditor buildIcon() {
        BIcon bIcon = new BPxView().getIcon();
        BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bIcon);
        bWbFieldEditor.loadValue((BObject)bIcon);
        return bWbFieldEditor;
    }

    public BListDropDown buildMedia() {
        BListDropDown bListDropDown = new BListDropDown();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BPxMedia.TYPE.getTypeInfo());
        int n = 0;
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfoSpec typeInfoSpec = new TypeInfoSpec(typeInfoArray[i]);
            if (typeInfoSpec.info.getTypeName().equals("WbPxMedia")) {
                n = i;
            }
            bListDropDown.getList().addItem(typeInfoSpec.icon, (Object)typeInfoSpec);
        }
        bListDropDown.setSelectedIndex(n);
        return bListDropDown;
    }

    public BWidget buildFile() {
        this.file = this.buildMru("pxViewFile");
        this.browse = new BButton((Command)new ReflectCommand((BWidget)this, null, browseIcon, "browse"));
        this.browse.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)this.file);
        bGridPane.add(null, (BValue)this.browse);
        return bGridPane;
    }

    public BWidget buildDynamic() {
        this.dynamicTypes = Sys.getRegistry().getConcreteTypes(BDynamicPxView.TYPE.getTypeInfo());
        this.dynamic = new BTextDropDown(new Array((Object[])this.dynamicTypes).list(), 40, false);
        return this.dynamic;
    }

    public BMruTextDropDown buildMru(String string) {
        BMruTextDropDown bMruTextDropDown = new BMruTextDropDown(string, 60);
        BDirectory bDirectory = null;
        String string2 = bMruTextDropDown.getText();
        if (string2.length() > 0) {
            try {
                int n = string2.lastIndexOf(47);
                bDirectory = (BDirectory)BOrd.make((String)string2.substring(0, n)).get((BObject)this.component);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bDirectory == null || !string2.startsWith("file:^")) {
            try {
                bDirectory = (BDirectory)BOrd.make((String)"file:^").get((BObject)this.component);
                bDirectory = bDirectory.getFileSpace().makeDir(bDirectory.getFilePath().merge("px"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bDirectory == null) {
            bDirectory = BFileSystem.INSTANCE.getSysHome();
            try {
                bDirectory = bDirectory.getFileSpace().makeDir(bDirectory.getFilePath().merge("px"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentDir = bDirectory;
        String string3 = this.name.getText() + ".px";
        if (string3.length() > 3 && FilePath.isValidName((String)string3)) {
            bMruTextDropDown.setText(bDirectory.getFilePath().merge(string3).toString());
        }
        return bMruTextDropDown;
    }

    public String save() throws Exception {
        String string = SlotPath.escape((String)this.name.getTextAndSave());
        if (this.component.get(string) != null) {
            String string2 = lex.getText("newPxView.slotAlreadyExists", new Object[]{string});
            BDialog.error((BWidget)this.owner, (Object)string2);
            return null;
        }
        TypeInfoSpec typeInfoSpec = (TypeInfoSpec)this.media.getSelectedItem();
        BPxView bPxView = null;
        if (this.useFile) {
            bPxView = new BPxView();
            BOrd bOrd = this.saveFile(typeInfoSpec);
            bPxView.setPxFile(bOrd);
        } else {
            int n = this.dynamic.getList().getSelectedIndex();
            bPxView = (BDynamicPxView)this.dynamicTypes[n].getInstance();
        }
        bPxView.setIcon((BIcon)this.icon.saveValue());
        bPxView.setMedia(typeInfoSpec.info.getTypeSpec());
        this.component.add(string, (BValue)bPxView, 256);
        this.component.lease();
        return string;
    }

    private BOrd saveFile(TypeInfoSpec typeInfoSpec) throws Exception {
        BOrd bOrd = BOrd.make((String)this.file.getText());
        try {
            BIFile bIFile = (BIFile)bOrd.resolve((BObject)this.component).get();
            this.existingDialog = this.makeExistingDialog();
            this.existingDialog.setBoundsCenteredOnOwner();
            this.existingDialog.open();
            if (this.cancelled) {
                return null;
            }
            if (this.overwrite) {
                this.writeNewFile(bIFile, typeInfoSpec.info);
            }
        }
        catch (UnresolvedException unresolvedException) {
            this.createNew(bOrd, typeInfoSpec.info);
        }
        catch (SyntaxException syntaxException) {
            String string = lex.getText("newPxView.illegalFilename", new Object[]{this.file.getText()});
            BDialog.error((BWidget)this.owner, (Object)string);
            return null;
        }
        this.file.getTextAndSave();
        return bOrd;
    }

    BDialog makeExistingDialog() {
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexReuse, "reuse")));
        bGridPane.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexOverwrite, "overwrite")));
        bGridPane.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, lexCancel, "cancel")));
        BLabel bLabel = new BLabel(lexReuseOrOverwrite);
        bLabel.setHalign(BHalign.left);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add(null, (BValue)new BLabel(lexFileAlreadyExists, Theme.widget().getBoldText()));
        bGridPane2.add(null, (BValue)bLabel);
        BGridPane bGridPane3 = new BGridPane(2);
        bGridPane3.setColumnGap(10.0);
        bGridPane3.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/warning.png")));
        bGridPane3.add(null, (BValue)bGridPane2);
        BGridPane bGridPane4 = new BGridPane(1);
        bGridPane4.add(null, (BValue)new BBorderPane((BWidget)bGridPane3, 0.0, 10.0, 10.0, 10.0));
        bGridPane4.add(null, (BValue)bGridPane);
        this.reuse = false;
        this.overwrite = false;
        this.cancelled = false;
        return new BDialog(this.owner, lexFileAlreadyExists, true, (BWidget)new BBorderPane((BWidget)bGridPane4));
    }

    void createNew(BOrd bOrd, TypeInfo typeInfo) throws Exception {
        OrdQuery[] ordQueryArray = bOrd.parse();
        FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
        ordQueryArray[ordQueryArray.length - 1] = new FilePath(filePath.getScheme(), filePath.getAbsoluteBase());
        BOrd bOrd2 = BOrd.make((OrdQuery[])ordQueryArray);
        BIFile bIFile = (BIFile)bOrd2.get((BObject)this.component);
        BFileSpace bFileSpace = bIFile.getFileSpace();
        BIFile bIFile2 = bFileSpace.makeFile(filePath);
        this.writeNewFile(bIFile2, typeInfo);
    }

    void writeNewFile(BIFile bIFile, TypeInfo typeInfo) throws Exception {
        try {
            BPxMedia bPxMedia = (BPxMedia)typeInfo.getTypeSpec().getResolvedType().getInstance();
            BIFile bIFile2 = (BIFile)bPxMedia.getPxFileOrd().get();
            FileUtil.pipe((BIFile)bIFile2, (BIFile)bIFile);
        }
        catch (UnresolvedException unresolvedException) {
            XWriter xWriter = new XWriter(bIFile.getOutputStream());
            xWriter.prolog();
            xWriter.w((Object)"<px version='1.0' media='").w((Object)typeInfo).w((Object)"'>\n");
            xWriter.w((Object)"<import>\n");
            xWriter.w((Object)" <module name='bajaui'/>\n");
            xWriter.w((Object)"</import>\n");
            xWriter.w((Object)"<content>\n");
            xWriter.w((Object)"  <ScrollPane>\n");
            xWriter.w((Object)"    <CanvasPane name=\"content\" viewSize=\"500,400\"/>\n");
            xWriter.w((Object)"  </ScrollPane>\n");
            xWriter.w((Object)"</content>\n");
            xWriter.w((Object)"</px>");
            xWriter.close();
        }
    }

    public void overwrite() {
        this.existingDialog.close();
        this.overwrite = true;
    }

    public void reuse() {
        this.existingDialog.close();
        this.reuse = true;
    }

    public void cancel() {
        this.existingDialog.close();
        this.cancelled = true;
    }

    public void browse() {
        BOrd bOrd;
        BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.owner);
        bFileChooser.setBoundsCenteredOnScreen();
        bFileChooser.setCreateFileOnSave(false);
        bFileChooser.setConfirmOverwrite(false);
        try {
            bOrd = BOrd.make((String)this.file.getText());
            OrdQuery[] ordQueryArray = bOrd.parse();
            FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
            String string = filePath.getName();
            ordQueryArray[ordQueryArray.length - 1] = filePath.getParent();
            BOrd bOrd2 = BOrd.make((OrdQuery[])ordQueryArray);
            bFileChooser.setDefaultFileName(string);
            bFileChooser.setCurrentDirectory(BOrd.make((BOrd)this.component.getAbsoluteOrd(), (BOrd)bOrd2));
            BObject bObject = BOrd.make((BOrd)this.component.getAbsoluteOrd(), (String)"file:^").get((BObject)this.component);
            BSpace bSpace = BOrd.toSpace((BObject)bObject);
            if (bSpace != null) {
                bFileChooser.setSpaces(new BSpace[]{bSpace});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bOrd = bFileChooser.show();
        if (bOrd != null) {
            bOrd = bOrd.relativizeToSession();
            this.file.setText(bOrd.toString());
        }
    }

    public void doViewNameChanged() {
        String string = this.name.getText() + ".px";
        if (string.length() > 3 && FilePath.isValidName((String)string)) {
            this.file.setText(this.currentDir.getFilePath().merge(string).toString());
        }
    }

    public void doFileNameChanged() {
        try {
            OrdQuery[] ordQueryArray = BOrd.make((String)this.file.getText()).parse();
            FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
            ordQueryArray[ordQueryArray.length - 1] = filePath.getParent();
            this.currentDir = (BDirectory)BOrd.make((OrdQuery[])ordQueryArray).get((BObject)this.component);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

