/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrapidEye;

import com.honeywell.rapidEyeObjects.RESensors;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.ICommFilter;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nrapidEye.BRapidEyeCamera;
import com.tridium.nrapidEye.BRapidEyeCameraDeviceExt;
import com.tridium.nrapidEye.BRapidEyeDvrAlarmSourceInfo;
import com.tridium.nrapidEye.BRapidEyeNetwork;
import com.tridium.nrapidEye.comm.RapidEyeCommFilter;
import com.tridium.nrapidEye.comm.RapidEyeTcpListener;
import com.tridium.nrapidEye.identify.BRapidEyeCameraId;
import com.tridium.nrapidEye.identify.BRapidEyeDvrId;
import com.tridium.nrapidEye.identify.BRapidEyeIpAddress;
import com.tridium.nrapidEye.messages.req.RapidEyeCameraDiscoverRequest;
import com.tridium.nrapidEye.messages.req.RapidEyeDvrPingRequest;
import com.tridium.nrapidEye.messages.req.alarm.RapidEyeAlarmSessionRequest;
import com.tridium.nrapidEye.messages.req.events.RapidEyeEventSessionRequest;
import com.tridium.nrapidEye.messages.req.events.RapidEyeSensorsRequest;
import com.tridium.nrapidEye.messages.req.live.RapidEyeLiveSessionRequest;
import com.tridium.nrapidEye.messages.req.live.RapidEyeOpenLiveRequest;
import com.tridium.nrapidEye.messages.rsp.RapidEyeCameraDiscoverResponse;
import com.tridium.nrapidEye.messages.rsp.RapidEyeDvrPingResponse;
import com.tridium.nrapidEye.messages.rsp.RapidEyeSensorsResponse;
import com.tridium.nrapidEye.messages.rsp.RapidEyeSessionResponse;
import com.tridium.nrapidEye.point.BRapidEyeFrameRateDetails;
import com.tridium.nrapidEye.point.BRapidEyeResolutionDetails;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRapidEyeDvr
extends BVideoDvr
implements ITcpEventListener {
    public static final Property address = BRapidEyeDvr.newProperty((int)0, (BValue)new BRapidEyeIpAddress(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property videoDeviceId = BRapidEyeDvr.newProperty((int)0, (BValue)new BRapidEyeDvrId(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property displays = BRapidEyeDvr.newProperty((int)4, (BValue)new BDisplayDeviceExt(), null);
    public static final Property initStatus = BRapidEyeDvr.newProperty((int)1, (String)"", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property alarmSourceInfo = BRapidEyeDvr.newProperty((int)0, (BValue)BRapidEyeDvr.initAlarmSourceInfo(), null);
    public static final Property rapidEyeUserName = BRapidEyeDvr.newProperty((int)0, (String)"administrator", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property rapidEyePassword = BRapidEyeDvr.newProperty((int)0, (BValue)BPassword.make((String)""), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property durationForEvents = BRapidEyeDvr.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), (BFacets)SfUtil.incl((String)"ed", (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1), (String)"max", (BIDataValue)BRelTime.makeHours((int)240))));
    public static final Property foxVideoStreamPreferred = BRapidEyeDvr.newProperty((int)4, (BValue)BFoxVideoStreamEnum.no, null);
    public static final Property cameras = BRapidEyeDvr.newProperty((int)0, (BValue)new BRapidEyeCameraDeviceExt(), null);
    public static final Property highResolutionInfo = BRapidEyeDvr.newProperty((int)0, (BValue)BRapidEyeResolutionDetails.makeDetails(1280, 720), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property medResolutionInfo = BRapidEyeDvr.newProperty((int)0, (BValue)BRapidEyeResolutionDetails.makeDetails(640, 480), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property lowResolutionInfo = BRapidEyeDvr.newProperty((int)0, (BValue)BRapidEyeResolutionDetails.makeDetails(320, 240), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property frameRateInfo = BRapidEyeDvr.newProperty((int)4, (BValue)new BRapidEyeFrameRateDetails(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property vendor = BRapidEyeDvr.newProperty((int)1, (String)"Honeywell", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property productName = BRapidEyeDvr.newProperty((int)1, (String)"RapidEye", null);
    public static final Property productVersion = BRapidEyeDvr.newProperty((int)1, (String)"", null);
    public static final Property productMajorVersion = BRapidEyeDvr.newProperty((int)1, (int)4, null);
    public static final Property productMinorVersion = BRapidEyeDvr.newProperty((int)1, (int)9, null);
    public static final Action startSessions = BRapidEyeDvr.newAction((int)0, null);
    public static final Action stopSessions = BRapidEyeDvr.newAction((int)0, null);
    public static final Action restartSessions = BRapidEyeDvr.newAction((int)0, null);
    public static final Type TYPE;
    static final int SESSION_INIT = 0;
    static final int SESSION_STARTING = 1;
    static final int SESSION_ACTIVE = 2;
    static final int SESSION_FAULT = 4;
    static final int SESSION_STOPPED = 5;
    static long ticks;
    public boolean needToDisconnect;
    public int dvrId;
    RapidEyeTcpListener listener;
    public LiveSession liveSession;
    public AlarmSession alarmSession;
    public EventSession eventSession;
    static /* synthetic */ Class class$com$tridium$nrapidEye$BRapidEyeDvr;
    static /* synthetic */ Class class$com$tridium$nrapidEye$BRapidEyeCamera;

    public String getInitStatus() {
        return this.getString(initStatus);
    }

    public void setInitStatus(String string) {
        this.setString(initStatus, string, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public String getRapidEyeUserName() {
        return this.getString(rapidEyeUserName);
    }

    public void setRapidEyeUserName(String string) {
        this.setString(rapidEyeUserName, string, null);
    }

    public BPassword getRapidEyePassword() {
        return (BPassword)this.get(rapidEyePassword);
    }

    public void setRapidEyePassword(BPassword bPassword) {
        this.set(rapidEyePassword, (BValue)bPassword, null);
    }

    public BRelTime getDurationForEvents() {
        return (BRelTime)this.get(durationForEvents);
    }

    public void setDurationForEvents(BRelTime bRelTime) {
        this.set(durationForEvents, (BValue)bRelTime, null);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamPreferred() {
        return (BFoxVideoStreamEnum)this.get(foxVideoStreamPreferred);
    }

    public void setFoxVideoStreamPreferred(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(foxVideoStreamPreferred, (BValue)bFoxVideoStreamEnum, null);
    }

    public BCameraDeviceExt getCameras() {
        return (BCameraDeviceExt)this.get(cameras);
    }

    public void setCameras(BCameraDeviceExt bCameraDeviceExt) {
        this.set(cameras, (BValue)bCameraDeviceExt, null);
    }

    public BRapidEyeResolutionDetails getHighResolutionInfo() {
        return (BRapidEyeResolutionDetails)this.get(highResolutionInfo);
    }

    public void setHighResolutionInfo(BRapidEyeResolutionDetails bRapidEyeResolutionDetails) {
        this.set(highResolutionInfo, (BValue)bRapidEyeResolutionDetails, null);
    }

    public BRapidEyeResolutionDetails getMedResolutionInfo() {
        return (BRapidEyeResolutionDetails)this.get(medResolutionInfo);
    }

    public void setMedResolutionInfo(BRapidEyeResolutionDetails bRapidEyeResolutionDetails) {
        this.set(medResolutionInfo, (BValue)bRapidEyeResolutionDetails, null);
    }

    public BRapidEyeResolutionDetails getLowResolutionInfo() {
        return (BRapidEyeResolutionDetails)this.get(lowResolutionInfo);
    }

    public void setLowResolutionInfo(BRapidEyeResolutionDetails bRapidEyeResolutionDetails) {
        this.set(lowResolutionInfo, (BValue)bRapidEyeResolutionDetails, null);
    }

    public BRapidEyeFrameRateDetails getFrameRateInfo() {
        return (BRapidEyeFrameRateDetails)this.get(frameRateInfo);
    }

    public void setFrameRateInfo(BRapidEyeFrameRateDetails bRapidEyeFrameRateDetails) {
        this.set(frameRateInfo, (BValue)bRapidEyeFrameRateDetails, null);
    }

    public String getVendor() {
        return this.getString(vendor);
    }

    public void setVendor(String string) {
        this.setString(vendor, string, null);
    }

    public String getProductName() {
        return this.getString(productName);
    }

    public void setProductName(String string) {
        this.setString(productName, string, null);
    }

    public String getProductVersion() {
        return this.getString(productVersion);
    }

    public void setProductVersion(String string) {
        this.setString(productVersion, string, null);
    }

    public int getProductMajorVersion() {
        return this.getInt(productMajorVersion);
    }

    public void setProductMajorVersion(int n) {
        this.setInt(productMajorVersion, n, null);
    }

    public int getProductMinorVersion() {
        return this.getInt(productMinorVersion);
    }

    public void setProductMinorVersion(int n) {
        this.setInt(productMinorVersion, n, null);
    }

    public void startSessions() {
        this.invoke(startSessions, null, null);
    }

    public void stopSessions() {
        this.invoke(stopSessions, null, null);
    }

    public void restartSessions() {
        this.invoke(restartSessions, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BRapidEyeNetwork.TYPE;
    }

    protected Type getMultistreamVideoStreamRequestType() {
        return null;
    }

    public void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        return null;
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
    }

    public Type getVideoCameraType() {
        return BRapidEyeCamera.TYPE;
    }

    public boolean supportsMultistream() {
        return false;
    }

    public void videoDvrStarted() throws Exception {
        super.videoDvrStarted();
        if (this.getDvrId() == 0) {
            this.fixId();
        }
        if (!this.supportsMultistream()) {
            this.setFlags((Slot)multistreamPreferences, this.getFlags((Slot)multistreamPreferences) | 1 | 4);
        }
        NComm nComm = this.getRapidEyeVideoNetwork().tcpcomm();
        ((TcpLinkLayer)nComm.getLinkLayer()).registerTcpEvenListener((ITcpEventListener)this);
        this.liveSession = new LiveSession();
        this.alarmSession = new AlarmSession();
        this.eventSession = new EventSession();
        this.doStartSessions();
        this.listener = new RapidEyeTcpListener(this);
        nComm.registerCommListener((ICommListener)this.listener, (ICommFilter)new RapidEyeCommFilter(this), false);
    }

    public void stopped() throws Exception {
        try {
            this.getRapidEyeVideoNetwork().tcpcomm().unregisterCommListener((ICommListener)this.listener, null);
            if (this.getComponentSpace().isProxyComponentSpace()) {
                this.stopNativeCommunicator();
            }
            this.doStopSessions();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.stopped();
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (!(bComponent instanceof BRapidEyeNetwork)) {
            return false;
        }
        Class clazz = class$com$tridium$nrapidEye$BRapidEyeDvr;
        if (clazz == null) {
            clazz = class$com$tridium$nrapidEye$BRapidEyeDvr = BRapidEyeDvr.class("[Lcom.tridium.nrapidEye.BRapidEyeDvr;", false);
        }
        if (bComponent.getChildren(clazz).length >= 100) {
            throw new LocalizableRuntimeException("BRapidEye", "Cannot add more than 99 Dvr");
        }
        return true;
    }

    private final void fixId() {
        BRapidEyeNetwork bRapidEyeNetwork = this.getRapidEyeVideoNetwork();
        Class clazz = class$com$tridium$nrapidEye$BRapidEyeDvr;
        if (clazz == null) {
            clazz = class$com$tridium$nrapidEye$BRapidEyeDvr = BRapidEyeDvr.class("[Lcom.tridium.nrapidEye.BRapidEyeDvr;", false);
        }
        BRapidEyeDvr[] bRapidEyeDvrArray = (BRapidEyeDvr[])DrUtil.getDecendantsByClass((BComponent)bRapidEyeNetwork, (Class)clazz);
        boolean[] blArray = new boolean[100];
        int n = 0;
        while (n < bRapidEyeDvrArray.length) {
            int n2 = bRapidEyeDvrArray[n].getDvrId();
            if (n2 != 0 && n2 < blArray.length) {
                blArray[n2] = true;
            }
            ++n;
        }
        n = 1;
        while (n < blArray.length) {
            if (!blArray[n]) {
                ((BRapidEyeDvrId)this.getVideoDeviceId()).setDvrId(n);
                return;
            }
            ++n;
        }
    }

    public void doPing() throws Exception {
        if (!this.allSessionsActive()) {
            this.implStartSessions();
            return;
        }
        RapidEyeDvrPingRequest rapidEyeDvrPingRequest = new RapidEyeDvrPingRequest(this);
        rapidEyeDvrPingRequest.setAddress(this.getAddress());
        try {
            RapidEyeDvrPingResponse rapidEyeDvrPingResponse = (RapidEyeDvrPingResponse)this.getRapidEyeVideoNetwork().tcpcomm().sendRequest((NMessage)rapidEyeDvrPingRequest);
            rapidEyeDvrPingResponse.process(this);
            this.pingOk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.pingFail("DVR Ping Failed");
        }
    }

    public void doStartSessions() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BRapidEyeDvr.this.implStartSessions();
            }
        };
        this.getRapidEyeVideoNetwork().postAsync(runnable);
    }

    void implStartSessions() {
        try {
            if (((BRapidEyeIpAddress)this.getAddress()).isDefaultAddress()) {
                this.pingFail("invalid address");
                return;
            }
            this.setStatus(BStatus.make((BStatus)BStatus.ok, (String)"Init", (boolean)true));
            if (!this.liveSession.isActive()) {
                this.setInitStatus("Trying to Establish Live Session");
                this.liveSession.start();
            }
            if (!this.alarmSession.isActive()) {
                this.setInitStatus("Trying to Establish Alarm Session");
                this.alarmSession.start();
            }
            if (!this.eventSession.isActive()) {
                this.setInitStatus("Trying to Establish Event Session");
                this.eventSession.start();
            }
            this.setInitStatus("");
            this.setStatus(BStatus.ok);
            this.doPing();
        }
        catch (Exception exception) {
            this.pingFail(exception.getMessage());
            this.setInitStatus("");
            this.setStatus(BStatus.down);
        }
    }

    public void doStopSessions() {
        try {
            this.liveSession.stop();
            this.alarmSession.stop();
            this.eventSession.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doRestartSessions() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BRapidEyeDvr.this.doStopSessions();
                BRapidEyeDvr.this.implStartSessions();
            }
        };
        this.getRapidEyeVideoNetwork().postAsync(runnable);
    }

    boolean allSessionsActive() {
        boolean bl = false;
        if (this.liveSession.isActive() && this.alarmSession.isActive() && this.eventSession.isActive()) {
            bl = true;
        }
        return bl;
    }

    void sendLiveSessionRequest(LiveSession liveSession) throws Exception {
        RapidEyeLiveSessionRequest rapidEyeLiveSessionRequest = new RapidEyeLiveSessionRequest(this.getRapidEyeUserName(), this.getRapidEyePassword(), this);
        RapidEyeSessionResponse rapidEyeSessionResponse = (RapidEyeSessionResponse)liveSession.sendRequest(rapidEyeLiveSessionRequest);
        liveSession.status = rapidEyeSessionResponse.getStatus();
        if (!rapidEyeSessionResponse.isOk()) {
            throw new BajaException("Cannot create Live Session -- " + rapidEyeSessionResponse.getStatus());
        }
    }

    BINDiscoveryObject[] sendLiveDiscoverRequest(LiveSession liveSession) throws Exception {
        RapidEyeCameraDiscoverRequest rapidEyeCameraDiscoverRequest = new RapidEyeCameraDiscoverRequest();
        RapidEyeCameraDiscoverResponse rapidEyeCameraDiscoverResponse = (RapidEyeCameraDiscoverResponse)liveSession.sendRequest(rapidEyeCameraDiscoverRequest);
        rapidEyeCameraDiscoverResponse.process(this);
        return rapidEyeCameraDiscoverResponse.parseDiscoveryObjects();
    }

    void sendLiveActivateRequest(LiveSession liveSession) throws Exception {
        RapidEyeOpenLiveRequest rapidEyeOpenLiveRequest = new RapidEyeOpenLiveRequest(this.getRapidEyeUserName(), this.getRapidEyePassword());
        NMessage nMessage = liveSession.sendRequest(rapidEyeOpenLiveRequest);
        if (nMessage == null) {
            throw new BajaException("Cannot activate Live Session");
        }
    }

    void sendAlarmSessionRequest(AlarmSession alarmSession) throws Exception {
        RapidEyeAlarmSessionRequest rapidEyeAlarmSessionRequest = new RapidEyeAlarmSessionRequest(this.getRapidEyeUserName(), this.getRapidEyePassword());
        RapidEyeSessionResponse rapidEyeSessionResponse = (RapidEyeSessionResponse)alarmSession.sendRequest(rapidEyeAlarmSessionRequest);
        alarmSession.status = rapidEyeSessionResponse.getStatus();
        if (!rapidEyeSessionResponse.isOk()) {
            throw new BajaException("Cannot create Alarm Session -- " + rapidEyeSessionResponse.getStatus());
        }
    }

    RESensors sendSensorsRequest(RapidEyeSession rapidEyeSession) throws Exception {
        RapidEyeSensorsRequest rapidEyeSensorsRequest = new RapidEyeSensorsRequest(this.getRapidEyeUserName(), this.getRapidEyePassword());
        RapidEyeSensorsResponse rapidEyeSensorsResponse = (RapidEyeSensorsResponse)rapidEyeSession.sendRequest(rapidEyeSensorsRequest);
        return rapidEyeSensorsResponse.getSensors();
    }

    public void sendEventSessionRequest(EventSession eventSession) throws Exception {
        RapidEyeEventSessionRequest rapidEyeEventSessionRequest = new RapidEyeEventSessionRequest(this.getRapidEyeUserName(), this.getRapidEyePassword());
        RapidEyeSessionResponse rapidEyeSessionResponse = (RapidEyeSessionResponse)eventSession.sendRequest(rapidEyeEventSessionRequest);
        eventSession.status = rapidEyeSessionResponse.getStatus();
        if (!rapidEyeSessionResponse.isOk()) {
            throw new BajaException("Cannot create Event Session -- " + rapidEyeSessionResponse.getStatus());
        }
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BRapidEyeDvrAlarmSourceInfo bRapidEyeDvrAlarmSourceInfo = new BRapidEyeDvrAlarmSourceInfo();
        bRapidEyeDvrAlarmSourceInfo.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bRapidEyeDvrAlarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        bRapidEyeDvrAlarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return bRapidEyeDvrAlarmSourceInfo;
    }

    public BRapidEyeNetwork getRapidEyeVideoNetwork() {
        return (BRapidEyeNetwork)this.vnetwork();
    }

    private final TcpLinkLayer link() {
        return (TcpLinkLayer)this.getRapidEyeVideoNetwork().tcpcomm().getLinkLayer();
    }

    public Log getLog() {
        return Log.getLog((String)(this.getName() + '_' + this.getIpAddress()));
    }

    public int getDvrId() {
        return ((BRapidEyeDvrId)this.getVideoDeviceId()).getDvrId();
    }

    public native String getDeviceError(int var1, int var2);

    public native int InitializeCommunicator(int var1, String var2, boolean var3);

    public native int initializeCom();

    public native void uninitializeCom();

    public native void unInitializeCommunicator(int var1);

    public native String pingDvr(int var1);

    public native void StopAllStreaming(int var1);

    public synchronized int connectCommunicator() {
        long l = Clock.ticks();
        if (l - ticks < 1000L) {
            try {
                Thread.sleep(1000L - (l - ticks));
            }
            catch (Exception exception) {}
        }
        if (this.isConnected() && this.needToDisconnect) {
            this.unInitializeCommunicator(this.dvrId);
            this.needToDisconnect = false;
            this.dvrId = -1;
        }
        if (!this.isConnected()) {
            String string = "<streamDeviceConnectionParameters><address>";
            string = string + this.getIpAddress();
            string = string + "</address><username>";
            string = string + this.getRapidEyeUserName();
            string = string + "</username><password>";
            string = string + this.getRapidEyePassword().getString();
            string = string + "</password></streamDeviceConnectionParameters>";
            this.getLog().trace("Trying to connect to the communicator >>>> ");
            this.getLog().trace(string);
            this.getLog().trace(" --- <<<< ");
            this.dvrId = this.InitializeCommunicator(this.getDvrId() - 1, string, this.getLog().isTraceOn());
            this.getLog().trace(" Connection Status " + this.dvrId);
        }
        if (this.dvrId < 0) {
            this.dvrId = -10;
            throw new BajaRuntimeException("Cannot connect to the dvr");
        }
        ticks = Clock.ticks();
        return this.dvrId;
    }

    public synchronized void disconnectCommunicator() {
        this.needToDisconnect = true;
    }

    public synchronized void stopNativeCommunicator() {
        if (this.dvrId >= 0) {
            this.unInitializeCommunicator(this.dvrId);
            this.dvrId = -1;
        }
    }

    public synchronized String getNativeDeviceError(int n) {
        if (n >= 0) {
            return this.getDeviceError(this.dvrId, n);
        }
        return null;
    }

    public String getIpAddress() {
        return ((BRapidEyeIpAddress)this.getAddress()).getIpAddress();
    }

    public BRapidEyeCamera getCamera(int n) {
        BCameraDeviceExt bCameraDeviceExt = this.getCameras();
        Class clazz = class$com$tridium$nrapidEye$BRapidEyeCamera;
        if (clazz == null) {
            clazz = class$com$tridium$nrapidEye$BRapidEyeCamera = BRapidEyeDvr.class("[Lcom.tridium.nrapidEye.BRapidEyeCamera;", false);
        }
        Object[] objectArray = bCameraDeviceExt.getChildren(clazz);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((BRapidEyeCameraId)((BRapidEyeCamera)((Object)objectArray[n2])).getVideoDeviceId()).getCameraId() == n) {
                return (BRapidEyeCamera)((Object)objectArray[n2]);
            }
            ++n2;
        }
        return null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (context == Context.decoding) {
            return;
        }
        if (property.equals((Object)address) || property.equals((Object)rapidEyeUserName) || property.equals((Object)rapidEyePassword)) {
            this.getLog().trace("Changed Parameters");
            this.doRestartSessions();
        }
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.dvrId >= 0) {
            bl = true;
        }
        return bl;
    }

    public void loadClientSideSupport() {
        this.loadForClientRapidEyeComm((Object)this, "UnableToSyncProxySpace - communicator");
    }

    void loadForClientRapidEyeComm(Object object, String string) {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null && bComponentSpace.isProxyComponentSpace() && object instanceof BComponent && (((BComponent)object).getParent() == null || !((BComponent)object).isSubscribed())) {
            BComponent bComponent = (BComponent)object;
            bComponent.lease(Integer.MAX_VALUE, Integer.MAX_VALUE);
            try {
                bComponent.getComponentSpace().sync();
            }
            catch (Exception exception) {
                this.getLog().error(string, (Throwable)exception);
            }
        }
    }

    public void socketTerminated(BIpAddress bIpAddress, boolean bl) {
        int n = bIpAddress.getSessionId();
        if (n < 0) {
            return;
        }
        if (this.liveSession.getLinkSessionId() == n) {
            this.liveSession.sessionTerminated();
        }
        if (this.alarmSession.getLinkSessionId() == n) {
            this.alarmSession.sessionTerminated();
        }
        if (this.eventSession.getLinkSessionId() == n) {
            this.eventSession.sessionTerminated();
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"sessions", 8);
        spyWriter.w((Object)"<tr>").th((Object)"session").th((Object)"state").th((Object)"link").th((Object)"status").w((Object)"</tr>\n");
        spyWriter.tr((Object)"live", (Object)this.stateToString(this.liveSession.state), (Object)Integer.toString(this.liveSession.getLinkSessionId()), (Object)this.liveSession.status);
        spyWriter.tr((Object)"alarm", (Object)this.stateToString(this.alarmSession.state), (Object)Integer.toString(this.alarmSession.getLinkSessionId()), (Object)this.alarmSession.status);
        spyWriter.tr((Object)"event", (Object)this.stateToString(this.eventSession.state), (Object)Integer.toString(this.eventSession.getLinkSessionId()), (Object)this.eventSession.status);
        spyWriter.endTable();
    }

    private final String stateToString(int n) {
        switch (n) {
            case 0: {
                return "INIT ";
            }
            case 1: {
                return "STARTING";
            }
            case 2: {
                return "ACTIVE";
            }
            case 4: {
                return "FAULT";
            }
            case 5: {
                return "STOPPED";
            }
        }
        return "??";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.needToDisconnect = false;
        this.dvrId = -1;
    }

    public BRapidEyeDvr() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrapidEye$BRapidEyeDvr;
        if (clazz == null) {
            clazz = class$com$tridium$nrapidEye$BRapidEyeDvr = BRapidEyeDvr.class("[Lcom.tridium.nrapidEye.BRapidEyeDvr;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ticks = Clock.ticks();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LiveSession
    extends RapidEyeSession {
        BINDiscoveryObject[] dis;

        void doStart() throws Exception {
            BRapidEyeDvr.this.sendLiveSessionRequest(this);
            this.dis = BRapidEyeDvr.this.sendLiveDiscoverRequest(this);
            BRapidEyeDvr.this.sendLiveActivateRequest(this);
        }

        public BINDiscoveryObject[] discoverCameras() throws Exception {
            this.stop();
            this.start();
            return this.dis;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AlarmSession
    extends RapidEyeSession {
        RESensors sensorsCache;

        void doStart() throws Exception {
            BRapidEyeDvr.this.sendAlarmSessionRequest(this);
            this.sensorsCache = BRapidEyeDvr.this.sendSensorsRequest(this);
        }

        public RESensors getSensors() {
            try {
                this.stop();
                this.start();
                return this.sensorsCache;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public RESensors getCachedSensors() {
            return this.sensorsCache;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EventSession
    extends RapidEyeSession {
        void doStart() throws Exception {
            BRapidEyeDvr.this.sendEventSessionRequest(this);
        }

        public RESensors getSensors() throws Exception {
            return BRapidEyeDvr.this.sendSensorsRequest(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class RapidEyeSession {
        BRapidEyeIpAddress adr;
        int state;
        String status;

        private final synchronized void init() throws Exception {
            if (this.adr != null) {
                this.stop();
            }
            this.adr = (BRapidEyeIpAddress)BRapidEyeDvr.this.getAddress().newCopy(true);
            this.adr.setSessionId(BRapidEyeDvr.this.link().createSession((BIpAddress)this.adr));
        }

        synchronized void sessionTerminated() {
            if (this.state == 2) {
                try {
                    this.stop();
                }
                catch (Exception exception) {}
                try {
                    this.start();
                }
                catch (Exception exception) {}
            } else {
                this.adr = null;
                this.state = 5;
            }
        }

        synchronized void stop() throws Exception {
            if (this.adr == null) {
                return;
            }
            BRapidEyeDvr.this.link().closeSession(this.adr.getSessionId());
            this.adr = null;
            this.state = 5;
        }

        public synchronized void sendMessage(NMessage nMessage) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            nMessage.setAddress((BAddress)this.adr);
            BRapidEyeDvr.this.getRapidEyeVideoNetwork().tcpcomm().sendMessage(nMessage);
        }

        public synchronized NMessage sendRequest(NMessage nMessage) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            nMessage.setAddress((BAddress)this.adr);
            return BRapidEyeDvr.this.getRapidEyeVideoNetwork().tcpcomm().sendRequest(nMessage);
        }

        public void restart() throws Exception {
            if (this.adr != null) {
                this.stop();
            }
            this.start();
        }

        public boolean isActive() {
            boolean bl = false;
            if (this.state == 2) {
                bl = true;
            }
            return bl;
        }

        synchronized void start() throws Exception {
            try {
                this.state = 1;
                this.init();
                this.doStart();
                this.state = 2;
            }
            catch (Exception exception) {
                this.state = 4;
                throw exception;
            }
        }

        abstract void doStart() throws Exception;

        synchronized int getLinkSessionId() {
            if (this.adr == null) {
                return -1;
            }
            return this.adr.getSessionId();
        }

        private final /* synthetic */ void this() {
            this.state = 0;
            this.status = "";
        }

        public RapidEyeSession() {
            this.this();
        }
    }
}

