/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.rapidEyeObjects;

import java.io.IOException;
import javax.baja.nre.util.ByteBuffer;

public class RECommHeader {
    public int messageId = 0;
    public int dataLength = 0;
    public int classId = 0;

    public RECommHeader(int n, int n2, int n3) {
        this.messageId = n;
        this.dataLength = n2;
        this.classId = n3;
    }

    public RECommHeader(int n) {
        this(n, 0, 0);
    }

    public RECommHeader() {
        this(0, 0, 0);
    }

    public RECommHeader(ByteBuffer byteBuffer) throws IOException {
        this.fromBuffer(byteBuffer);
    }

    public RECommHeader(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        this.fromBuffer(byteBuffer);
        if (this.messageId != n || this.classId != n2) {
            throw new IOException();
        }
    }

    public RECommHeader(ByteBuffer byteBuffer, int n) throws IOException {
        this(byteBuffer, n, 0);
    }

    public static final int linearSize() {
        return 12;
    }

    public void fromBuffer(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.setBigEndian(false);
        byteBuffer.seek(0);
        this.messageId = byteBuffer.readInt();
        this.dataLength = byteBuffer.readInt();
        this.classId = byteBuffer.readInt();
        if (this.messageId <= 0 || this.classId < 0 || this.dataLength < 0 || this.dataLength > 1000000) {
            throw new IOException();
        }
    }

    public void toBuffer(ByteBuffer byteBuffer) {
        byteBuffer.setBigEndian(false);
        byteBuffer.seek(0);
        byteBuffer.writeInt(this.messageId);
        byteBuffer.writeInt(this.dataLength);
        byteBuffer.writeInt(this.classId);
    }
}

