/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.comm;

import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.comm.MessageElement;
import com.tridium.flexSerial.comm.TLinkedListManager;
import com.tridium.flexSerial.messages.SerialMessageConst;
import com.tridium.flexSerial.messages.SerialReceivedMessage;
import javax.baja.sys.BBlob;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FlexSerialUnsolicitedReceive
implements Runnable,
UnsolicitedMessageListener,
SerialMessageConst {
    private static Integer DEFAULT_TAG = new Integer(-1);
    private TLinkedListManager unsolicitedMessageManager;
    private BFlexSerialNetwork host;
    private boolean timeToDie;
    private Thread myThread;

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "FlexSerialUnsolicitedReceive");
        this.myThread.start();
    }

    public final void stop() {
        this.timeToDie = true;
        this.myThread.interrupt();
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    public void run() {
        this.unsolicitedMessageManager = new TLinkedListManager("FlexSerialUnsolicitedReceive Manager");
        while (!this.timeToDie) {
            MessageElement messageElement;
            try {
                messageElement = (MessageElement)this.unsolicitedMessageManager.removeFromHead(-1);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("\n processing message");
                messageElement = null;
            }
            try {
                if (messageElement == null) continue;
                SerialReceivedMessage serialReceivedMessage = messageElement.getMessage();
                this.processUnsolicitedMessage(serialReceivedMessage);
            }
            catch (Exception exception) {
                System.out.println(" FlexSerialUnsolicitedReceive thread caught Exception: " + exception);
            }
        }
    }

    protected synchronized void processUnsolicitedMessage(SerialReceivedMessage serialReceivedMessage) {
        String string = serialReceivedMessage.getStringMessage();
        this.host.getUnsolicitedMessage().setValue(string);
        this.host.setUnsolicitedByteArray(BBlob.make((byte[])serialReceivedMessage.getBytes(), (int)0, (int)serialReceivedMessage.getLength()));
        this.host.fireUnsolicitedMessageReceived(null);
    }

    public void receiveMessage(ReceivedMessage receivedMessage) {
        MessageElement messageElement = new MessageElement((SerialReceivedMessage)receivedMessage);
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail(messageElement);
        }
    }

    public Object getUnsolicitedListenerCode() {
        return DEFAULT_TAG;
    }

    private final /* synthetic */ void this() {
        this.unsolicitedMessageManager = null;
        this.timeToDie = true;
    }

    public FlexSerialUnsolicitedReceive(BFlexSerialNetwork bFlexSerialNetwork) {
        this.this();
        this.host = bFlexSerialNetwork;
    }
}

