/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Thu_Apr__8_03:39:04_PDT_2010";

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        SQLName sQLName = new SQLName(string, (OracleConnection)connection);
        return OpaqueDescriptor.createDescriptor(sQLName, connection);
    }

    public static OpaqueDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        String string = sQLName.getName();
        OpaqueDescriptor opaqueDescriptor = (OpaqueDescriptor)((OracleConnection)connection).getDescriptor(string);
        if (opaqueDescriptor == null) {
            opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
            ((OracleConnection)connection).putDescriptor(string, opaqueDescriptor);
        }
        return opaqueDescriptor;
    }

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super(sQLName, oracleTypeOPAQUE, connection);
    }

    private void initPickler() throws SQLException {
        try {
            this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.shareBytes() != null) {
            byArray = oPAQUE.shareBytes();
        } else {
            try {
                byArray = this.pickler.linearize(oPAQUE);
            }
            finally {
                if (!bl) {
                    oPAQUE.setShareBytes(null);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.value != null) {
            byArray = oPAQUE.value;
        } else {
            try {
                this.pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
                byArray = oPAQUE.value;
            }
            finally {
                if (!bl) {
                    oPAQUE.value = null;
                }
            }
        }
        return byArray;
    }

    public int getTypeCode() {
        return 2007;
    }

    public long getMaxLength() throws SQLException {
        long l = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
        return l;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
    }

    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isModeledInC();
    }

    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
    }

    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.descType(stringBuffer, 0);
        return string;
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        String string3 = stringBuffer.toString();
        return string3;
    }

    public Class getClass(Map map) throws SQLException {
        Class clazz = null;
        String string = this.getName();
        Class clazz2 = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
            clazz2 = (Class)map.get(string3);
        }
        if (!SQLName.s_parseAllFormat) {
            clazz = clazz2;
        } else {
            if (clazz2 == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
                clazz2 = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
            clazz = clazz2;
        }
        return clazz;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

