/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.oracle.BOracleConnectionPool;
import com.tridium.rdb.oracle.history.BOracleHistoryDeviceExt;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.apache.commons.dbcp.DelegatingConnection;

public class BOracleDatabase
extends BRdbms {
    public static final Property port = BOracleDatabase.newProperty((int)0, (int)1521, null);
    public static final Property serviceName = BOracleDatabase.newProperty((int)0, (String)"", null);
    public static final Property histories = BOracleDatabase.newProperty((int)0, (BValue)new BOracleHistoryDeviceExt(), null);
    public static final Property connectionPool = BOracleDatabase.newProperty((int)4, (BValue)new BOracleConnectionPool(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$oracle$BOracleDatabase == null ? (class$com$tridium$rdb$oracle$BOracleDatabase = BOracleDatabase.class$("com.tridium.rdb.oracle.BOracleDatabase")) : class$com$tridium$rdb$oracle$BOracleDatabase));
    private final RdbmsDialect DIALECT = new RdbmsDialect(){
        private static final String SEQUENCE_SUFFIX = "SQ";
        private static final int MAX_SEQUENCE_LEN = 30;

        public String getValidationQuery() {
            return "select 1 from dual";
        }

        public void issueCheckpoint(Connection connection) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 0;
        }

        public String getIdentityCreation() {
            throw new UnsupportedOperationException();
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String string) {
            return this.makeSuffixName(string, SEQUENCE_SUFFIX, 30);
        }

        private String makeSuffixName(String string, String string2, int n) {
            int n2;
            int n3 = string.length();
            if (n3 + (n2 = string2.length()) <= n) {
                return string + string2;
            }
            return string.substring(0, n - n2) + string2;
        }

        public String getSequenceLookup(String string) {
            return "SELECT " + this.getSequenceName(string) + ".NEXTVAL FROM DUAL";
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LENGTH";
        }

        public int getMaxTableName() {
            return 30;
        }

        public int getMaxIndexName() {
            return 30;
        }

        public int getMaxConstraintName() {
            return 30;
        }

        public int getMaxColumnName() {
            return 30;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String string, String string2, String string3) {
            if (string != null && string.length() > 0) {
                return string + "." + string2 + ".\"" + string3 + "\"";
            }
            return string2 + ".\"" + string3 + "\"";
        }

        public String getTableIdentifier(String string, String string2) {
            if (string != null && string.length() > 0) {
                return string + "." + string2;
            }
            return string2;
        }

        public String getDropIndex(String string, String string2) {
            return "DROP INDEX " + string2;
        }

        public String getDropConstraint(String string, Constraint constraint) {
            return "ALTER TABLE " + string + " " + "DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INT";
        }

        public String getLongType() {
            return "INT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "FLOAT";
        }

        public String getCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR2" : "VARCHAR2";
        }

        public String getUuidType() {
            return "RAW(16)";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return false;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return !BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcMillis);
        }

        public boolean useUtcTimestamps() {
            return BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "BLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return false;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, byte[] byArray) {
            try {
                Connection connection = rdbmsPreparedStatement.getConnection();
                PreparedStatement preparedStatement = rdbmsPreparedStatement.getStatement();
                Connection connection2 = connection;
                if (connection2 instanceof DelegatingConnection) {
                    connection2 = ((DelegatingConnection)connection2).getInnermostDelegate();
                }
                BLOB bLOB = BLOB.createTemporary(connection2, false, 10);
                bLOB.open(1);
                OutputStream outputStream = bLOB.getBinaryOutputStream();
                outputStream.write(byArray);
                outputStream.flush();
                outputStream.close();
                bLOB.close();
                preparedStatement.setBlob(n, bLOB);
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException((Throwable)iOException);
            }
            catch (SQLException sQLException) {
                throw new BajaRuntimeException((Throwable)sQLException);
            }
        }

        public String getClobType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCLOB" : "CLOB";
        }

        public boolean usesDefaultClobTranslator() {
            return false;
        }

        public void setClobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, String string) {
            try {
                Connection connection = rdbmsPreparedStatement.getConnection();
                PreparedStatement preparedStatement = rdbmsPreparedStatement.getStatement();
                Connection connection2 = connection;
                if (connection2 instanceof DelegatingConnection) {
                    connection2 = ((DelegatingConnection)connection2).getInnermostDelegate();
                }
                CLOB cLOB = CLOB.createTemporary(connection2, false, 10);
                cLOB.open(1);
                Writer writer = cLOB.getCharacterOutputStream();
                writer.write(string.toCharArray());
                writer.flush();
                writer.close();
                cLOB.close();
                preparedStatement.setClob(n, cLOB);
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException((Throwable)iOException);
            }
            catch (SQLException sQLException) {
                throw new BajaRuntimeException((Throwable)sQLException);
            }
        }

        public String getOnDelete(int n) {
            switch (n) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "SET NULL";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return 1;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 2;
        }

        public int getJdbcTypeFloat() {
            return 2;
        }

        public int getJdbcTypeInt() {
            return 2;
        }

        public int getJdbcTypeLong() {
            return 2;
        }

        public int getJdbcTypeTimestamp() {
            return 93;
        }

        public int getJdbcTypeUuid() {
            return -3;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    static /* synthetic */ Class class$com$tridium$rdb$oracle$BOracleDatabase;

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public String getServiceName() {
        return this.getString(serviceName);
    }

    public void setServiceName(String string) {
        this.setString(serviceName, string, null);
    }

    public BOracleHistoryDeviceExt getHistories() {
        return (BOracleHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BOracleHistoryDeviceExt bOracleHistoryDeviceExt) {
        this.set(histories, (BValue)bOracleHistoryDeviceExt, null);
    }

    public BOracleConnectionPool getConnectionPool() {
        return (BOracleConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BOracleConnectionPool bOracleConnectionPool) {
        this.set(connectionPool, (BValue)bOracleConnectionPool, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOracleDatabase() {
    }

    public BOracleDatabase(BOrd bOrd, int n, String string) {
        this.setHostAddress(bOrd);
        this.setPort(n);
        this.setServiceName(string);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbOracle");
    }

    public Connection getConnection(String string, BPassword bPassword) throws SQLException {
        BStatus bStatus = this.getStatus();
        if (bStatus.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(string, bPassword.getString());
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

