/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.oracle.BOracleDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp.BasicDataSource;

public class BOracleConnectionPool
extends BAbstractConnectionPool {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$oracle$BOracleConnectionPool == null ? (class$com$tridium$rdb$oracle$BOracleConnectionPool = BOracleConnectionPool.class$("com.tridium.rdb.oracle.BOracleConnectionPool")) : class$com$tridium$rdb$oracle$BOracleConnectionPool));
    private static final String CUSTOM_JDBC_URL = "customJdbcUrl";
    private BasicDataSource ds;
    static /* synthetic */ Class class$com$tridium$rdb$oracle$BOracleConnectionPool;

    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
            Log.getLog((String)"rdbOracle").trace("oracle connection stats:  numActive: " + this.getNumActive() + ", " + " peakNumActive: " + this.getPeakNumActive() + ", " + " numIdle: " + this.getNumIdle());
        }
    }

    protected Connection obtainConnection(String string, String string2) throws SQLException {
        String string3;
        BOracleDatabase bOracleDatabase = (BOracleDatabase)this.getParent();
        Property property = bOracleDatabase.getProperty(CUSTOM_JDBC_URL);
        if (property == null) {
            string3 = "jdbc:oracle:thin:@//" + bOracleDatabase.getHostname() + ":" + bOracleDatabase.getPort() + "/" + bOracleDatabase.getServiceName();
        } else {
            string3 = bOracleDatabase.getString(property);
            Log.getLog((String)"rdb").trace("using custom jdbc connection: " + string3);
        }
        if (this.ds == null) {
            Log.getLog((String)"rdb").trace("initializing connection pool for " + string3);
            this.ds = this.makeDataSource(string3, string, string2);
        } else if (!(this.ds.getUrl().equals(string3) && this.ds.getUsername().equals(string) && this.ds.getPassword().equals(string2))) {
            Log.getLog((String)"rdb").trace("re-initializing connection pool for " + string3);
            this.ds.close();
            this.ds = this.makeDataSource(string3, string, string2);
        }
        return this.ds.getConnection();
    }

    private BasicDataSource makeDataSource(String string, String string2, String string3) {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        basicDataSource.setUrl(string);
        basicDataSource.setUsername(string2);
        basicDataSource.setPassword(string3);
        basicDataSource.setMaxActive(this.getMaxActive());
        basicDataSource.setMaxIdle(this.getMaxIdle());
        basicDataSource.setMaxWait(this.getMaxWait());
        basicDataSource.setAccessToUnderlyingConnectionAllowed(true);
        return basicDataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

