/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dras;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.dras.BDrasDevice;
import com.tridium.dras.BDrasDeviceFolder;
import com.tridium.dras.BDrasEventOpModeSchedule;
import com.tridium.dras.enums.BDrasEventStatusEnum;
import com.tridium.dras.point.BDrasProxyExt;
import com.tridium.dras.util.BDrasPollScheduler;
import com.tridium.dras.util.DrasPollingThread;
import javax.baja.control.BEnumPoint;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDrasNetwork
extends BBasicNetwork {
    public static final Property tuningPolicies = BDrasNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property restUrl = BDrasNetwork.newProperty((int)0, (String)"", null);
    public static final Property pollScheduler = BDrasNetwork.newProperty((int)0, (BValue)new BDrasPollScheduler(), null);
    public static final Property sslPort = BDrasNetwork.newProperty((int)0, (int)443, null);
    public static final Property drasServerConnectionTimeout = BDrasNetwork.newProperty((int)0, (BValue)BRelTime.make((long)20000L), null);
    public static final Property workOnCacheEnabled = BDrasNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property workOnCacheFrequency = BDrasNetwork.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Type TYPE;
    DrasPollingThread eventMonitoringThread;
    Log logDRAS;
    static /* synthetic */ Class class$com$tridium$dras$BDrasNetwork;
    static /* synthetic */ Class class$com$tridium$dras$BDrasDevice;
    static /* synthetic */ Class class$com$tridium$dras$BDrasEventOpModeSchedule;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public String getRestUrl() {
        return this.getString(restUrl);
    }

    public void setRestUrl(String string) {
        this.setString(restUrl, string, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler bPollScheduler) {
        this.set(pollScheduler, (BValue)bPollScheduler, null);
    }

    public int getSslPort() {
        return this.getInt(sslPort);
    }

    public void setSslPort(int n) {
        this.setInt(sslPort, n, null);
    }

    public BRelTime getDrasServerConnectionTimeout() {
        return (BRelTime)this.get(drasServerConnectionTimeout);
    }

    public void setDrasServerConnectionTimeout(BRelTime bRelTime) {
        this.set(drasServerConnectionTimeout, (BValue)bRelTime, null);
    }

    public boolean getWorkOnCacheEnabled() {
        return this.getBoolean(workOnCacheEnabled);
    }

    public void setWorkOnCacheEnabled(boolean bl) {
        this.setBoolean(workOnCacheEnabled, bl, null);
    }

    public BRelTime getWorkOnCacheFrequency() {
        return (BRelTime)this.get(workOnCacheFrequency);
    }

    public void setWorkOnCacheFrequency(BRelTime bRelTime) {
        this.set(workOnCacheFrequency, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BDrasDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BDrasDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        this.doPing();
        if (this.isNetworkOk()) {
            this.startEventMonitoringThread();
        }
    }

    private final boolean isNetworkOk() {
        boolean bl = false;
        if (!(this.isDown() || this.isFatalFault() || this.isDisabled())) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public void doPing() {
        if (this.isCryptoServiceRunning()) {
            this.pingOk();
        } else {
            this.pingFail("Crypto Service not running");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopEventMonitoringThread();
    }

    private final void startEventMonitoringThread() {
        this.eventMonitoringThread = new DrasPollingThread(this);
        this.eventMonitoringThread.setThreadToBeRun(true);
        this.eventMonitoringThread.start();
    }

    private final void stopEventMonitoringThread() {
        if (this.eventMonitoringThread != null) {
            this.eventMonitoringThread.setThreadToBeRun(false);
            this.eventMonitoringThread = null;
        }
    }

    public void changed(Property property, Context context) {
        if (property == sslPort || property == restUrl) {
            Class clazz = class$com$tridium$dras$BDrasDevice;
            if (clazz == null) {
                clazz = class$com$tridium$dras$BDrasDevice = BDrasNetwork.class("[Lcom.tridium.dras.BDrasDevice;", false);
            }
            BDrasDevice[] bDrasDeviceArray = (BDrasDevice[])this.getChildren(clazz);
            int n = 0;
            while (n < bDrasDeviceArray.length) {
                bDrasDeviceArray[n].setRESTUrl(this.getRestUrl(), this.getSslPort());
                bDrasDeviceArray[n].doPing();
                ++n;
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.startEventMonitoringThread();
            } else {
                this.stopEventMonitoringThread();
            }
        }
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    protected Comm makeComm() {
        return null;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "adr");
    }

    public boolean isCryptoServiceRunning() {
        boolean bl = true;
        return bl;
    }

    private final boolean hasEvents() {
        boolean bl = false;
        BDrasDevice[] bDrasDeviceArray = this.getBPortDevices();
        int n = 0;
        while (n < bDrasDeviceArray.length) {
            if (bDrasDeviceArray[n].hasEvents()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void monitorEvents() {
        if (this.hasEvents() && this.getEnabled() && this.getWorkOnCacheEnabled()) {
            BDrasDevice[] bDrasDeviceArray = this.getBPortDevices();
            int n = 0;
            while (n < bDrasDeviceArray.length) {
                this.logDRAS.trace(bDrasDeviceArray[n].getName() + " ::Monitor events in progress");
                BEnumPoint bEnumPoint = bDrasDeviceArray[n].getEventsWithOpModeSchedules();
                if (bEnumPoint != null) {
                    BDrasProxyExt bDrasProxyExt = (BDrasProxyExt)bEnumPoint.getProxyExt();
                    if (!this.getPollScheduler().getPollEnabled()) {
                        bDrasProxyExt.setCurrentTime(0.0);
                    }
                    BAbsTime bAbsTime = BAbsTime.now();
                    this.logDRAS.trace("Current Time = " + bAbsTime.toString() + " , Event start time = " + bDrasProxyExt.getStartTime().toString() + " , Event End time = " + bDrasProxyExt.getEndTime().toString());
                    if (bAbsTime.getTimeOfDayMillis() < bDrasProxyExt.getEndTime().getTimeOfDayMillis() && bAbsTime.getTimeOfDayMillis() > bDrasProxyExt.getStartTime().getTimeOfDayMillis()) {
                        BFolder bFolder = bDrasProxyExt.getOpModeSchedules();
                        Class clazz = class$com$tridium$dras$BDrasEventOpModeSchedule;
                        if (clazz == null) {
                            clazz = BDrasNetwork.class("[Lcom.tridium.dras.BDrasEventOpModeSchedule;", false);
                        }
                        BDrasEventOpModeSchedule[] bDrasEventOpModeScheduleArray = (BDrasEventOpModeSchedule[])bFolder.getChildren(clazz);
                        int n2 = 0;
                        while (n2 < bDrasEventOpModeScheduleArray.length) {
                            long l = bAbsTime.getTimeOfDayMillis();
                            long l2 = (long)((double)bDrasProxyExt.getStartTime().getTimeOfDayMillis() + bDrasEventOpModeScheduleArray[n2].getModeTimeOffset() * 1000.0);
                            if (n2 != bDrasEventOpModeScheduleArray.length - 1) {
                                long l3 = (long)((double)bDrasProxyExt.getStartTime().getTimeOfDayMillis() + bDrasEventOpModeScheduleArray[n2 + 1].getModeTimeOffset() * 1000.0);
                                if (l >= l2 && l < l3) {
                                    bDrasDeviceArray[n].setEventStatus(BDrasEventStatusEnum.active.toString());
                                    bDrasProxyExt.setEventStatus(BDrasEventStatusEnum.active);
                                    bDrasProxyExt.readOk((BStatusValue)new BStatusEnum((BEnum)bDrasEventOpModeScheduleArray[n2].getOpModeValue()));
                                    bDrasDeviceArray[n].setOperationModeValue(bDrasEventOpModeScheduleArray[n2].getOpModeValue().getTag());
                                    this.logDRAS.trace("Setting readOk with value " + bDrasEventOpModeScheduleArray[n2].getOpModeValue().getTag() + " in MonitorEvents 1");
                                    break;
                                }
                            } else if (l >= l2 && l <= bDrasProxyExt.getEndTime().getTimeOfDayMillis()) {
                                bDrasProxyExt.readOk((BStatusValue)new BStatusEnum((BEnum)bDrasEventOpModeScheduleArray[n2].getOpModeValue()));
                                bDrasDeviceArray[n].setOperationModeValue(bDrasEventOpModeScheduleArray[n2].getOpModeValue().getTag());
                                bDrasProxyExt.setEventStatus(BDrasEventStatusEnum.active);
                                bDrasDeviceArray[n].setEventStatus(BDrasEventStatusEnum.active.toString());
                                this.logDRAS.trace("Setting readOk with value " + bDrasEventOpModeScheduleArray[n2].getOpModeValue().getTag() + " in MonitorEvents 2");
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void setThreadToRunMode(boolean bl) {
        this.eventMonitoringThread.setThreadToBeRun(bl);
    }

    public BDrasDevice[] getBPortDevices() {
        Class clazz = class$com$tridium$dras$BDrasDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dras$BDrasDevice = BDrasNetwork.class("[Lcom.tridium.dras.BDrasDevice;", false);
        }
        return (BDrasDevice[])this.getChildren(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.eventMonitoringThread = null;
        this.logDRAS = Log.getLog((String)"DRAS");
    }

    public BDrasNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dras$BDrasNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$dras$BDrasNetwork = BDrasNetwork.class("[Lcom.tridium.dras.BDrasNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

