/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dras;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.dras.BDrasEventOpModeSchedule;
import com.tridium.dras.BDrasNetwork;
import com.tridium.dras.DrasRestUtility;
import com.tridium.dras.enums.BDrasEventStatusEnum;
import com.tridium.dras.enums.BDrasOperationModeValueEnum;
import com.tridium.dras.point.BDrasProgram;
import com.tridium.dras.point.BDrasProxyExt;
import java.io.IOException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.control.BEnumPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDrasDevice
extends BBasicDevice
implements BIBasicPollable {
    public static final Property userName = BDrasDevice.newProperty((int)0, (String)"", null);
    public static final Property password = BDrasDevice.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Property pollFrequency = BDrasDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property eventStatus = BDrasDevice.newProperty((int)1, (String)"", null);
    public static final Property operationModeValue = BDrasDevice.newProperty((int)1, (String)"", null);
    public static final Property currentTime = BDrasDevice.newProperty((int)5, (int)0, null);
    public static final Property lastPollTime = BDrasDevice.newProperty((int)1, (BValue)BAbsTime.now(), null);
    public static final Property addAlarm = BDrasDevice.newProperty((int)4, (boolean)false, null);
    public static final Property pollWaitCount = BDrasDevice.newProperty((int)0, (int)5, null);
    public static final Type TYPE;
    private boolean mHasEvents;
    public boolean toContinue;
    DrasRestUtility mRESTClient;
    Log logDRAS;
    private boolean mIsPollInProgress;
    private int mIsPollInProgressCount;
    private Object mPollingProgressSync;
    private Object mPollingProgressCountSync;
    static /* synthetic */ Class class$com$tridium$dras$BDrasDevice;
    static /* synthetic */ Class class$com$tridium$dras$point$BDrasProgram;
    static /* synthetic */ Class class$javax$baja$control$BEnumPoint;
    static /* synthetic */ Class class$com$tridium$dras$BDrasEventOpModeSchedule;

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public String getEventStatus() {
        return this.getString(eventStatus);
    }

    public void setEventStatus(String string) {
        this.setString(eventStatus, string, null);
    }

    public String getOperationModeValue() {
        return this.getString(operationModeValue);
    }

    public void setOperationModeValue(String string) {
        this.setString(operationModeValue, string, null);
    }

    public double getCurrentTime() {
        return this.getDouble(currentTime);
    }

    public void setCurrentTime(double d) {
        this.setDouble(currentTime, d, null);
    }

    public BAbsTime getLastPollTime() {
        return (BAbsTime)this.get(lastPollTime);
    }

    public void setLastPollTime(BAbsTime bAbsTime) {
        this.set(lastPollTime, (BValue)bAbsTime, null);
    }

    public boolean getAddAlarm() {
        return this.getBoolean(addAlarm);
    }

    public void setAddAlarm(boolean bl) {
        this.setBoolean(addAlarm, bl, null);
    }

    public int getPollWaitCount() {
        return this.getInt(pollWaitCount);
    }

    public void setPollWaitCount(int n) {
        this.setInt(pollWaitCount, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BDrasNetwork getDrasNetwork() {
        return (BDrasNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BDrasNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        BDrasNetwork bDrasNetwork = this.getDrasNetwork();
        this.mRESTClient = new DrasRestUtility(this, this.getUserName(), this.getPassword().getString(), this.getDrasNetwork().getSslPort(), this.getDrasNetwork().getRestUrl());
        bDrasNetwork.getPollScheduler().subscribe((BIPollable)this);
    }

    public void stopped() throws Exception {
        ((BDrasNetwork)this.getNetwork()).getPollScheduler().unsubscribe((BIPollable)this);
        if (this.mRESTClient != null) {
            this.mRESTClient = null;
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == userName || property == password) {
            this.getRestClient().setUidPwd(this.getUserName(), this.getPassword().getString());
            this.doPing();
        }
    }

    public DrasRestUtility getRestClient() {
        return this.mRESTClient;
    }

    public void poll() {
        try {
            DrasPollThread drasPollThread = new DrasPollThread("DrasPoller:PollThread", this, true);
            drasPollThread.start();
            drasPollThread.join(this.getDrasNetwork().getDrasServerConnectionTimeout().getMillis());
        }
        catch (Exception exception) {
            this.logDRAS.error(this.getName() + ":: Poll got into exception, " + exception.getMessage());
            this.pingFail("Thread Exception in poll :: " + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pollOrPingForData(boolean bl) {
        long l = System.currentTimeMillis();
        this.logDRAS.trace(this.getName() + "****** START " + (bl ? " POLL " : " PING ") + "*******");
        if (bl && !this.isDeviceOk()) {
            this.logDRAS.error(this.getName() + "::Device is down. POLL request was not sent");
            this.setIsPollInProgress(false);
            this.setPollInProgressCount(0);
            return;
        }
        if (this.getIsPollInProgress()) {
            this.incrementPollInProgressCount();
            if (this.getPollInProgressCount() < this.getPollWaitCount()) {
                this.logDRAS.error(this.getName() + " :: Poll is already in progress, current poll waiting count:: " + this.getPollInProgressCount());
                return;
            }
            this.setPollInProgressCount(0);
            this.setIsPollInProgress(false);
            if (this.getAddAlarm()) {
                this.addAlarmRecord();
            }
            this.logDRAS.error(this.getName() + " :: Single poll is in progress for a longer time. Resetting PollInProgress flag to false");
        }
        try {
            block13: {
                try {
                    this.setIsPollInProgress(true);
                    this.logDRAS.trace(this.getName() + " - " + (bl ? " POLL " : " PING ") + " in progress");
                    XElem xElem = this.getRestClient().connectToServer();
                    if (xElem != null) {
                        if (bl) {
                            boolean bl2 = this.parseEventInfoWithXParser(xElem);
                            BEnumPoint bEnumPoint = this.getEventAlreadyModeled(this.getProgram());
                            String string = ((BDrasProxyExt)bEnumPoint.getProxyExt()).getDrasClientId();
                            String string2 = ((BDrasProxyExt)bEnumPoint.getProxyExt()).getEventIdentifer();
                            String string3 = "" + ((BDrasProxyExt)bEnumPoint.getProxyExt()).getEventModNumber();
                            String string4 = ((BDrasProxyExt)bEnumPoint.getProxyExt()).getEventStatus().toString();
                            if (this.getRestClient().sendResponse(this.createResponse(bl2, string, string2, string3, string4))) {
                                this.logDRAS.trace(this.getName() + "::Poll:: Confirmation Sent to DRAS server");
                                this.setLastPollTime(BAbsTime.now());
                                break block13;
                            } else {
                                this.logDRAS.trace(this.getName() + "::Poll:: Confirmation not sent to DRAS server");
                            }
                            break block13;
                        }
                        this.pingOk();
                        break block13;
                    }
                    this.pingFail(this.getRestClient().getErrorString());
                    this.logDRAS.error(this.getName() + "::No response received for the " + (bl ? " POLL " : " PING ") + " request");
                }
                catch (Exception exception) {
                    this.logDRAS.error(this.getName() + ":: " + (bl ? " POLL " : " PING ") + " caught into exception ", (Throwable)exception);
                    this.pingFail("Device " + (bl ? " POLL " : " PING ") + " exception::" + exception.getMessage());
                }
            }
            Object var5_14 = null;
            this.setIsPollInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            this.setIsPollInProgress(false);
            throw throwable;
        }
        long l2 = System.currentTimeMillis();
        this.logDRAS.trace(this.getName() + "****** FINISH " + (bl ? " POLL " : " PING ") + ", time taken::" + (l2 - l) + " millisecs *******");
    }

    public boolean parseEventInfoWithXParser(XElem xElem) {
        boolean bl = false;
        try {
            if (xElem != null) {
                boolean bl2;
                boolean bl3;
                String string;
                String string2;
                int n;
                String string3;
                int n2;
                String string4;
                String string5;
                EventState eventState = new EventState();
                eventState.mDrasClientID = string5 = xElem.get("drasClientID");
                eventState.mProgramName = string4 = xElem.get("programName");
                eventState.mEventModNumber = n2 = Integer.parseInt(xElem.get("eventModNumber").trim());
                eventState.mEventIdentifier = string3 = xElem.get("eventIdentifier");
                eventState.mEventStateId = n = Integer.parseInt(xElem.get("eventStateID").trim());
                eventState.mSchemaVersion = string2 = xElem.get("schemaVersion");
                eventState.mDrasName = string = xElem.get("drasName");
                eventState.mTestEvent = bl3 = Boolean.getBoolean(xElem.get("testEvent"));
                eventState.mOffline = bl2 = Boolean.getBoolean(xElem.get("offLine"));
                XElem xElem2 = xElem.elem("drEventData");
                if (xElem2 != null) {
                    this.parseSmartEventData(xElem2, eventState);
                    this.logDRAS.trace(this.getName() + "::Event START TIME " + eventState.mEventStartTime);
                    this.logDRAS.trace(this.getName() + "::Event End TIME " + eventState.mEventEndTime);
                    this.logDRAS.trace(this.getName() + "::Event Notification TIME " + eventState.mEventNotificationTime);
                } else {
                    this.logDRAS.trace(this.getName() + "::There is no smart event data, Cannot handle Operation mode schedule for this event " + n);
                }
                XElem xElem3 = xElem.elem("simpleDRModeData");
                if (xElem3 != null) {
                    bl = this.parseSimpleEventData(xElem3, eventState);
                } else {
                    this.logDRAS.trace(this.getName() + "::Simple DR mode data is missing in the event state info");
                    this.clearAllProxySlots();
                }
            } else {
                this.logDRAS.trace(this.getName() + "::Event state information is missing in the response xml");
                this.clearAllProxySlots();
            }
        }
        catch (Exception exception) {
            this.logDRAS.error(this.getName() + " ,Parse Event gets into exception -" + exception.getMessage());
        }
        return bl;
    }

    private final void clearAllProxySlots() {
        BDrasProxyExt bDrasProxyExt;
        BDrasProgram bDrasProgram = this.getProgram();
        BEnumPoint bEnumPoint = this.getEventAlreadyModeled(bDrasProgram);
        if (bEnumPoint != null && (bDrasProxyExt = (BDrasProxyExt)bEnumPoint.getProxyExt()) != null) {
            bDrasProxyExt.getOpModeSchedules().removeAll();
            bDrasProxyExt.setDrasName("");
            bDrasProxyExt.setDrasClientId("");
            bDrasProxyExt.setEventIdentifer("");
            bDrasProxyExt.setProgramName("");
            bDrasProxyExt.setSchemaVersion("");
            bDrasProxyExt.setEventModNumber(0);
            bDrasProxyExt.setEventStateId(0);
            bDrasProxyExt.setEventStatus(BDrasEventStatusEnum.none);
            bDrasProxyExt.setCurrentTime(0.0);
            bDrasProxyExt.setStartTime(BAbsTime.DEFAULT);
            bDrasProxyExt.setEndTime(BAbsTime.DEFAULT);
            bDrasProxyExt.setNotificationTime(BAbsTime.DEFAULT);
            bDrasProxyExt.setTestEvent(false);
            bDrasProxyExt.setOffline(false);
        }
    }

    private final void parseSmartEventData(XElem xElem, EventState eventState) {
        XElem xElem2 = xElem.elem("notificationTime");
        XElem xElem3 = xElem.elem("startTime");
        XElem xElem4 = xElem.elem("endTime");
        if (xElem2 != null) {
            try {
                eventState.mEventNotificationTime = BAbsTime.make((String)xElem2.string());
            }
            catch (IOException iOException) {
                this.logDRAS.error(this.getName(), (Throwable)iOException);
            }
        }
        if (xElem3 != null) {
            try {
                eventState.mEventStartTime = BAbsTime.make((String)xElem3.string());
            }
            catch (IOException iOException) {
                this.logDRAS.error("DrasDevice " + this.getName(), (Throwable)iOException);
            }
        }
        if (xElem4 != null) {
            try {
                eventState.mEventEndTime = BAbsTime.make((String)xElem4.string());
            }
            catch (IOException iOException) {
                this.logDRAS.error("DrasDevice " + this.getName(), (Throwable)iOException);
            }
        }
    }

    private final boolean parseSimpleEventData(XElem xElem, EventState eventState) {
        boolean bl = false;
        XElem xElem2 = xElem.elem("EventStatus");
        if (xElem2 != null) {
            this.logDRAS.trace(this.getName() + "::Event state " + xElem2.string());
            String string = xElem2.string().toLowerCase();
            eventState.mSimpleEventData.mEventStatus = BDrasEventStatusEnum.make(string);
            bl = this.handleEvents(eventState, xElem, string);
        }
        return bl;
    }

    public BDrasProgram getProgram() {
        BDrasProgram[] bDrasProgramArray;
        BDrasProgram bDrasProgram = null;
        Class clazz = class$com$tridium$dras$point$BDrasProgram;
        if (clazz == null) {
            clazz = class$com$tridium$dras$point$BDrasProgram = BDrasDevice.class("[Lcom.tridium.dras.point.BDrasProgram;", false);
        }
        if ((bDrasProgramArray = (BDrasProgram[])this.getChildren(clazz)) != null && bDrasProgramArray.length > 0) {
            bDrasProgram = bDrasProgramArray[0];
        }
        return bDrasProgram;
    }

    public boolean handleEvents(EventState eventState, XElem xElem, String string) {
        this.mHasEvents = true;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        BDrasProxyExt bDrasProxyExt = null;
        BDrasProgram bDrasProgram = null;
        bDrasProgram = this.getProgram();
        if (bDrasProgram != null) {
            bl3 = true;
        } else {
            bDrasProgram = new BDrasProgram();
        }
        if (eventState.mProgramName.equalsIgnoreCase("")) {
            bDrasProgram.setProgramName("Program");
        } else {
            bDrasProgram.setProgramName(eventState.mProgramName);
        }
        BEnumPoint bEnumPoint = this.getEventAlreadyModeled(bDrasProgram);
        if (bEnumPoint == null) {
            bEnumPoint = new BEnumPoint();
            bEnumPoint.setFacets(BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BDrasOperationModeValueEnum.TYPE)));
            bDrasProxyExt = new BDrasProxyExt();
            bEnumPoint.setProxyExt((BAbstractProxyExt)bDrasProxyExt);
        } else {
            bDrasProxyExt = (BDrasProxyExt)bEnumPoint.getProxyExt();
            bl2 = true;
        }
        bDrasProxyExt.setProgramName(eventState.mProgramName);
        bDrasProxyExt.setDrasClientId(eventState.mDrasClientID);
        bDrasProxyExt.setDrasName(eventState.mDrasName);
        bDrasProxyExt.setEventIdentifer(eventState.mEventIdentifier);
        bDrasProxyExt.setEventModNumber(eventState.mEventModNumber);
        bDrasProxyExt.setEventStateId(eventState.mEventStateId);
        bDrasProxyExt.setSchemaVersion(eventState.mSchemaVersion);
        bDrasProxyExt.setTestEvent(eventState.mTestEvent);
        bDrasProxyExt.setOffline(eventState.mOffline);
        bDrasProxyExt.setNotificationTime(eventState.mEventNotificationTime);
        bDrasProxyExt.setStartTime(eventState.mEventStartTime);
        bDrasProxyExt.setEndTime(eventState.mEventEndTime);
        this.pingOk();
        bDrasProxyExt.setEventStatus(BDrasEventStatusEnum.make(string));
        this.setEventStatus(string);
        if (!bl2) {
            bDrasProgram.add("Event", (BValue)bEnumPoint);
        }
        if (!bl3) {
            this.add("Program", (BValue)bDrasProgram);
        }
        this.parseOpModeSchedule(xElem, bDrasProxyExt);
        return bl;
    }

    private final void parseOpModeSchedule(XElem xElem, BDrasProxyExt bDrasProxyExt) {
        XElem[] xElemArray;
        String string;
        bDrasProxyExt.getOpModeSchedules().removeAll();
        XElem xElem2 = xElem.elem("OperationModeValue");
        if (xElem2 != null) {
            string = xElem2.string().toLowerCase();
            bDrasProxyExt.readOk((BStatusValue)new BStatusEnum((BEnum)BDrasOperationModeValueEnum.make(string)));
            this.logDRAS.trace("Setting readOk with value " + string + " in parseOpModeSchedule");
            this.pingOk();
            this.setOperationModeValue(string);
        } else {
            this.logDRAS.error("Cannot call readOK on proxy point. Op Mode value XML tag is null");
            bDrasProxyExt.readFail("Op Mode value tag is null in the DRAS response");
        }
        string = xElem.elem("currentTime");
        if (string != null) {
            bDrasProxyExt.setCurrentTime(Double.parseDouble(string.string().trim()));
            this.setCurrentTime(Double.parseDouble(string.string().trim()));
            this.logDRAS.trace(this.getName() + "::Current Time:: " + string.string().trim());
        } else {
            this.logDRAS.error(this.getName() + "::Simple DR Mode Data: Current time field is null");
        }
        XElem xElem3 = xElem.elem("operationModeSchedule");
        if (xElem3 != null && (xElemArray = xElem3.elems("modeSlot")) != null) {
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem4 = xElemArray[n].elem("OperationModeValue");
                XElem xElem5 = xElemArray[n].elem("modeTimeSlot");
                if (xElem4 != null && xElem5 != null) {
                    String string2 = xElem4.string();
                    BDrasEventOpModeSchedule bDrasEventOpModeSchedule = new BDrasEventOpModeSchedule();
                    if (string2 != null) {
                        bDrasEventOpModeSchedule.setOpModeValue(BDrasOperationModeValueEnum.make(string2.trim().toLowerCase()));
                        bDrasEventOpModeSchedule.setModeTimeOffset(Integer.parseInt(xElem5.string().trim()));
                        bDrasProxyExt.getOpModeSchedules().add("Schedule" + n, (BValue)bDrasEventOpModeSchedule);
                    }
                }
                ++n;
            }
        }
    }

    private final BEnumPoint getEventAlreadyModeled(BDrasProgram bDrasProgram) {
        BEnumPoint bEnumPoint = null;
        if (bDrasProgram != null) {
            BEnumPoint[] bEnumPointArray;
            Class clazz = class$javax$baja$control$BEnumPoint;
            if (clazz == null) {
                clazz = class$javax$baja$control$BEnumPoint = BDrasDevice.class("[Ljavax.baja.control.BEnumPoint;", false);
            }
            if ((bEnumPointArray = (BEnumPoint[])bDrasProgram.getChildren(clazz)) != null && bEnumPointArray.length > 0) {
                bEnumPoint = bEnumPointArray[0];
            }
        }
        return bEnumPoint;
    }

    public boolean hasEvents() {
        return this.mHasEvents;
    }

    public StringBuffer createResponse(boolean bl, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<p:eventStateConfirmation currentTime=\"" + this.getCurrentTime() + "\" drasClientID=\"" + string + '\"');
        stringBuffer.append(" eventIdentifier=\"" + string2 + "\" eventModNumber=\"" + string3 + "\" eventStateID=\"" + string4 + '\"');
        stringBuffer.append(" operationModeValue=\"" + this.getOperationModeValue() + "\" optInStatus=\"" + (bl ^ true) + "\" programName=\"Niagara\"");
        stringBuffer.append(" schemaVersion=\"\" xmlns:p=\"urn:EventState\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xsi:schemaLocation=\"urn:EventState EventState.xsd \">");
        stringBuffer.append("</p:eventStateConfirmation>");
        this.logDRAS.trace(stringBuffer.toString());
        return stringBuffer;
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        this.logDRAS.trace(this.getName() + "::Ping DRAS Server");
        try {
            DrasPollThread drasPollThread = new DrasPollThread("DrasPoller:PingThread", this, false);
            drasPollThread.start();
            drasPollThread.join(this.getDrasNetwork().getDrasServerConnectionTimeout().getMillis());
        }
        catch (Exception exception) {
            this.mIsPollInProgress = false;
            this.logDRAS.error(this.getName() + "::doPing() got into exception ", (Throwable)exception);
            this.pingFail("Thread Exception in ping :: " + exception.getMessage());
        }
    }

    public BEnumPoint getEventsWithOpModeSchedules() {
        BDrasProgram[] bDrasProgramArray;
        BEnumPoint bEnumPoint = null;
        Class clazz = class$com$tridium$dras$point$BDrasProgram;
        if (clazz == null) {
            clazz = class$com$tridium$dras$point$BDrasProgram = BDrasDevice.class("[Lcom.tridium.dras.point.BDrasProgram;", false);
        }
        if ((bDrasProgramArray = (BDrasProgram[])this.getChildren(clazz)) != null && bDrasProgramArray.length > 0) {
            BFolder bFolder;
            BEnumPoint[] bEnumPointArray;
            BDrasProgram bDrasProgram = bDrasProgramArray[0];
            Class clazz2 = class$javax$baja$control$BEnumPoint;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$control$BEnumPoint = BDrasDevice.class("[Ljavax.baja.control.BEnumPoint;", false);
            }
            if ((bEnumPointArray = (BEnumPoint[])bDrasProgram.getChildren(clazz2)) != null && bEnumPointArray.length > 0 && bEnumPointArray[0].getProxyExt() instanceof BDrasProxyExt && (bFolder = ((BDrasProxyExt)bEnumPointArray[0].getProxyExt()).getOpModeSchedules()) != null) {
                BDrasEventOpModeSchedule[] bDrasEventOpModeScheduleArray;
                Class clazz3 = class$com$tridium$dras$BDrasEventOpModeSchedule;
                if (clazz3 == null) {
                    clazz3 = class$com$tridium$dras$BDrasEventOpModeSchedule = BDrasDevice.class("[Lcom.tridium.dras.BDrasEventOpModeSchedule;", false);
                }
                if ((bDrasEventOpModeScheduleArray = (BDrasEventOpModeSchedule[])bFolder.getChildren(clazz3)) != null && bDrasEventOpModeScheduleArray.length > 0) {
                    bEnumPoint = bEnumPointArray[0];
                }
            }
        }
        return bEnumPoint;
    }

    public boolean isDeviceOk() {
        boolean bl = false;
        if (!(this.isDown() || this.isFatalFault() || this.isDisabled())) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public void setRESTUrl(String string, int n) {
        if (this.getRestClient() != null) {
            this.getRestClient().setUrlPort(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIsPollInProgress() {
        Object object = this.mPollingProgressSync;
        synchronized (object) {
            return this.mIsPollInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIsPollInProgress(boolean bl) {
        Object object = this.mPollingProgressSync;
        synchronized (object) {
            this.mIsPollInProgress = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPollInProgressCount() {
        Object object = this.mPollingProgressCountSync;
        synchronized (object) {
            return this.mIsPollInProgressCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void incrementPollInProgressCount() {
        Object object = this.mPollingProgressCountSync;
        synchronized (object) {
            ++this.mIsPollInProgressCount;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPollInProgressCount(int n) {
        Object object = this.mPollingProgressCountSync;
        synchronized (object) {
            this.mIsPollInProgressCount = n;
            return;
        }
    }

    private final void addAlarmRecord() {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (bAlarmService != null) {
            this.logDRAS.trace("Adding alarm record");
            BAlarmRecord bAlarmRecord = new BAlarmRecord();
            bAlarmRecord.setTimestamp(BAbsTime.now());
            BFacets bFacets = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)"Poll progressing count exceeded, may be the device was down"));
            bAlarmRecord.setAlarmData(bFacets);
            bAlarmRecord.setSource(BOrdList.make((BOrd)this.getNavOrd()));
            bAlarmService.routeAlarm(bAlarmRecord);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mHasEvents = false;
        this.toContinue = true;
        this.logDRAS = Log.getLog((String)"DRAS");
        this.mIsPollInProgress = false;
        this.mIsPollInProgressCount = 0;
        this.mPollingProgressSync = new Object();
        this.mPollingProgressCountSync = new Object();
    }

    public BDrasDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dras$BDrasDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dras$BDrasDevice = BDrasDevice.class("[Lcom.tridium.dras.BDrasDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DrasPollThread
    extends Thread {
        BDrasDevice mDevice;
        boolean mIsPoll;

        public void run() {
            if (this.mDevice != null) {
                BDrasDevice.this.logDRAS.trace("DrasPollThread starting doPoll ::" + this.mIsPoll);
                this.mDevice.pollOrPingForData(this.mIsPoll);
            }
        }

        private final /* synthetic */ void this() {
            this.mDevice = null;
            this.mIsPoll = true;
        }

        public DrasPollThread(String string, BDrasDevice bDrasDevice2, boolean bl) {
            this.this();
            this.mDevice = bDrasDevice2;
            this.setName(string);
            this.mIsPoll = bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EventState {
        public String mProgramName;
        public int mEventModNumber;
        public String mEventIdentifier;
        public String mDrasClientID;
        public int mEventStateId;
        public String mSchemaVersion;
        public String mDrasName;
        public boolean mTestEvent;
        public boolean mOffline;
        public BAbsTime mEventNotificationTime;
        public BAbsTime mEventStartTime;
        public BAbsTime mEventEndTime;
        public SimpleClientEventData mSimpleEventData;

        private final /* synthetic */ void this() {
            this.mProgramName = "";
            this.mEventModNumber = 0;
            this.mEventIdentifier = "";
            this.mDrasClientID = "";
            this.mEventStateId = 0;
            this.mSchemaVersion = "";
            this.mDrasName = "";
            this.mTestEvent = false;
            this.mOffline = false;
            this.mEventNotificationTime = BAbsTime.now();
            this.mEventStartTime = BAbsTime.now();
            this.mEventEndTime = BAbsTime.now();
            this.mSimpleEventData = new SimpleClientEventData();
        }

        private EventState() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SimpleClientEventData {
        public BDrasEventStatusEnum mEventStatus;

        private final /* synthetic */ void this() {
            this.mEventStatus = BDrasEventStatusEnum.none;
        }

        private SimpleClientEventData() {
            this.this();
        }
    }
}

