/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciN2Parser;

import com.jci.jciN2Parser.AppHeader;
import com.jci.jciN2Parser.Category;
import com.jci.jciN2Parser.JciObject;
import com.jci.jciN2Parser.util.N2ParseUtil;
import java.util.ArrayList;
import java.util.Collection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImportData {
    private AppHeader appHeader;
    private Collection error;
    private Collection category;
    private Category currCategory;
    private JciObject currObject;
    private int categoryIndex;
    private int deviceAddress;
    private String mappingFileName;
    private String noPathXmlFileName;
    private String baseXmlDirectoryName;
    private String baseControllerName;
    private String itemReferenceFileName;

    public void setError(Collection collection) {
        this.error = collection;
    }

    public Collection getError() {
        return this.error;
    }

    public void setAppHeader(AppHeader appHeader) {
        this.appHeader = appHeader;
    }

    public AppHeader getAppHeader() {
        return this.appHeader;
    }

    public void setCategory(Collection collection) {
        this.category = collection;
    }

    public Collection getCategory() {
        return this.category;
    }

    public void setCurrentCategory(Category category) {
        this.currCategory = category;
    }

    public Category getCurrentCategory() {
        return this.currCategory;
    }

    public JciObject getCurrentObject() {
        return this.currObject;
    }

    public void setMappingFile(String string) {
        this.mappingFileName = string;
    }

    public String getMappingFile() {
        return this.mappingFileName;
    }

    public void setDeviceAddress(int n) {
        this.deviceAddress = n;
    }

    public void setBaseControllerName(String string) {
        this.baseControllerName = string;
    }

    public void setNoPathXmlFileName(String string) {
        this.noPathXmlFileName = string;
    }

    public void setBaseXmlDirectoryName(String string) {
        this.baseXmlDirectoryName = string;
    }

    public void setItemReference(String string) {
        String[] stringArray = N2ParseUtil.tocanizeString((String)string, (String)"/:", (boolean)false);
        this.itemReferenceFileName = stringArray[stringArray.length - 1] + '.';
    }

    public String getXmlFileName() {
        return this.itemReferenceFileName + this.noPathXmlFileName;
    }

    public void clearAllData() {
        this.category.clear();
        this.categoryIndex = 0;
        this.currCategory = null;
        this.currObject = null;
    }

    public void addCategory(int n, int n2, String string, boolean bl) {
        Category category = new Category();
        category.setIsMappable(new Boolean(bl));
        category.setSet(n);
        category.setEnum(n2);
        if (n == -1) {
            category.setText(N2ParseUtil.removeInvalidChars((String)string, (boolean)false));
        } else {
            category.setText(null);
        }
        this.category.add(category);
        this.currCategory = (Category)this.category.toArray()[this.category.size() - 1];
    }

    public void removeLastCategoryIfEmpty() {
        if (this.currCategory != null && this.currCategory.getObject().isEmpty()) {
            this.category.remove(this.currCategory);
            int n = this.category.size() - 1;
            if (n < 0) {
                this.currCategory = null;
                return;
            }
            this.currCategory = (Category)this.category.toArray()[n];
        }
    }

    public void addSubCategory(int n, int n2, String string, boolean bl) {
        Category category = new Category();
        category.setIsMappable(new Boolean(bl));
        category.setSet(n);
        category.setEnum(n2);
        if (n == -1) {
            category.setText(N2ParseUtil.removeInvalidChars((String)string, (boolean)false));
        } else {
            category.setText(null);
        }
        this.currCategory = (Category)this.category.toArray()[this.category.size() - 1];
        this.currCategory.getCategory().add(category);
        this.currCategory = (Category)this.currCategory.getCategory().toArray()[this.currCategory.getCategory().size() - 1];
    }

    public void removeLastSubCategoryIfEmpty() {
        if (this.currCategory != null && this.currCategory.getObject().isEmpty()) {
            ((Category)this.category.toArray()[this.category.size() - 1]).getCategory().remove(this.currCategory);
            if (this.currCategory.getCategory().size() > 0) {
                this.currCategory = (Category)this.currCategory.getCategory().toArray()[this.currCategory.getCategory().size() - 1];
            }
        }
    }

    public void addObject(JciObject jciObject) {
        this.currCategory.getObject().add(jciObject);
        this.currObject = (JciObject)this.currCategory.getObject().toArray()[this.currCategory.getObject().size() - 1];
    }

    public boolean marshal() {
        return false;
    }

    private final /* synthetic */ void this() {
        this.deviceAddress = -1;
        this.itemReferenceFileName = "";
    }

    public ImportData() {
        this.this();
        this.categoryIndex = 0;
        this.category = new ArrayList(10);
    }
}

