/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciN2Parser;

import com.jci.jciCoreParser.BJciAbstractParseImportFile;
import com.jci.jciCoreParser.imports.DataTypeEnum;
import com.jci.jciCoreParser.util.DMON2Point;
import com.jci.jciN2Parser.AppHeader;
import com.jci.jciN2Parser.BJciParseN2File;
import com.jci.jciN2Parser.Controller;
import com.jci.jciN2Parser.ImportData;
import com.jci.jciN2Parser.imports.N2Maps;
import com.jci.jciN2Parser.util.N2ParseUtil;
import com.tridium.jcin2.BJciDx9100Device;
import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.BJciN2Network;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciParseDmo
extends BJciAbstractParseImportFile
implements BJciParseN2File {
    public static final Type TYPE;
    static final Lexicon lex;
    private static String[] sHeaderEntries;
    private static String dmoTokenDelim;
    private static int POINT_TYPE_INDEX;
    private static int POINT_TAG_INDEX;
    private static int POINT_UNUSED1_INDEX;
    private static int POINT_LNAME_INDEX;
    private static int POINT_NAME_INDEX;
    private static int POINT_UNITS_INDEX;
    private static int POINT_UNITS2_INDEX;
    private static int LAST_POINT_INDEX;
    private static int HDR_VER_INDEX;
    private static int HDR_FILE_INDEX;
    private static int HDR_TYPE_INDEX;
    private static int HDR_MODEL_INDEX;
    private static int HDR_LAST_INDEX;
    private static String longNameIndication;
    private static String longNameDelim;
    private static final int DMO_FILE = 0;
    private Controller myController;
    private String sCurLine;
    private String sControllerType;
    private int controllerType;
    private boolean hadAnError;
    private BJciN2Device n2Device;
    private BJciN2Network n2Network;
    private int n2DeviceAddress;
    private ImportData importData;
    private StringBuffer pointWarningDetails;
    static /* synthetic */ Class class$com$jci$jciN2Parser$BJciParseDmo;

    public Type getType() {
        return TYPE;
    }

    public ImportData getImportData() {
        return this.importData;
    }

    public String getControllerType() {
        return this.sControllerType;
    }

    public void addLinks() {
        if (this.myController != null) {
            this.myController.doLinks();
        }
    }

    public int checkMatchOnDeviceAndFileType() {
        int n = 0;
        if (this.localDevice != null && !(this.localDevice instanceof BJciDx9100Device)) {
            n = 1;
            this.logError(lex.getText("parseDMO.mismatchDeviceType"));
        }
        return n;
    }

    public int startParse() {
        this.myController = new Controller();
        this.myController.setSourceFileType(0);
        this.myController.setUpdateActionMenu(this.getUpdateActionMenu());
        this.myController.shell = this.shell;
        this.myController.parser = this;
        if (this.getOutputFileName().length() > 0) {
            this.myController.setOutputFileName(this.getOutputFileName());
        }
        this.myController.setN2Network((BJciN2Network)this.getNetwork());
        this.myController.setN2DeviceName(this.getDeviceName());
        this.myController.setN2DeviceAddress(this.getN2DeviceAddress());
        if (this.localDevice != null) {
            this.myController.setN2Device((BJciN2Device)this.localDevice);
        }
        this.importData.clearAllData();
        int n = 0;
        this.hadAnError = false;
        this.pointWarningDetails = new StringBuffer();
        try {
            while ((this.sCurLine = this.lineReader.readLine()) != null) {
                if (this.sCurLine.indexOf("DDL Source File") != -1) {
                    if (!this.parseHeader()) continue;
                    n = this.handleParseConflict();
                    continue;
                }
                if (this.sCurLine.indexOf("INPUTS") != -1) {
                    if (this.sCurLine.indexOf("NETWORK INPUTS") != -1 || !this.parseGroup(0, 1)) continue;
                    n = this.handleParseConflict();
                    continue;
                }
                if (this.sCurLine.indexOf("OUTPUTS") != -1) {
                    if (!this.parseGroup(3, 3)) continue;
                    n = this.handleParseConflict();
                    continue;
                }
                if (this.sCurLine.indexOf("PROGRAMMABLE MODULES") == -1 || !this.parseModules()) continue;
                n = this.handleParseConflict();
            }
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseDMO.ErrorReading") + ' ' + lex.getText("parse.FromMethod") + ": startparse");
        }
        this.setAppGroup(this.myController.getAppGroup());
        this.setAppName(this.myController.getAppName());
        this.myController.addPoints();
        String string = this.myController.parseComplete();
        if (string.length() > 0) {
            this.logError(string);
            n = -1;
        }
        return n;
    }

    protected boolean verifyConfigFile() {
        boolean bl = true;
        int n = -1;
        try {
            this.sCurLine = this.lineReader.readLine();
            if (this.sCurLine != null) {
                n = this.sCurLine.indexOf(sHeaderEntries[HDR_FILE_INDEX]);
                if (n != -1) {
                    bl = false;
                } else {
                    this.logError(lex.getText("parseDMO.InvalidHeader"));
                }
            } else {
                this.logError(lex.getText("parseDMO.ErrorReading"));
            }
            this.resetLineNumber(0);
        }
        catch (Exception exception) {
            System.out.println("exception in verifyconfigfile");
            this.logError(lex.getText("parseDMO.ErrorReading") + ' ' + lex.getText("parse.FromMethod") + ": verifyConfigFile");
            return true;
        }
        return bl;
    }

    private final boolean parseHeader() {
        try {
            String[] stringArray;
            String[] stringArray2 = new String[HDR_LAST_INDEX + 1];
            int n = 0;
            n = this.sCurLine.indexOf(sHeaderEntries[HDR_VER_INDEX]);
            if (n != -1) {
                stringArray2[BJciParseDmo.HDR_VER_INDEX] = this.sCurLine.substring((n += sHeaderEntries[HDR_VER_INDEX].length()) + 1).trim();
            }
            if ((n = this.sCurLine.indexOf(sHeaderEntries[HDR_FILE_INDEX])) != -1) {
                stringArray2[BJciParseDmo.HDR_FILE_INDEX] = this.sCurLine.substring((n += sHeaderEntries[HDR_FILE_INDEX].length()) + 1).trim();
            }
            while ((this.sCurLine = this.lineReader.readLine()) != null) {
                if (this.sCurLine.indexOf("****") != -1) break;
                n = this.sCurLine.indexOf(sHeaderEntries[HDR_VER_INDEX]);
                if (n != -1) {
                    stringArray2[BJciParseDmo.HDR_VER_INDEX] = this.sCurLine.substring((n += sHeaderEntries[HDR_VER_INDEX].length()) + 1).trim();
                }
                if ((n = this.sCurLine.indexOf(sHeaderEntries[HDR_TYPE_INDEX])) == -1) continue;
                stringArray = N2ParseUtil.tocanizeString((String)this.sCurLine, (String)dmoTokenDelim, (boolean)false);
                stringArray2[BJciParseDmo.HDR_TYPE_INDEX] = stringArray[POINT_TAG_INDEX];
                stringArray2[BJciParseDmo.HDR_MODEL_INDEX] = stringArray[2];
                break;
            }
            this.setControllerType(stringArray2[HDR_TYPE_INDEX]);
            this.myController.setDeviceType(this.controllerType);
            stringArray = this.importData.getAppHeader();
            if (stringArray == null) {
                stringArray = new AppHeader();
            }
            stringArray.addEnumProperty(1357, false, 40, String.valueOf(this.myController.getDeviceType()), this.myController.getDeviceType());
            stringArray.addStringProperty(70, false, stringArray2[HDR_MODEL_INDEX]);
            this.importData.setAppHeader((AppHeader)stringArray);
            this.importData.setBaseControllerName("Controller");
            this.importData.setBaseXmlDirectoryName("N2Imports");
            this.importData.setNoPathXmlFileName(this.noPathXmlFileName);
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseDMO.InvalidHeader") + ' ' + lex.getText("parse.FromMethod") + ": parseHeader");
            return true;
        }
        return false;
    }

    private final boolean parseGroup(int n, int n2) {
        String string = "";
        try {
            this.importData.removeLastCategoryIfEmpty();
            this.importData.addCategory(563, n, String.valueOf(n), true);
            while ((this.sCurLine = this.lineReader.readLine()) != null) {
                if (this.sCurLine.startsWith("****")) {
                    this.resetLineNumber(this.lineReader.getLineNumber() - 1);
                    return false;
                }
                if (!this.addPoint()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseDMO.InvalidGroup") + ' ' + lex.getText("parse.FromMethod") + ": parseGroup");
            return true;
        }
        return false;
    }

    private final boolean parseModules() {
        try {
            this.importData.removeLastCategoryIfEmpty();
            this.importData.addCategory(563, 9, String.valueOf(6), true);
            block2: while ((this.sCurLine = this.lineReader.readLine()) != null) {
                if (this.sCurLine.startsWith("****")) {
                    this.resetLineNumber(this.lineReader.getLineNumber() - 2);
                    break;
                }
                if (this.sCurLine.startsWith("* MODULE")) {
                    while ((this.sCurLine = this.lineReader.readLine()) != null) {
                        int n = this.sCurLine.indexOf("CSMODEL");
                        if (n == -1) continue;
                        String[] stringArray = N2ParseUtil.tocanizeString((String)this.sCurLine, (String)dmoTokenDelim, (boolean)false);
                        this.importData.removeLastSubCategoryIfEmpty();
                        this.importData.addSubCategory(-1, -1, stringArray[1], true);
                        continue block2;
                    }
                    continue;
                }
                this.addPoint();
            }
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseDMO.InvalidModules") + ' ' + lex.getText("parse.FromMethod") + ": parseModules");
            return true;
        }
        return false;
    }

    private final boolean addPoint() {
        String string = "";
        String string2 = "";
        try {
            String[] stringArray;
            if (this.sCurLine.startsWith(longNameIndication)) {
                string2 = this.sCurLine.substring(longNameIndication.length() + 1);
                stringArray = N2ParseUtil.tocanizeString((String)string2, (String)longNameDelim, (boolean)false);
                string2 = stringArray[0];
                this.sCurLine = this.lineReader.readLine();
            }
            if (!this.sCurLine.startsWith("CS")) {
                return false;
            }
            stringArray = N2ParseUtil.tocanizeString((String)this.sCurLine, (String)dmoTokenDelim, (boolean)false);
            if (stringArray[POINT_TAG_INDEX].compareTo(stringArray[POINT_NAME_INDEX]) == 0) {
                return false;
            }
            DMON2Point dMON2Point = this.buildNetPoint(stringArray);
            if (dMON2Point == null) {
                return false;
            }
            if (string2.length() > 0) {
                dMON2Point.setDescription(string2);
            }
            if ((string = this.myController.addPoint(this.importData, dMON2Point.getMappedAsClassId(), dMON2Point.getNpt(), dMON2Point.getUnits(), dMON2Point.getNameEnum(), dMON2Point.getDescription(), dMON2Point.getNptEnum(), dMON2Point.getNpa(), dMON2Point.getReadOnly())).length() > 0) {
                this.logError(string);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseDMO.Pointproblem") + ' ' + this.sCurLine);
            return false;
        }
    }

    private final int handleParseConflict() {
        return -1;
    }

    private final boolean isReadOnly(int n) {
        return false;
    }

    private final DMON2Point buildNetPoint(String[] stringArray) {
        DMON2Point dMON2Point = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        String string = stringArray[POINT_TAG_INDEX];
        String string2 = stringArray[POINT_LNAME_INDEX];
        try {
            int n7;
            int n8;
            n3 = string.indexOf("PM");
            if (n3 != -1) {
                n = this.atoi(string.substring(n3 + 2));
                string = n >= 10 ? string.substring(n3 + 4) : string.substring(n3 + 3);
            } else {
                n3 = string.indexOf("XT");
                if (n3 != -1) {
                    n2 = this.atoi(string.substring(n3 + 2));
                    string = string.substring(n3 + 3);
                }
            }
            n3 = string.indexOf("AI");
            if (n3 != -1) {
                n6 = 147;
                n5 = 1;
                n8 = this.atoi(string.substring(n3 + 2));
                n4 = n8 + n2 * 8;
            }
            if ((n3 = string.indexOf("AO")) != -1) {
                n6 = 149;
                n5 = 3;
                n8 = this.atoi(string.substring(n3 + 2));
                n4 = n8 + n2 * 8;
            }
            if ((n3 = string.indexOf("DI")) != -1) {
                n6 = 148;
                n5 = 2;
                n8 = this.atoi(string.substring(n3 + 2));
                n4 = n8 + n2 * 8;
            }
            if ((n3 = string.indexOf("OU")) != -1) {
                n7 = n3;
                n6 = 149;
                n7 = string.indexOf("OUT");
                if (n7 != -1) {
                    n5 = 3;
                    n4 = this.atoi(string.substring(n7 + 3));
                    if (n4 >= 9) {
                        n4 -= 6;
                    }
                } else {
                    n5 = 10;
                    n8 = this.atoi(string.substring(n3 + 2));
                    n4 = n8 + (n - 1) * 8;
                }
            }
            if ((n3 = string.indexOf("DO")) != -1) {
                n6 = 150;
                n4 = this.atoi(string.substring(n3 + 2));
                if (n > 0) {
                    n5 = 11;
                    n4 += (n - 1) * 8;
                } else {
                    n5 = 4;
                    n4 += n2 * 8;
                }
            }
            if ((n3 = string.indexOf("DCO")) != -1) {
                n6 = 150;
                n5 = 7;
                n4 = this.atoi(string.substring(n3 + 3));
            }
            if ((n3 = string.indexOf("LRS")) != -1) {
                n6 = 148;
                n5 = 8;
                n4 = this.atoi(string.substring(n3 + 3));
            }
            if ((n3 = string.indexOf("AC")) != -1) {
                n7 = string.indexOf("ACO");
                if (n7 != -1) {
                    n6 = 149;
                    n5 = 5;
                    n4 = this.atoi(string.substring(n7 + 3));
                } else {
                    n6 = 147;
                    n5 = 12;
                    n8 = this.atoi(string.substring(n3 + 2));
                    n4 = n8 + (n - 1) * 8;
                }
            }
            if (string.startsWith("K")) {
                n6 = 149;
                n5 = 9;
                n4 = this.atoi(string.substring(1));
                if (n4 > 20) {
                    String string3 = lex.getText("parseDMO.kValueError");
                    this.hadAnError = true;
                    this.logError(string3);
                    return null;
                }
                n4 += (n - 1) * 20;
            }
            if (n6 != -1) {
                DataTypeEnum dataTypeEnum = new DataTypeEnum();
                DataTypeEnum dataTypeEnum2 = new DataTypeEnum();
                DataTypeEnum dataTypeEnum3 = new DataTypeEnum();
                dataTypeEnum.enumSet = 23;
                dataTypeEnum.enumVal = n5;
                dataTypeEnum2.enumSet = -1;
                dataTypeEnum2.sEnum = stringArray[POINT_NAME_INDEX];
                this.getUnits(n5, dataTypeEnum3, stringArray);
                dMON2Point = new DMON2Point(dataTypeEnum3, dataTypeEnum2, string2, dataTypeEnum, n4, -1, n6);
            }
        }
        catch (Exception exception) {
            this.hadAnError = true;
            this.logError(lex.getText("parseDMO.Pointproblem") + ' ' + string);
            return null;
        }
        this.setReadOnly(dMON2Point);
        return dMON2Point;
    }

    private final void setReadOnly(DMON2Point dMON2Point) {
        if (dMON2Point != null) {
            switch (dMON2Point.getMappedAsClassId()) {
                case 147: 
                case 148: {
                    dMON2Point.setReadOnly(true);
                    break;
                }
            }
        }
    }

    private final int atoi(String string) {
        String string2 = new String("");
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(cArray[n])) break;
            string2 = string2 + cArray[n];
            ++n;
        }
        Integer n2 = string2 != "" ? new Integer(string2) : new Integer(0);
        return n2;
    }

    private final void getUnits(int n, DataTypeEnum dataTypeEnum, String[] stringArray) {
        dataTypeEnum.reset();
        dataTypeEnum.sEnum = "";
        if (stringArray.length > POINT_UNITS_INDEX) {
            dataTypeEnum.sEnum = stringArray[POINT_UNITS_INDEX];
        }
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 12: {
                dataTypeEnum.enumSet = 507;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                dataTypeEnum.enumSet = 801;
                if (stringArray.length < POINT_UNITS_INDEX + 1) break;
                dataTypeEnum.sEnum = dataTypeEnum.sEnum + ' ' + stringArray[POINT_UNITS_INDEX + 1];
                break;
            }
            default: {
                dataTypeEnum.enumSet = 507;
            }
        }
    }

    private final int getMappedAsClassId(int n, boolean bl) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 147;
                break;
            }
            case 2: {
                n2 = 148;
                break;
            }
            case 3: {
                n2 = 149;
                break;
            }
            case 4: {
                n2 = 150;
                break;
            }
            case 5: {
                n2 = bl ? 147 : 149;
                break;
            }
            case 6: {
                n2 = bl ? 147 : 149;
                break;
            }
            case 7: {
                n2 = bl ? 148 : 150;
                break;
            }
        }
        return n2;
    }

    private final void setControllerType(String string) {
        Integer n;
        String string2 = string;
        if (string.compareTo("DX9100") == 0) {
            string2 = "DX-9100";
        }
        if ((n = (Integer)N2Maps.N2_CTRL_HASH_MAP.get(string2)) != null) {
            this.sControllerType = string2;
            this.controllerType = n;
            this.myController.setDeviceType(this.controllerType);
        }
    }

    public BJciN2Device getN2Device() {
        return this.n2Device;
    }

    public int getN2DeviceAddress() {
        return this.n2DeviceAddress;
    }

    public BJciN2Network getN2Network() {
        return this.n2Network;
    }

    public void setDeviceInfo(BJciN2Network bJciN2Network, String string, Integer n) {
        System.out.println("in setdeviceinfo of parsedmo network " + bJciN2Network + " devicename " + string + " address " + n);
        this.localNetwork = bJciN2Network;
        this.n2Network = bJciN2Network;
        this.devname = string;
        this.devAddress = n;
    }

    public void setN2Device(BJciN2Device bJciN2Device) {
        this.n2Device = bJciN2Device;
    }

    public void setN2DeviceAddress(int n) {
        this.n2DeviceAddress = n;
    }

    public void setN2Network(BJciN2Network bJciN2Network) {
        this.n2Network = bJciN2Network;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sControllerType = "";
        this.controllerType = 0;
        this.hadAnError = false;
    }

    public BJciParseDmo() {
        this.this();
        this.importData = new ImportData();
    }

    static {
        Class clazz = class$com$jci$jciN2Parser$BJciParseDmo;
        if (clazz == null) {
            clazz = class$com$jci$jciN2Parser$BJciParseDmo = BJciParseDmo.class("[Lcom.jci.jciN2Parser.BJciParseDmo;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$jci$jciN2Parser$BJciParseDmo;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciN2Parser$BJciParseDmo = BJciParseDmo.class("[Lcom.jci.jciN2Parser.BJciParseDmo;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        sHeaderEntries = new String[]{"Version", "Source File for", "CSMODEL"};
        dmoTokenDelim = new String(",\"");
        POINT_TYPE_INDEX = 0;
        POINT_TAG_INDEX = 1;
        POINT_UNUSED1_INDEX = 2;
        POINT_LNAME_INDEX = 3;
        POINT_NAME_INDEX = 4;
        POINT_UNITS_INDEX = 5;
        POINT_UNITS2_INDEX = 6;
        LAST_POINT_INDEX = 6;
        HDR_VER_INDEX = 0;
        HDR_FILE_INDEX = 1;
        HDR_TYPE_INDEX = 2;
        HDR_MODEL_INDEX = 3;
        HDR_LAST_INDEX = 3;
        longNameIndication = "* LONGNAME";
        longNameDelim = "\"";
    }
}

