/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSysmonNx;

import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHardwareMonitorNxPlatformService
extends BPlatformService
implements BIAlarmablePlatformService {
    public static final Property sysmonPollRate = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.makeMinutes((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property cpuTemp = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property cpuTempHi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)60.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property cpuFanSpeed = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"revolutions per minute")));
    public static final Property cpuFanSpeedLo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)4000.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute"), (int)0, (int)10000));
    public static final Property sysFanSpeed = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"revolutions per minute")));
    public static final Property sysFanSpeedLo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)3000.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute"), (int)0, (int)10000));
    public static final Property voltVtt = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVttLo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)1.1f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)2));
    public static final Property voltVttHi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)1.3f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)2));
    public static final Property voltCpuCore = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltCpuCoreLo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)1.3f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)2));
    public static final Property voltCpuCoreHi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)1.6f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)2));
    public static final Property voltVcc3 = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVcc3Lo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)2.97f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)4));
    public static final Property voltVcc3Hi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)3.63f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)4));
    public static final Property voltVcc5 = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVcc5Lo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)4.5f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)6));
    public static final Property voltVcc5Hi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)5.5f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)6));
    public static final Property voltPos12 = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltPos12Lo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)9.6f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)15));
    public static final Property voltPos12Hi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)14.4f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)15));
    public static final Property voltNeg12 = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltNeg12Lo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)-9.6f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-15, (int)0));
    public static final Property voltNeg12Hi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)-14.4f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-15, (int)0));
    public static final Property voltVsb5 = BHardwareMonitorNxPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVsb5Lo = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)4, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)6));
    public static final Property voltVsb5Hi = BHardwareMonitorNxPlatformService.newProperty((int)0, (float)6.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)0, (int)6));
    public static final Property temperatureAlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initTemperatureAlarmSupport(), null);
    public static final Property temperatureAlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property cpuFanAlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initCpuFanAlarmSupport(), null);
    public static final Property cpuFanAlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property sysFanAlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initSysFanAlarmSupport(), null);
    public static final Property sysFanAlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVttAlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initVttVoltageAlarmSupport(), null);
    public static final Property voltageVttAlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageCpuCoreAlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initCpuCoreVoltageAlarmSupport(), null);
    public static final Property voltageCpuCoreAlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVcc3AlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initVcc3VoltageAlarmSupport(), null);
    public static final Property voltageVcc3AlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVcc5AlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initVcc5VoltageAlarmSupport(), null);
    public static final Property voltageVcc5AlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltagePos12AlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initPos12VoltageAlarmSupport(), null);
    public static final Property voltagePos12AlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageNeg12AlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initNeg12VoltageAlarmSupport(), null);
    public static final Property voltageNeg12AlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVsb5AlarmSupport = BHardwareMonitorNxPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxPlatformService.initVsb5VoltageAlarmSupport(), null);
    public static final Property voltageVsb5AlarmProxy = BHardwareMonitorNxPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action sysmonTimerExpired = BHardwareMonitorNxPlatformService.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final int LOAD_FAILED = 1;
    private static final String ALARM_TYPE_VOLTAGE_VTT = "vtt";
    private static final String ALARM_TYPE_VOLTAGE_CPU_CORE = "cpuCore";
    private static final String ALARM_TYPE_VOLTAGE_VCC3 = "vcc3";
    private static final String ALARM_TYPE_VOLTAGE_VCC5 = "vcc5";
    private static final String ALARM_TYPE_VOLTAGE_POS12 = "pos12";
    private static final String ALARM_TYPE_VOLTAGE_NEG12 = "neg12";
    private static final String ALARM_TYPE_VOLTAGE_VSB5 = "vsb5";
    private static final String ALARM_TYPE_CPU_FAN = "cpuFan";
    private static final String ALARM_TYPE_SYS_FAN = "sysFan";
    private static final String ALARM_TYPE_TEMPERATURE = "temperature";
    int handle;
    private Clock.Ticket sysmonTicket;
    private boolean firstTime;
    private boolean lastCpuTempOk;
    private boolean nowCpuTempOk;
    private boolean lastCpuFanSpdOk;
    private boolean nowCpuFanSpdOk;
    private boolean lastSysFanSpdOk;
    private boolean nowSysFanSpdOk;
    private float cpuTemperature;
    private float cpuFanSpd;
    private float sysFanSpd;
    private boolean[] lastVoltOk;
    private boolean[] nowVoltOk;
    private float[] newVoltages;
    private float[] oldVoltages;
    private String[] voltDesc;
    private String[] voltStatus;
    private float[] voltHiLimits;
    private float[] voltLoLimits;
    Vector alarmListeners;
    static /* synthetic */ Class class$com$tridium$platSysmonNx$BHardwareMonitorNxPlatformService;

    public BRelTime getSysmonPollRate() {
        return (BRelTime)this.get(sysmonPollRate);
    }

    public void setSysmonPollRate(BRelTime bRelTime) {
        this.set(sysmonPollRate, (BValue)bRelTime, null);
    }

    public float getCpuTemp() {
        return this.getFloat(cpuTemp);
    }

    public void setCpuTemp(float f) {
        this.setFloat(cpuTemp, f, null);
    }

    public float getCpuTempHi() {
        return this.getFloat(cpuTempHi);
    }

    public void setCpuTempHi(float f) {
        this.setFloat(cpuTempHi, f, null);
    }

    public float getCpuFanSpeed() {
        return this.getFloat(cpuFanSpeed);
    }

    public void setCpuFanSpeed(float f) {
        this.setFloat(cpuFanSpeed, f, null);
    }

    public float getCpuFanSpeedLo() {
        return this.getFloat(cpuFanSpeedLo);
    }

    public void setCpuFanSpeedLo(float f) {
        this.setFloat(cpuFanSpeedLo, f, null);
    }

    public float getSysFanSpeed() {
        return this.getFloat(sysFanSpeed);
    }

    public void setSysFanSpeed(float f) {
        this.setFloat(sysFanSpeed, f, null);
    }

    public float getSysFanSpeedLo() {
        return this.getFloat(sysFanSpeedLo);
    }

    public void setSysFanSpeedLo(float f) {
        this.setFloat(sysFanSpeedLo, f, null);
    }

    public float getVoltVtt() {
        return this.getFloat(voltVtt);
    }

    public void setVoltVtt(float f) {
        this.setFloat(voltVtt, f, null);
    }

    public float getVoltVttLo() {
        return this.getFloat(voltVttLo);
    }

    public void setVoltVttLo(float f) {
        this.setFloat(voltVttLo, f, null);
    }

    public float getVoltVttHi() {
        return this.getFloat(voltVttHi);
    }

    public void setVoltVttHi(float f) {
        this.setFloat(voltVttHi, f, null);
    }

    public float getVoltCpuCore() {
        return this.getFloat(voltCpuCore);
    }

    public void setVoltCpuCore(float f) {
        this.setFloat(voltCpuCore, f, null);
    }

    public float getVoltCpuCoreLo() {
        return this.getFloat(voltCpuCoreLo);
    }

    public void setVoltCpuCoreLo(float f) {
        this.setFloat(voltCpuCoreLo, f, null);
    }

    public float getVoltCpuCoreHi() {
        return this.getFloat(voltCpuCoreHi);
    }

    public void setVoltCpuCoreHi(float f) {
        this.setFloat(voltCpuCoreHi, f, null);
    }

    public float getVoltVcc3() {
        return this.getFloat(voltVcc3);
    }

    public void setVoltVcc3(float f) {
        this.setFloat(voltVcc3, f, null);
    }

    public float getVoltVcc3Lo() {
        return this.getFloat(voltVcc3Lo);
    }

    public void setVoltVcc3Lo(float f) {
        this.setFloat(voltVcc3Lo, f, null);
    }

    public float getVoltVcc3Hi() {
        return this.getFloat(voltVcc3Hi);
    }

    public void setVoltVcc3Hi(float f) {
        this.setFloat(voltVcc3Hi, f, null);
    }

    public float getVoltVcc5() {
        return this.getFloat(voltVcc5);
    }

    public void setVoltVcc5(float f) {
        this.setFloat(voltVcc5, f, null);
    }

    public float getVoltVcc5Lo() {
        return this.getFloat(voltVcc5Lo);
    }

    public void setVoltVcc5Lo(float f) {
        this.setFloat(voltVcc5Lo, f, null);
    }

    public float getVoltVcc5Hi() {
        return this.getFloat(voltVcc5Hi);
    }

    public void setVoltVcc5Hi(float f) {
        this.setFloat(voltVcc5Hi, f, null);
    }

    public float getVoltPos12() {
        return this.getFloat(voltPos12);
    }

    public void setVoltPos12(float f) {
        this.setFloat(voltPos12, f, null);
    }

    public float getVoltPos12Lo() {
        return this.getFloat(voltPos12Lo);
    }

    public void setVoltPos12Lo(float f) {
        this.setFloat(voltPos12Lo, f, null);
    }

    public float getVoltPos12Hi() {
        return this.getFloat(voltPos12Hi);
    }

    public void setVoltPos12Hi(float f) {
        this.setFloat(voltPos12Hi, f, null);
    }

    public float getVoltNeg12() {
        return this.getFloat(voltNeg12);
    }

    public void setVoltNeg12(float f) {
        this.setFloat(voltNeg12, f, null);
    }

    public float getVoltNeg12Lo() {
        return this.getFloat(voltNeg12Lo);
    }

    public void setVoltNeg12Lo(float f) {
        this.setFloat(voltNeg12Lo, f, null);
    }

    public float getVoltNeg12Hi() {
        return this.getFloat(voltNeg12Hi);
    }

    public void setVoltNeg12Hi(float f) {
        this.setFloat(voltNeg12Hi, f, null);
    }

    public float getVoltVsb5() {
        return this.getFloat(voltVsb5);
    }

    public void setVoltVsb5(float f) {
        this.setFloat(voltVsb5, f, null);
    }

    public float getVoltVsb5Lo() {
        return this.getFloat(voltVsb5Lo);
    }

    public void setVoltVsb5Lo(float f) {
        this.setFloat(voltVsb5Lo, f, null);
    }

    public float getVoltVsb5Hi() {
        return this.getFloat(voltVsb5Hi);
    }

    public void setVoltVsb5Hi(float f) {
        this.setFloat(voltVsb5Hi, f, null);
    }

    public BPlatformAlarmSupport getTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(temperatureAlarmSupport);
    }

    public void setTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(temperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(temperatureAlarmProxy);
    }

    public void setTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(temperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getCpuFanAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(cpuFanAlarmSupport);
    }

    public void setCpuFanAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(cpuFanAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getCpuFanAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(cpuFanAlarmProxy);
    }

    public void setCpuFanAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(cpuFanAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getSysFanAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(sysFanAlarmSupport);
    }

    public void setSysFanAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(sysFanAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getSysFanAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(sysFanAlarmProxy);
    }

    public void setSysFanAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(sysFanAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVttAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVttAlarmSupport);
    }

    public void setVoltageVttAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVttAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVttAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVttAlarmProxy);
    }

    public void setVoltageVttAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVttAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageCpuCoreAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageCpuCoreAlarmSupport);
    }

    public void setVoltageCpuCoreAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageCpuCoreAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageCpuCoreAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageCpuCoreAlarmProxy);
    }

    public void setVoltageCpuCoreAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageCpuCoreAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVcc3AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVcc3AlarmSupport);
    }

    public void setVoltageVcc3AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVcc3AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVcc3AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVcc3AlarmProxy);
    }

    public void setVoltageVcc3AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVcc3AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVcc5AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVcc5AlarmSupport);
    }

    public void setVoltageVcc5AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVcc5AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVcc5AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVcc5AlarmProxy);
    }

    public void setVoltageVcc5AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVcc5AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltagePos12AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltagePos12AlarmSupport);
    }

    public void setVoltagePos12AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltagePos12AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltagePos12AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltagePos12AlarmProxy);
    }

    public void setVoltagePos12AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltagePos12AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageNeg12AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageNeg12AlarmSupport);
    }

    public void setVoltageNeg12AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageNeg12AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageNeg12AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageNeg12AlarmProxy);
    }

    public void setVoltageNeg12AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageNeg12AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVsb5AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVsb5AlarmSupport);
    }

    public void setVoltageVsb5AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVsb5AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVsb5AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVsb5AlarmProxy);
    }

    public void setVoltageVsb5AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVsb5AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void sysmonTimerExpired() {
        this.invoke(sysmonTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        this.handle = this.open();
        this.loadLibraries();
        if (this.driverOpenCode() == 1) {
            log.trace("ERROR: sysmon Load Failed -- Unable to load WinNT kernel driver required to access JaceNP hardware.");
            return;
        }
        if (this.sysmonTicket != null) {
            this.sysmonTicket.cancel();
        }
        this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)sysmonTimerExpired, null);
        this.getVoltageVttAlarmProxy().setAlarmSupport(this.getVoltageVttAlarmSupport());
        this.getVoltageCpuCoreAlarmProxy().setAlarmSupport(this.getVoltageCpuCoreAlarmSupport());
        this.getVoltageVcc3AlarmProxy().setAlarmSupport(this.getVoltageVcc3AlarmSupport());
        this.getVoltageVcc5AlarmProxy().setAlarmSupport(this.getVoltageVcc5AlarmSupport());
        this.getVoltagePos12AlarmProxy().setAlarmSupport(this.getVoltagePos12AlarmSupport());
        this.getVoltageNeg12AlarmProxy().setAlarmSupport(this.getVoltageNeg12AlarmSupport());
        this.getVoltageVsb5AlarmProxy().setAlarmSupport(this.getVoltageVsb5AlarmSupport());
        this.getCpuFanAlarmProxy().setAlarmSupport(this.getCpuFanAlarmSupport());
        this.getSysFanAlarmProxy().setAlarmSupport(this.getSysFanAlarmSupport());
        this.getTemperatureAlarmProxy().setAlarmSupport(this.getTemperatureAlarmSupport());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == sysmonPollRate) {
            if (this.sysmonTicket != null) {
                this.sysmonTicket.cancel();
            }
            this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)sysmonTimerExpired, null);
        }
    }

    public void doSysmonTimerExpired() {
        try {
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord;
            log.trace("sysmon reading system measurements...");
            this.cpuTemperature = this.getCpuTemperature();
            log.trace("mainBoardTemp --> " + this.cpuTemperature);
            boolean bl = false;
            if (this.cpuTemperature < this.getCpuTempHi()) {
                bl = true;
            }
            this.nowCpuTempOk = bl;
            boolean bl2 = false;
            if (this.getCpuTemp() < this.getCpuTempHi()) {
                bl2 = true;
            }
            this.lastCpuTempOk = bl2;
            this.setCpuTemp(this.cpuTemperature);
            this.cpuFanSpd = this.getCpuFanSpd();
            log.trace("cpuFanSpeed --> " + this.cpuFanSpd);
            boolean bl3 = false;
            if (this.cpuFanSpd < this.getCpuFanSpeedLo()) {
                bl3 = true;
            }
            this.nowCpuFanSpdOk = bl3 ^ true;
            boolean bl4 = false;
            if (this.getCpuFanSpeed() < this.getCpuFanSpeedLo()) {
                bl4 = true;
            }
            this.lastCpuFanSpdOk = bl4 ^ true;
            this.setCpuFanSpeed(this.cpuFanSpd);
            this.sysFanSpd = this.getSysFanSpd();
            log.trace("sysFanSpeed --> " + this.sysFanSpd);
            boolean bl5 = false;
            if (this.sysFanSpd < this.getSysFanSpeedLo()) {
                bl5 = true;
            }
            this.nowSysFanSpdOk = bl5 ^ true;
            boolean bl6 = false;
            if (this.getSysFanSpeed() < this.getSysFanSpeedLo()) {
                bl6 = true;
            }
            this.lastSysFanSpdOk = bl6 ^ true;
            this.setSysFanSpeed(this.sysFanSpd);
            if (this.nowCpuTempOk != this.lastCpuTempOk) {
                this.firstTime = false;
                if (this.nowCpuTempOk) {
                    log.trace("mainBoardTempRange  --> PASSED");
                    bPlatformServiceAlarmRecord = this.getTemperatureAlarmSupport().makeToNormal();
                    this.getTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("mainBoardTempRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowCpuFanSpdOk != this.lastCpuFanSpdOk) {
                if (this.nowCpuFanSpdOk) {
                    log.trace("CpuFanSpdRange --> PASSED");
                    bPlatformServiceAlarmRecord = this.getCpuFanAlarmSupport().makeToNormal();
                    this.getCpuFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("CpuFanSpdRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getCpuFanAlarmSupport().makeNewFaultAlarm();
                    this.getCpuFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowSysFanSpdOk != this.lastSysFanSpdOk) {
                if (this.nowSysFanSpdOk) {
                    log.trace("SysFanSpdRange --> PASSED");
                    bPlatformServiceAlarmRecord = this.getSysFanAlarmSupport().makeToNormal();
                    this.getSysFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("SysFanSpdRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getSysFanAlarmSupport().makeNewFaultAlarm();
                    this.getSysFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            this.newVoltages[0] = this.getVoltage(0);
            this.newVoltages[1] = this.getVoltage(1);
            this.newVoltages[2] = this.getVoltage(2);
            this.newVoltages[3] = this.getVoltage(3);
            this.newVoltages[4] = this.getVoltage(4);
            this.newVoltages[5] = this.getVoltage(5);
            this.newVoltages[6] = 0.0f;
            this.newVoltages[7] = this.getVoltage(7);
            this.oldVoltages[0] = this.getVoltVtt();
            this.oldVoltages[1] = this.getVoltCpuCore();
            this.oldVoltages[2] = this.getVoltVcc3();
            this.oldVoltages[3] = this.getVoltVcc5();
            this.oldVoltages[4] = this.getVoltPos12();
            this.oldVoltages[5] = this.getVoltNeg12();
            this.oldVoltages[6] = 0.0f;
            this.oldVoltages[7] = this.getVoltVsb5();
            this.setVoltVtt(this.newVoltages[0]);
            this.setVoltCpuCore(this.newVoltages[1]);
            this.setVoltVcc3(this.newVoltages[2]);
            this.setVoltVcc5(this.newVoltages[3]);
            this.setVoltPos12(this.newVoltages[4]);
            this.setVoltNeg12(this.newVoltages[5]);
            this.setVoltVsb5(this.newVoltages[7]);
            this.getVoltStat();
            int n = 0;
            while (n < 8) {
                log.trace(this.voltStatus[n]);
                if (this.nowVoltOk[n] != this.lastVoltOk[n]) {
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord2;
                    if (this.nowVoltOk[n]) {
                        log.trace(this.voltDesc[n] + " = " + this.newVoltages[n] + " OK");
                        switch (n) {
                            case 0: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVttAlarmSupport().makeToNormal();
                                this.getVoltageVttAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 1: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageCpuCoreAlarmSupport().makeToNormal();
                                this.getVoltageCpuCoreAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 2: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVcc3AlarmSupport().makeToNormal();
                                this.getVoltageVcc3AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 3: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVcc5AlarmSupport().makeToNormal();
                                this.getVoltageVcc5AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 4: {
                                bPlatformServiceAlarmRecord2 = this.getVoltagePos12AlarmSupport().makeToNormal();
                                this.getVoltagePos12AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 5: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageNeg12AlarmSupport().makeToNormal();
                                this.getVoltageNeg12AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 7: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVsb5AlarmSupport().makeToNormal();
                                this.getVoltageVsb5AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                        }
                    } else {
                        log.trace(this.voltDesc[n] + " = " + this.newVoltages[n] + " FAILED");
                        switch (n) {
                            case 0: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVttAlarmSupport().makeNewFaultAlarm();
                                this.getVoltageVttAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 1: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageCpuCoreAlarmSupport().makeNewFaultAlarm();
                                this.getVoltageCpuCoreAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 2: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVcc3AlarmSupport().makeNewFaultAlarm();
                                this.getVoltageVcc3AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 3: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVcc5AlarmSupport().makeNewFaultAlarm();
                                this.getVoltageVcc5AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 4: {
                                bPlatformServiceAlarmRecord2 = this.getVoltagePos12AlarmSupport().makeNewFaultAlarm();
                                this.getVoltagePos12AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 5: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageNeg12AlarmSupport().makeNewFaultAlarm();
                                this.getVoltageNeg12AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 7: {
                                bPlatformServiceAlarmRecord2 = this.getVoltageVsb5AlarmSupport().makeNewFaultAlarm();
                                this.getVoltageVsb5AlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                                break;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    private final void getVoltStat() {
        try {
            this.voltHiLimits[0] = this.getVoltVttHi();
            this.voltHiLimits[1] = this.getVoltCpuCoreHi();
            this.voltHiLimits[2] = this.getVoltVcc3Hi();
            this.voltHiLimits[3] = this.getVoltVcc5Hi();
            this.voltHiLimits[4] = this.getVoltPos12Hi();
            this.voltHiLimits[5] = this.getVoltNeg12Hi();
            this.voltHiLimits[6] = 1000.0f;
            this.voltHiLimits[7] = this.getVoltVsb5Hi();
            this.voltLoLimits[0] = this.getVoltVttLo();
            this.voltLoLimits[1] = this.getVoltCpuCoreLo();
            this.voltLoLimits[2] = this.getVoltVcc3Lo();
            this.voltLoLimits[3] = this.getVoltVcc5Lo();
            this.voltLoLimits[4] = this.getVoltPos12Lo();
            this.voltLoLimits[5] = this.getVoltNeg12Lo();
            this.voltLoLimits[6] = -1000.0f;
            this.voltLoLimits[7] = this.getVoltVsb5Lo();
        }
        catch (Exception exception) {}
        if (log.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 8) {
                stringBuffer.append("  " + n + ": " + this.newVoltages[n] + '[' + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + "]\n");
                ++n;
            }
            log.trace(stringBuffer.toString());
        }
        int n = 0;
        while (n < 8) {
            if (this.voltHiLimits[n] < this.voltLoLimits[n]) {
                float f = this.voltHiLimits[n];
                this.voltHiLimits[n] = this.voltLoLimits[n];
                this.voltLoLimits[n] = f;
            }
            if (this.newVoltages[n] > this.voltHiLimits[n] || this.newVoltages[n] < this.voltLoLimits[n]) {
                this.nowVoltOk[n] = false;
                this.voltStatus[n] = "Voltage " + this.voltDesc[n] + " = " + this.newVoltages[n] + " is out of range [" + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + ']';
            } else {
                this.nowVoltOk[n] = true;
                this.voltStatus[n] = "Voltage " + this.voltDesc[n] + " = " + this.newVoltages[n] + " is in range [" + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + ']';
            }
            this.lastVoltOk[n] = !(this.oldVoltages[n] > this.voltHiLimits[n]) && !(this.oldVoltages[n] < this.voltLoLimits[n]);
            ++n;
        }
    }

    private final String allVoltsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("1:" + this.newVoltages[0] + '\n');
        stringBuffer.append("2:" + this.newVoltages[1] + '\n');
        stringBuffer.append("3:" + this.newVoltages[2] + '\n');
        stringBuffer.append("4:" + this.newVoltages[3] + '\n');
        stringBuffer.append("5:" + this.newVoltages[4] + '\n');
        stringBuffer.append("6:" + this.newVoltages[5] + '\n');
        stringBuffer.append("7:" + this.newVoltages[6] + '\n');
        stringBuffer.append("8:" + this.newVoltages[7] + '\n');
        return stringBuffer.toString();
    }

    protected abstract void loadLibraries();

    public abstract int open();

    public abstract void close();

    public abstract int driverOpenCode();

    public abstract int getCpuTemperature();

    public abstract float getFanSpd(int var1);

    public float getCpuFanSpd() {
        return this.getFanSpd(0);
    }

    public float getSysFanSpd() {
        return this.getFanSpd(1);
    }

    public abstract float getVoltage(int var1);

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getVoltageVttAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageCpuCoreAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc3AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc5AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltagePos12AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageNeg12AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVsb5AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getCpuFanAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSysFanAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getVoltageVttAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageCpuCoreAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc3AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc5AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltagePos12AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageNeg12AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVsb5AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getCpuFanAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSysFanAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initVttVoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVttFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVttPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VTT));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initCpuCoreVoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageCpuCoreFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageCpuCorePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_CPU_CORE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initVcc3VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVcc3Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVcc3Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VCC3));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initVcc5VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVcc5Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVcc5Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VCC5));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPos12VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltagePos12Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltagePos12Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_POS12));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initNeg12VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageNeg12Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageNeg12Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_NEG12));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initVsb5VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVsb5Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:voltageVsb5Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VSB5));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initCpuFanAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:cpuFanFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:cpuFanPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_CPU_FAN));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initSysFanAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:sysFanFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:sysFanPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_SYS_FAN));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNx:temperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNx:temperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.firstTime = true;
        this.lastVoltOk = new boolean[8];
        this.nowVoltOk = new boolean[8];
        this.newVoltages = new float[8];
        this.oldVoltages = new float[8];
        this.voltDesc = new String[]{ALARM_TYPE_VOLTAGE_VTT, ALARM_TYPE_VOLTAGE_CPU_CORE, ALARM_TYPE_VOLTAGE_VCC3, "vcc", ALARM_TYPE_VOLTAGE_POS12, ALARM_TYPE_VOLTAGE_NEG12, "unused", ALARM_TYPE_VOLTAGE_VSB5};
        this.voltStatus = new String[]{"ok", "ok", "ok", "ok", "ok", "ok", "ok", "ok"};
        this.voltHiLimits = new float[8];
        this.voltLoLimits = new float[8];
        this.alarmListeners = new Vector(1);
    }

    public BHardwareMonitorNxPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("HardwareMonitorNxPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platSysmonNx$BHardwareMonitorNxPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platSysmonNx$BHardwareMonitorNxPlatformService = BHardwareMonitorNxPlatformService.class("[Lcom.tridium.platSysmonNx.BHardwareMonitorNxPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = Log.getLog((String)"sysmon");
    }
}

