/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusSlave.BModbusSlaveNetwork;
import com.tridium.modbusSlave.comm.UnsolicitedMessageElement;
import java.io.ByteArrayOutputStream;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Clock;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusSlaveRxDriver
extends CommReceiver {
    protected static String RTU_PARTIAL_MESSAGE = "RTU partial message received ";
    protected static String ASCII_PARTIAL_MESSAGE = "ASCII partial message received ";
    private Log rxLog;
    private BModbusSlaveNetwork network;
    private int responseSize;
    private int rcvCount;
    private int functionCode;
    private boolean done;
    private ByteArrayOutputStream rcv;
    long rxCharTicks;
    private boolean waitForExTimeout;

    public void setAlive(boolean bl) {
        this.done = bl ^ true;
    }

    public boolean isAlive() {
        return this.done ^ true;
    }

    public void run() {
        while (!this.done) {
            boolean bl = false;
            try {
                int n = this.getInputStream().read();
                if (n == -1) {
                    long l = Clock.ticks();
                    long l2 = l - this.rxCharTicks;
                    long l3 = 50L;
                    if (this.waitForExTimeout) {
                        this.rxLog.trace("rxCharTimeout: clearing flag");
                    }
                    this.waitForExTimeout = false;
                    String string = RTU_PARTIAL_MESSAGE;
                    if (this.isAsciiProtocol()) {
                        l3 = 1000L;
                        string = ASCII_PARTIAL_MESSAGE;
                    }
                    if (this.rcvCount > 0 && l2 > l3) {
                        this.rxLog.message(string + ByteArrayUtil.toHexString((byte[])this.rcv.toByteArray()));
                        if (this.rxCharTicks > 0L) {
                            this.rxLog.message(" character deltaT = " + l2);
                        }
                        this.rxCharTicks = l;
                        bl = false;
                        this.rcvCount = 0;
                        this.responseSize = 10;
                    }
                } else {
                    this.rxCharTicks = Clock.ticks();
                    bl = true;
                    byte by = (byte)(n & 0xFF);
                }
                if (!bl) continue;
                this.rxLog.trace("Received char: 0x" + Integer.toHexString(n));
                if (this.network.getModbusMode() == 0) {
                    this.processASCIICharacter(n);
                    continue;
                }
                this.processRTUCharacter(n);
            }
            catch (Exception exception) {
                if (!this.isAlive()) continue;
                this.network.getModbusLog().error("Exception in ModbusSlaveRxDriver", (Throwable)exception);
            }
        }
        this.getComm().receiveFinal();
    }

    private final void processRTUCharacter(int n) {
        if (this.waitForExTimeout) {
            this.logTrace("    ignoring character: 0x" + Integer.toHexString(n));
            this.rcvCount = 0;
            return;
        }
        byte by = (byte)(n & 0xFF);
        if (this.rcvCount == 0) {
            this.rcv.reset();
        }
        this.rcv.write(by);
        if (this.rcvCount == 0) {
            this.logTrace("finding device: " + (n & 0xFF));
            if (this.network.findModbusDevice(n & 0xFF) == null) {
                this.logTrace("address not for me, waitForRxTimeout: " + (n & 0xFF));
                this.waitForExTimeout = true;
                this.responseSize = 10;
                return;
            }
        }
        if (this.rcvCount == 1) {
            if (n > 127) {
                this.responseSize = 4;
            } else {
                this.functionCode = n;
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.responseSize = 7;
                        break;
                    }
                }
            }
        } else if ((this.functionCode == 15 || this.functionCode == 16) && this.rcvCount == 6) {
            this.responseSize = n + 3;
        } else if ((this.functionCode == 20 || this.functionCode == 21) && this.rcvCount == 2) {
            this.responseSize = n + 3;
        }
        ++this.rcvCount;
        --this.responseSize;
        this.rxLog.trace("rc= " + this.rcvCount + " rs= " + this.responseSize);
        if (this.responseSize == 0) {
            this.messageComplete();
        }
    }

    private final void processASCIICharacter(int n) {
        byte by = (byte)(n & 0xFF);
        if (n == 58) {
            this.rcv.reset();
        }
        this.rcv.write(by);
        ++this.rcvCount;
        if (n == 10) {
            this.messageComplete();
        }
    }

    protected void messageComplete() {
        Object object;
        byte[] byArray = this.rcv.toByteArray();
        boolean bl = true;
        if (this.network.getModbusMode() == 0) {
            object = ModbusInputStream.convertAscii2Rtu((byte[])byArray);
            if (!ModbusMessage.verifyLRC((byte[])object)) {
                this.network.incrementLrcErrors();
                this.network.getModbusLog().message("modbusSlave: received message had LRC error: " + new String(byArray));
                bl = false;
            }
        } else {
            boolean bl2 = false;
            try {
                bl2 = ModbusMessage.verifyCRC((byte[])byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!bl2) {
                this.network.incrementCrcErrors();
                if (this.network.getModbusLog().isLoggable(1)) {
                    this.network.getModbusLog().message("modbusSlave: received message had CRC error: ");
                    ByteArrayUtil.hexDump((byte[])byArray);
                }
                bl = false;
            }
        }
        this.network.incrementReceived();
        if (bl) {
            if (this.network.getModbusMode() == 0) {
                this.logTrace(" Received ascii [" + new String(byArray, 0, byArray.length - 2) + ']');
            } else {
                this.logTrace(" Received rtu [" + ByteArrayUtil.toHexString((byte[])byArray) + ']');
            }
            if (!this.network.getSnifferMode()) {
                object = new UnsolicitedMessageElement(byArray);
                this.network.unsolicitedReceive().receiveMessage((UnsolicitedMessageElement)object);
            }
        }
        this.rcv.reset();
        this.rcvCount = 0;
        this.responseSize = 10;
    }

    protected ReceivedMessage receive() throws Exception {
        return null;
    }

    private final void logTrace(String string) {
        if (this.network.getModbusLog().isTraceOn()) {
            this.network.getModbusLog().trace(string);
        } else if (this.rxLog.isTraceOn()) {
            this.rxLog.trace(string);
        }
    }

    protected boolean isAsciiProtocol() {
        boolean bl = false;
        if (this.network.getModbusMode() == 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.functionCode = 0;
        this.done = false;
        this.rxCharTicks = 0L;
        this.waitForExTimeout = false;
    }

    public ModbusSlaveRxDriver(BModbusSlaveNetwork bModbusSlaveNetwork) {
        String string;
        this.this();
        this.rcv = new ByteArrayOutputStream();
        this.network = bModbusSlaveNetwork;
        if (bModbusSlaveNetwork == null) {
            this.rxLog = Log.getLog((String)"modbusAsync.rx");
        }
        if (!SlotPath.isValidName((String)(string = bModbusSlaveNetwork.getName() + '_' + bModbusSlaveNetwork.getSerialPortConfig().getPortName() + "_rx"))) {
            string = SlotPath.escape((String)string);
        }
        this.rxLog = Log.getLog((String)string);
    }
}

