/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.modbusCore.enums.BModbusDataModeEnum;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusSlave.BModbusSlaveDevice;
import com.tridium.modbusSlave.BModbusSlaveDeviceFolder;
import com.tridium.modbusSlave.comm.ModbusSlaveSerialComm;
import com.tridium.modbusSlave.comm.ModbusUnsolicitedReceive;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusSlaveNetwork
extends BModbusServerNetwork
implements BISerialHelperParent {
    public static final Property serialPortConfig = BModbusSlaveNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property modbusDataMode = BModbusSlaveNetwork.newProperty((int)0, (BValue)BModbusDataModeEnum.rtu, null);
    public static final Property snifferMode = BModbusSlaveNetwork.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private Log log;
    private ModbusUnsolicitedReceive unsolicitedReceive;
    static /* synthetic */ Class class$com$tridium$modbusSlave$BModbusSlaveNetwork;

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public BModbusDataModeEnum getModbusDataMode() {
        return (BModbusDataModeEnum)this.get(modbusDataMode);
    }

    public void setModbusDataMode(BModbusDataModeEnum bModbusDataModeEnum) {
        this.set(modbusDataMode, (BValue)bModbusDataModeEnum, null);
    }

    public boolean getSnifferMode() {
        return this.getBoolean(snifferMode);
    }

    public void setSnifferMode(boolean bl) {
        this.setBoolean(snifferMode, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BModbusSlaveDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BModbusSlaveDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "modbusSlave");
    }

    public int getModbusMode() {
        return this.getModbusDataMode().getOrdinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getNameSubscriber().subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log = this.log;
        synchronized (log) {
            this.log = this.getLog();
            return;
        }
    }

    public void startComm() throws Exception {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            this.configFail("No port selected for Modbus communication.");
        } else {
            try {
                super.startComm();
            }
            catch (Exception exception) {
                this.configFail("Could not enable Modbus serial communication (" + exception + ')');
                throw exception;
            }
            this.configOk();
        }
    }

    public Log getLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        return Log.getLog((String)string);
    }

    protected Comm makeComm() {
        return new ModbusSlaveSerialComm(this);
    }

    protected void initComm(Comm comm) {
        this.unsolicitedReceive = new ModbusUnsolicitedReceive(this);
        this.unsolicitedReceive.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        Log log = Log.getLog((String)string);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log2 = this.log;
        synchronized (log2) {
            if (this.log != null) {
                log.setSeverity(this.log.getSeverity());
                if (!log.getLogName().equals(this.log.getLogName())) {
                    Log.deleteLog((String)this.log.getLogName());
                }
            }
            this.log = log;
        }
        super.updateLog();
    }

    public void reopenPort() {
        try {
            String string = this.getSerialPortConfig().getPortName();
            if (string.equals("none")) {
                this.configFail("No port selected for Modbus communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception exception) {
            this.getLog().error("BModbusSlaveNetwork caught exception in reopenPort(): ", (Throwable)exception);
        }
    }

    private final void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log.isTraceOn()) {
                this.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.startHelpers();
        if (!this.getComm().isCommStarted()) {
            this.getModbusLog().warning("Unable to start Serial Comm for " + this.getName());
            this.stopHelpers();
            return false;
        }
        try {
            ((ModbusSlaveSerialComm)this.getComm()).getSerialPort().enableReceiveThreshold(1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.getModbusLog().error(this.getName() + ", ModbusSlaveSerialComm: Unable to perform enableReceiveThreshold = 1.  Exception- ", (Throwable)unsupportedOperationException);
        }
        this.networkInitialized = true;
        return true;
    }

    protected void startHelpers() {
        super.startHelpers();
        this.unsolicitedReceive.start();
    }

    protected void stopHelpers() {
        super.stopHelpers();
        this.unsolicitedReceive.stop();
    }

    public ModbusUnsolicitedReceive unsolicitedReceive() {
        return this.unsolicitedReceive;
    }

    protected void processNameSubscriberEvent(BComponentEvent bComponentEvent) {
        super.processNameSubscriberEvent(bComponentEvent);
        try {
            if (bComponentEvent.getId() == 0 && bComponentEvent.getSlot().equals((Object)BSerialHelper.portName)) {
                this.updateLog();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BModbusSlaveDevice findModbusDevice(int n) {
        BDevice[] bDeviceArray = this.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2] != null && bDeviceArray[n2] instanceof BModbusSlaveDevice && ((BModbusSlaveDevice)bDeviceArray[n2]).getDeviceAddress() == n) {
                return (BModbusSlaveDevice)bDeviceArray[n2];
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = null;
        this.unsolicitedReceive = null;
    }

    public BModbusSlaveNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusSlave$BModbusSlaveNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$modbusSlave$BModbusSlaveNetwork = BModbusSlaveNetwork.class("[Lcom.tridium.modbusSlave.BModbusSlaveNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

