/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platLon;

import com.tridium.platLon.BLonPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonPlatformServiceNpsdk
extends BLonPlatformService {
    public static final Type TYPE;
    private static final int MAX_HANDLE = 3;
    private static int nextHandle;
    private FileInputStream[] in;
    private FileOutputStream[] out;
    private String[] devNames;
    private boolean usesFileIo;
    private boolean loaded;
    static /* synthetic */ Class class$com$tridium$platLon$BLonPlatformServiceNpsdk;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        File file = new File(Sys.getBajaHome() + File.separator + "bin" + File.separator + "liblon-npsdk.so");
        return file.exists();
    }

    public int driverInit(String string) throws Exception {
        if (!this.loadLibraries()) {
            log.error("Could not load lonworks natives");
            throw new Exception("Could not load lonworks natives");
        }
        String string2 = this.getDeviceFilePath0();
        if (string2 == null) {
            log.trace("getDeviceFilePath0 returned null");
            this.usesFileIo = false;
            int n = this.driverInitForNativeIO(string);
            return n;
        }
        log.trace("getDeviceFilePath0 returned" + string2);
        File file = new File(string2 + File.separator + string);
        if (file.exists()) {
            log.trace("found lon device file at " + string2 + File.separator + string);
            return this.driverInitForFileIO(string);
        }
        log.trace("could not fine lon device file at " + string2 + File.separator + string);
        throw new Exception("Cannot open lon driver " + file);
    }

    protected int driverInitForFileIO(String string) throws Exception {
        int n = -1;
        int n2 = 0;
        while (n2 < this.devNames.length) {
            if (this.devNames[n2] == null || this.devNames[n2].length() == 0) {
                n = n2;
                this.devNames[n2] = string;
                break;
            }
            if (this.devNames[n2].equals(string)) {
                return n2;
            }
            ++n2;
        }
        if (n == -1) {
            throw new BajaException("All available lon ports in use.");
        }
        String string2 = this.getDeviceFilePath0();
        File file = new File(string2 + File.separator + string);
        this.in[n] = new FileInputStream(file);
        this.out[n] = new FileOutputStream(file);
        return n;
    }

    protected int driverInitForNativeIO(String string) throws Exception {
        if (!this.loadLibraries()) {
            throw new Exception("Could not load lonworks natives");
        }
        log.trace("driverInitForNativeIO:" + string);
        int n = this.ldvOpen0(string);
        if (n == -1) {
            log.error("could not open " + string);
            throw new Exception("Unable to open lonworks device " + string);
        }
        log.trace("driverInitForNativeIO:handle=" + n);
        return n;
    }

    protected boolean loadLibraries() {
        if (this.loaded) {
            return true;
        }
        try {
            System.loadLibrary("lon-npsdk");
            this.loaded = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.loaded;
    }

    public void write(int n, byte[] byArray, int n2) throws Exception {
        if (log.isTraceOn()) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("BLonPlatformServiceNpsdk.write: handle=" + n).append(" usesFileIo=").append(this.usesFileIo).append(" msgLen=" + n2).append("\n" + TextUtil.bytesToHexString((byte[])byArray2));
            log.trace(stringBuffer.toString());
        }
        if (this.usesFileIo) {
            this.out[n].write(byArray, 0, n2);
        } else {
            this.ldvWrite0(n, byArray, n2);
        }
    }

    public boolean read(int n, byte[] byArray) throws Exception {
        int n2;
        if (this.usesFileIo ? (n2 = this.in[n].read(byArray)) == -1 : (n2 = this.ldvRead0(n, byArray)) == -1 || n2 == 0) {
            return false;
        }
        if (log.isTraceOn()) {
            n2 = byArray[1] + 2;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("BLonPlatformServiceNpsdk.read: handle=" + n).append(" usesFileIo=").append(this.usesFileIo).append(" msgLen=" + n2).append("\n" + TextUtil.bytesToHexString((byte[])byArray2));
            log.trace(stringBuffer.toString());
        }
        return true;
    }

    private final native String getDeviceFilePath0();

    private final native int ldvOpen0(String var1);

    private final native int ldvRead0(int var1, byte[] var2) throws Exception;

    private final native void ldvWrite0(int var1, byte[] var2, int var3) throws Exception;

    private final native void ldvClose0(int var1) throws Exception;

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.in = new FileInputStream[4];
        this.out = new FileOutputStream[4];
        this.devNames = new String[4];
        this.usesFileIo = true;
        this.loaded = false;
    }

    public BLonPlatformServiceNpsdk() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platLon$BLonPlatformServiceNpsdk;
        if (clazz == null) {
            clazz = class$com$tridium$platLon$BLonPlatformServiceNpsdk = BLonPlatformServiceNpsdk.class("[Lcom.tridium.platLon.BLonPlatformServiceNpsdk;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nextHandle = 0;
    }
}

