/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless.point;

import com.tridium.basicdriver.util.BasicException;
import com.viconics.wireless.BWirelessStatDevice;
import com.viconics.wireless.BWirelessStatNetwork;
import com.viconics.wireless.XWirelessStatFile;
import com.viconics.wireless.comm.BWirelessStatReplyParser;
import com.viconics.wireless.point.BWirelessStatBooleanProxyExt;
import com.viconics.wireless.point.BWirelessStatEnumProxyExt;
import com.viconics.wireless.point.BWirelessStatNumericProxyExt;
import com.viconics.wireless.point.BWirelessStatNumericSensorProxyExt;
import com.viconics.wireless.point.BWirelessStatPointFolder;
import com.viconics.wireless.point.BWirelessStatProxyExt;
import com.viconics.wireless.point.enums.BAlarmFcuEnum;
import com.viconics.wireless.point.enums.BAlarmHeatPumpRoofTopEnum;
import com.viconics.wireless.point.enums.BCoolingValvesEnum;
import com.viconics.wireless.point.enums.BEffectiveOccupancyEnum;
import com.viconics.wireless.point.enums.BFanModeFcuEnum;
import com.viconics.wireless.point.enums.BFanModeHeatPumpRoofTopEnum;
import com.viconics.wireless.point.enums.BFanStatusEnum;
import com.viconics.wireless.point.enums.BHeatingValvesEnum;
import com.viconics.wireless.point.enums.BKeypadLookoutEnum;
import com.viconics.wireless.point.enums.BKeypadLookoutFcuEnum;
import com.viconics.wireless.point.enums.BOccupancyCommandEnum;
import com.viconics.wireless.point.enums.BSequenceOfOperationEnum;
import com.viconics.wireless.point.enums.BSystemModeEnum;
import com.viconics.wireless.point.enums.BSystemModeHPEnum;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWirelessStatPointDeviceExt
extends BPointDeviceExt {
    public static final Action deleteAllPoints = BWirelessStatPointDeviceExt.newAction((int)4, null);
    public static final Action addAllPoints = BWirelessStatPointDeviceExt.newAction((int)4, null);
    public static final Type TYPE;
    public static final Context deletePoints;
    public static final Context addPoints;
    private Lexicon lex;
    static /* synthetic */ Class class$com$viconics$wireless$point$BWirelessStatPointDeviceExt;
    static /* synthetic */ Class class$com$viconics$wireless$BWirelessStatDevice;

    public void deleteAllPoints() {
        this.invoke(deleteAllPoints, null, null);
    }

    public void addAllPoints() {
        this.invoke(addAllPoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BWirelessStatNetwork getWirelessStatNetwork() {
        return (BWirelessStatNetwork)this.getNetwork();
    }

    public final BWirelessStatDevice getWirelessStatDevice() {
        return (BWirelessStatDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BWirelessStatDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BWirelessStatPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BWirelessStatProxyExt.TYPE;
    }

    public void removeAllPoints() {
        this.removeAll(deletePoints);
    }

    public void checkRename(Property property, String string, Context context) {
        throw new LocalizableRuntimeException(this.lex.module.getModuleName(), "pointDeviceExt.rename");
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (context == Context.copying) {
            return;
        }
        if (context == addPoints) {
            return;
        }
        if (context == Context.commit) {
            return;
        }
        System.out.println("The context is" + context);
        throw new LocalizableRuntimeException(this.lex.module.getModuleName(), "pointDeviceExt.add");
    }

    public void checkRemove(Property property, Context context) {
        if (!(this.get(property) instanceof BControlPoint)) {
            return;
        }
        BControlPoint bControlPoint = (BControlPoint)this.get(property);
        BAbstractProxyExt bAbstractProxyExt = bControlPoint.getProxyExt();
        if (bAbstractProxyExt == null) {
            return;
        }
        if (!(bAbstractProxyExt instanceof BWirelessStatProxyExt)) {
            return;
        }
        if (context == deletePoints) {
            return;
        }
        if (context.getFacet("niagaraAutoStart") != null) {
            return;
        }
        if (context == Context.commit) {
            return;
        }
        throw new LocalizableRuntimeException(this.lex.module.getModuleName(), "pointDeviceExt.delete");
    }

    public void doDeleteAllPoints() {
        this.removeAll(deletePoints);
    }

    public void doAddAllPoints() {
        int n = ((BWirelessStatDevice)this.getDevice()).getThermostatFirmwareNumber();
        XElem[] xElemArray = XWirelessStatFile.getPointListFromModelNumber(n);
        this.createAllDevicePoints(xElemArray);
    }

    private final BComponent configurePoint(BControlPoint bControlPoint, BFacets bFacets, BStatusValue bStatusValue) {
        return this.configurePoint(bControlPoint, bFacets, bStatusValue, false);
    }

    private final BComponent configurePoint(BControlPoint bControlPoint, BFacets bFacets, BStatusValue bStatusValue, boolean bl) {
        Object object = new BNullProxyExt();
        if (bControlPoint instanceof BBooleanWritable) {
            object = new BWirelessStatBooleanProxyExt();
            ((BBooleanWritable)bControlPoint).setFallback((BStatusBoolean)bStatusValue);
        } else if (bControlPoint instanceof BBooleanPoint) {
            object = new BWirelessStatBooleanProxyExt();
        } else if (bControlPoint instanceof BNumericWritable) {
            object = bl ? new BWirelessStatNumericSensorProxyExt() : new BWirelessStatNumericProxyExt();
            ((BNumericWritable)bControlPoint).setFallback((BStatusNumeric)bStatusValue);
        } else if (bControlPoint instanceof BNumericPoint) {
            object = new BWirelessStatNumericProxyExt();
        } else if (bControlPoint instanceof BEnumWritable) {
            object = new BWirelessStatEnumProxyExt();
            ((BEnumWritable)bControlPoint).setFallback((BStatusEnum)bStatusValue);
        } else if (bControlPoint instanceof BEnumPoint) {
            object = new BWirelessStatEnumProxyExt();
        }
        if (object instanceof BProxyExt) {
            bControlPoint.setFacets(bFacets);
            BFacets bFacets2 = (BFacets)bControlPoint.getFacets().newCopy();
            ((BProxyExt)object).setDeviceFacets(bFacets2);
        }
        bControlPoint.setProxyExt((BAbstractProxyExt)object);
        return bControlPoint;
    }

    private final void createAllDevicePoints(XElem[] xElemArray) {
        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)this.getDevice();
        BFacets bFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)-40.0, (double)122.0);
        bFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)-40.0, (double)122.0);
        BFacets bFacets2 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)40.0, (double)90.0);
        bFacets2 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)40.0, (double)90.0);
        BFacets bFacets3 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)54.0, (double)100.0);
        bFacets3 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1, (double)54.0, (double)100.0);
        BFacets bFacets4 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent"), (int)1, (double)0.0, (double)100.0);
        BFacets bFacets5 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent"), (int)1, (double)10.0, (double)90.0);
        BFacets bFacets6 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent"), (int)1, (double)10.0, (double)90.0);
        BFacets bFacets7 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent"), (int)1, (double)15.0, (double)95.0);
        BFacets bFacets8 = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent"), (int)1, (double)50.0, (double)90.0);
        int n = 0;
        while (n < xElemArray.length) {
            BFacets bFacets9;
            BFacets bFacets10;
            BNumericWritable bNumericWritable;
            String string = xElemArray[n].get("name");
            if (string.equals("RoomTemp")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets.newCopy(), (BStatusValue)new BStatusNumeric(-40.0), true);
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("OutdoorTemp")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets.newCopy(), (BStatusValue)new BStatusNumeric(-40.0), true);
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("OccCoolSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets3.newCopy(), (BStatusValue)new BStatusNumeric(75.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("OccHeatSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets2.newCopy(), (BStatusValue)new BStatusNumeric(72.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("UnOccCoolSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets3.newCopy(), (BStatusValue)new BStatusNumeric(82.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("UnOccHeatSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets2.newCopy(), (BStatusValue)new BStatusNumeric(65.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("StandByCoolSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets3.newCopy(), (BStatusValue)new BStatusNumeric(78.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("StandByHeatSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets2.newCopy(), (BStatusValue)new BStatusNumeric(69.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("RoomHumidity")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, (BFacets)bFacets5.newCopy(), (BStatusValue)new BStatusNumeric(0.0), true);
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SupplyTemp")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets, (BStatusValue)new BStatusNumeric(-40.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("PIHeatingDemand")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("PICoolingDemand")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("BI1Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("BI2Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("AuxStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("AuxCommand")) {
                bNumericWritable = new BBooleanWritable();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("DI2Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("DI1Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("W1Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("Y1Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("Y2Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("GFanStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("AuxStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("EconomizerOutput")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("W2Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("ReversingValveStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("DehumidStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"On", (String)"Off");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("DehumidLockout")) {
                bNumericWritable = new BBooleanWritable();
                bFacets10 = BFacets.makeBoolean((String)"Enabled", (String)"Disabled");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("EffectiveOccupancy")) {
                bNumericWritable = new BEnumPoint();
                bFacets10 = BEnumRange.make((Type)BEffectiveOccupancyEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("OccupancyCommand")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = BEnumRange.make((Type)BOccupancyCommandEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("FanMode")) {
                if (bWirelessStatDevice.isVT76Device()) {
                    bNumericWritable = new BEnumWritable();
                    bFacets10 = BEnumRange.make((Type)BFanModeHeatPumpRoofTopEnum.TYPE);
                    bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                    this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(2)));
                    bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
                } else {
                    bNumericWritable = new BEnumWritable();
                    bFacets10 = BEnumRange.make((Type)BFanModeFcuEnum.TYPE);
                    bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                    this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(3)));
                    bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
                }
            } else if (string.equals("FanStatus")) {
                bNumericWritable = new BEnumPoint();
                bFacets10 = BEnumRange.make((Type)BFanStatusEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("Alarms")) {
                if (bWirelessStatDevice.isVT76Device()) {
                    bNumericWritable = new BEnumPoint();
                    bFacets10 = BEnumRange.make((Type)BAlarmHeatPumpRoofTopEnum.TYPE);
                    bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                    this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                    bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
                } else {
                    bNumericWritable = new BEnumPoint();
                    bFacets10 = BEnumRange.make((Type)BAlarmFcuEnum.TYPE);
                    bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                    this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                    bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
                }
            } else if (string.equals("KeypadLockout")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = bWirelessStatDevice.isVT76Device() ? BEnumRange.make((Type)BKeypadLookoutEnum.TYPE) : BEnumRange.make((Type)BKeypadLookoutFcuEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SequenceOfOperation")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = BEnumRange.make((Type)BSequenceOfOperationEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(2)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("UI3Status")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SystemMode")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = BEnumRange.make((Type)BSystemModeEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(2)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("HeatValveStatus")) {
                bNumericWritable = new BEnumPoint();
                bFacets10 = BEnumRange.make((Type)BHeatingValvesEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("CoolValveStatus")) {
                bNumericWritable = new BEnumPoint();
                bFacets10 = BEnumRange.make((Type)BCoolingValvesEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SystemModeHPU")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = BEnumRange.make((Type)BSystemModeHPEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SystemModeRTU")) {
                bNumericWritable = new BEnumWritable();
                bFacets10 = BEnumRange.make((Type)BSystemModeEnum.TYPE);
                bFacets9 = BFacets.makeEnum((BEnumRange)bFacets10);
                this.configurePoint((BControlPoint)bNumericWritable, bFacets9, (BStatusValue)new BStatusEnum(bFacets10.get(1)));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("PIRMotionStatus")) {
                bNumericWritable = new BBooleanPoint();
                bFacets10 = BFacets.makeBoolean((String)"Activated", (String)"Deactivated");
                this.configurePoint((BControlPoint)bNumericWritable, bFacets10, (BStatusValue)new BStatusBoolean(false));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("HumidifierOutput")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("EffectiveHumidificationRHSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("SupplyRH")) {
                bNumericWritable = new BNumericPoint();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets4, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("DehumidRHSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets7, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("HumidificationRHSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets6, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else if (string.equals("HumidificationHighLimitSetpoint")) {
                bNumericWritable = new BNumericWritable();
                this.configurePoint((BControlPoint)bNumericWritable, bFacets8, (BStatusValue)new BStatusNumeric(0.0));
                bWirelessStatDevice.getPoints().add(string, (BValue)bNumericWritable, addPoints);
            } else {
                throw new BasicException("No info to create point named " + string);
            }
            ++n;
        }
    }

    public void updateEnumSetpoints(int n, BEnumWritable bEnumWritable) {
        StringBuffer stringBuffer = new StringBuffer();
        BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)bEnumWritable.getParent().getParent();
        if (bEnumWritable.getName().equals("EffectiveOccupancy") || bEnumWritable.getName().equals("KeypadLockout") || bEnumWritable.getName().equals("OccupancyCommand")) {
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("EffectiveOccupancy")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("KeypadLockout")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            int n2 = (int)((BWirelessStatProxyExt)((BControlPoint)this.get("Alarms")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1;
            if (!bWirelessStatDevice.isVT76Device()) {
                switch ((int)((BWirelessStatProxyExt)((BControlPoint)this.get("Alarms")).getProxyExt()).getInt((BControlPoint)bEnumWritable)) {
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = 128;
                        break;
                    }
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        n2 = 8;
                        break;
                    }
                    case 5: {
                        n2 = 132;
                        break;
                    }
                    case 6: {
                        n2 = 136;
                        break;
                    }
                    case 7: {
                        n2 = 12;
                        break;
                    }
                }
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(n2));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("OccupancyCommand")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0102", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        } else if (bEnumWritable.getName().equals("FanMode") && !bWirelessStatDevice.isVT76Device()) {
            int n3 = (int)((BWirelessStatProxyExt)((BControlPoint)this.get("FanMode")).getProxyExt()).getInt((BControlPoint)bEnumWritable);
            int n4 = 0;
            switch (n3) {
                case 1: {
                    n4 = 3;
                    break;
                }
                case 2: {
                    n4 = 4;
                    break;
                }
                case 3: {
                    n4 = 0;
                    break;
                }
                case 4: {
                    n4 = 1;
                    break;
                }
                case 5: {
                    n4 = 2;
                    break;
                }
                default: {
                    n4 = 1;
                }
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(n4));
            stringBuffer.append("FF");
            stringBuffer.append("FF");
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0201", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        } else if (bEnumWritable.getName().equals("SystemMode") || bEnumWritable.getName().equals("SequenceOfOperation") && !bWirelessStatDevice.isVT76Device()) {
            BWirelessStatDevice bWirelessStatDevice2 = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(bWirelessStatDevice2.getStatusBit()));
            stringBuffer.append("FFFF");
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SystemMode")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SequenceOfOperation")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0203", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        } else if (bEnumWritable.getName().equals("SystemModeHPU")) {
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SystemModeHPU")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            boolean bl = false;
            if (((BWirelessStatProxyExt)((BControlPoint)this.get("ReversingValveStatus")).getProxyExt()).getBoolean((BControlPoint)bEnumWritable)) {
                bl = true;
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex((float)bl));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0204", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        } else if (bEnumWritable.getName().equals("FanMode") && bWirelessStatDevice.isVT76Device()) {
            BWirelessStatDevice bWirelessStatDevice3 = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(bWirelessStatDevice3.getStatusBit()));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("FanMode")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0205", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        } else if (bEnumWritable.getName().equals("SystemModeRTU")) {
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SystemModeRTU")).getProxyExt()).getInt((BControlPoint)bEnumWritable) - 1.0f));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0206", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bEnumWritable.getProxyExt());
        }
        stringBuffer = null;
    }

    public void updateBoolSetpoints(int n, BBooleanWritable bBooleanWritable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bBooleanWritable.getName().equals("DehumidLockout")) {
            boolean bl = ((BWirelessStatNumericSensorProxyExt)((BNumericWritable)this.get("RoomHumidity")).getProxyExt()).getOutOfService();
            if (bl) {
                BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                if (bWirelessStatDevice.isVT76Device()) {
                    stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("RoomHumidity")).getProxyExt()).getInt((BControlPoint)bBooleanWritable) * 10.0f));
                } else {
                    stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("RoomHumidity")).getProxyExt()).getInt((BControlPoint)bBooleanWritable)));
                }
            } else {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            }
            boolean bl2 = false;
            if (((BWirelessStatProxyExt)((BControlPoint)this.get("DehumidStatus")).getProxyExt()).getBoolean((BControlPoint)bBooleanWritable)) {
                bl2 = true;
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex((float)bl2));
            boolean bl3 = false;
            if (((BWirelessStatProxyExt)((BControlPoint)this.get("DehumidLockout")).getProxyExt()).getBoolean((BControlPoint)bBooleanWritable)) {
                bl3 = true;
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex((float)bl3));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(bl ? 128 : 0));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0200", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bBooleanWritable.getProxyExt());
        } else if (bBooleanWritable.getName().equals("AuxCommand")) {
            BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
            if (((BWirelessStatProxyExt)((BControlPoint)this.get("AuxCommand")).getProxyExt()).getBoolean((BControlPoint)bBooleanWritable)) {
                bWirelessStatDevice.setStatusBit(bWirelessStatDevice.getStatusBit() | 8);
            } else {
                bWirelessStatDevice.setStatusBit(bWirelessStatDevice.getStatusBit() & 7);
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(bWirelessStatDevice.getStatusBit()));
            stringBuffer.append("FFFF");
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SystemMode")).getProxyExt()).getInt((BControlPoint)bBooleanWritable) - 1.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("SequenceOfOperation")).getProxyExt()).getInt((BControlPoint)bBooleanWritable) - 1.0f));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0203", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bBooleanWritable.getProxyExt());
        }
        stringBuffer = null;
    }

    public void updateNumericSetpoints(int n, BNumericWritable bNumericWritable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bNumericWritable.getName().equals("OccCoolSetpoint") || bNumericWritable.getName().equals("OccHeatSetpoint") || bNumericWritable.getName().equals("UnOccCoolSetpoint") || bNumericWritable.getName().equals("UnOccHeatSetpoint") || bNumericWritable.getName().equals("StandByCoolSetpoint") || bNumericWritable.getName().equals("StandByHeatSetpoint")) {
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("OccCoolSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("OccHeatSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("UnOccCoolSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("UnOccHeatSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            if (this.get("StandByCoolSetpoint") != null) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("StandByCoolSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            } else {
                stringBuffer.append("7FFF");
            }
            if (this.get("StandByHeatSetpoint") != null) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("StandByHeatSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            } else {
                stringBuffer.append("7FFF");
            }
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0101", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bNumericWritable.getProxyExt());
        }
        if (bNumericWritable.getName().equals("DehumidRHSetpoint") || bNumericWritable.getName().equals("HumidificationRHSetpoint") || bNumericWritable.getName().equals("HumidificationHighLimitSetpoint")) {
            if (this.get("DehumidRHSetpoint") != null) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("DehumidRHSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            }
            if (this.get("HumidificationRHSetpoint") != null) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("HumidificationRHSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            }
            if (this.get("HumidificationHighLimitSetpoint") != null) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("HumidificationHighLimitSetpoint")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            }
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "020D", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bNumericWritable.getProxyExt());
        }
        stringBuffer = null;
    }

    public void updateNumericExternals(int n, BNumericWritable bNumericWritable) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        if (bNumericWritable.getName().equals("RoomTemp") || bNumericWritable.getName().equals("OutdoorTemp")) {
            bl = ((BWirelessStatNumericSensorProxyExt)((BNumericWritable)this.get("RoomTemp")).getProxyExt()).getOutOfService();
            boolean bl2 = ((BWirelessStatNumericSensorProxyExt)((BNumericWritable)this.get("OutdoorTemp")).getProxyExt()).getOutOfService();
            if (bl) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("RoomTemp")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            } else {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            }
            if (bl2) {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("OutdoorTemp")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
            } else {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex((bl ? 128 : 0) | (bl2 ? 64 : 0)));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0100", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bNumericWritable.getProxyExt());
        }
        if (bNumericWritable.getName().equals("RoomHumidity")) {
            bl = ((BWirelessStatNumericSensorProxyExt)((BNumericWritable)this.get("RoomHumidity")).getProxyExt()).getOutOfService();
            if (bl) {
                BWirelessStatDevice bWirelessStatDevice = (BWirelessStatDevice)BWirelessStatNetwork.devArray[n];
                if (bWirelessStatDevice.isVT76Device()) {
                    stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("RoomHumidity")).getProxyExt()).getInt((BControlPoint)bNumericWritable) * 10.0f));
                } else {
                    stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(((BWirelessStatProxyExt)((BControlPoint)this.get("RoomHumidity")).getProxyExt()).getInt((BControlPoint)bNumericWritable)));
                }
            } else {
                stringBuffer.append(BWirelessStatPointDeviceExt.wordToHex(32767.0f));
            }
            boolean bl3 = false;
            if (((BWirelessStatProxyExt)((BControlPoint)this.get("DehumidStatus")).getProxyExt()).getBoolean((BControlPoint)bNumericWritable)) {
                bl3 = true;
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex((float)bl3));
            int n2 = 0;
            if (this.get("DehumidLockout") != null) {
                if (((BWirelessStatProxyExt)((BControlPoint)this.get("DehumidLockout")).getProxyExt()).getBoolean((BControlPoint)bNumericWritable)) {
                    n2 = 1;
                }
            } else {
                n2 = 255;
            }
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(n2));
            stringBuffer.append(BWirelessStatPointDeviceExt.byteToHex(bl ? 128 : 0));
            BWirelessStatReplyParser.dataOutReplyReq((BWirelessStatNetwork)this.getNetwork(), "0200", "02", n, BWirelessStatNetwork.makeTransString(), stringBuffer.toString(), (BWirelessStatProxyExt)bNumericWritable.getProxyExt());
        }
        stringBuffer = null;
    }

    public static String wordToHex(float f) {
        int n = (int)f;
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            String string = Integer.toHexString(n);
            stringBuffer.append(string.substring(string.length() - 4, string.length()));
        } else if (n <= 4095) {
            if (n <= 255) {
                if (n <= 15) {
                    stringBuffer.append("000" + Integer.toHexString(n));
                } else {
                    stringBuffer.append("00" + Integer.toHexString(n));
                }
            } else {
                stringBuffer.append("0" + Integer.toHexString(n));
            }
        } else {
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    public static String byteToHex(float f) {
        StringBuffer stringBuffer = new StringBuffer();
        if (f < 0.0f) {
            String string = Integer.toHexString((int)f);
            stringBuffer.append(string.substring(string.length() - 2, string.length()));
        } else if (f < 16.0f) {
            stringBuffer.append("0" + Integer.toHexString((int)f));
        } else {
            stringBuffer.append(Integer.toHexString((int)f));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$viconics$wireless$BWirelessStatDevice;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$BWirelessStatDevice = BWirelessStatPointDeviceExt.class("[Lcom.viconics.wireless.BWirelessStatDevice;", false);
        }
        this.lex = Lexicon.make((Class)clazz);
    }

    public BWirelessStatPointDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$viconics$wireless$point$BWirelessStatPointDeviceExt;
        if (clazz == null) {
            clazz = class$com$viconics$wireless$point$BWirelessStatPointDeviceExt = BWirelessStatPointDeviceExt.class("[Lcom.viconics.wireless.point.BWirelessStatPointDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        deletePoints = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.deletePoints";
            }
        };
        addPoints = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.addPoints";
            }
        };
    }
}

