/*
 * Decompiled with CFR 0.152.
 */
package com.viconics.wireless.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.viconics.wireless.messages.WirelessStatMessage;
import com.viconics.wireless.messages.WirelessStatOutputStream;
import com.viconics.wireless.messages.WirelessStatReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;

public class WirelessStatReadRequest
extends WirelessStatMessage {
    private byte[] data;

    public byte[] getBytes() {
        return this.data;
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        return (WirelessStatReceivedMessage)receivedMessage;
    }

    public void write(OutputStream outputStream) {
        try {
            WirelessStatOutputStream wirelessStatOutputStream = new WirelessStatOutputStream();
            wirelessStatOutputStream.write(this.data);
            outputStream.write(wirelessStatOutputStream.toByteArray());
            wirelessStatOutputStream = null;
        }
        catch (IOException iOException) {
            System.out.println("IO Exception writing wireless message!");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = WirelessStatReadRequest.byteArrayToHexString(this.data);
        stringBuffer.append("\nMsg Length: " + string.substring(2, 4));
        stringBuffer.append(" Msg Type: " + string.substring(4, 8));
        stringBuffer.append(" Cmd Type: " + this.cmdTypeToStr(string.substring(8, 10)));
        stringBuffer.append(" Address:  " + Integer.valueOf(string.substring(10, 12), 16));
        stringBuffer.append(" TransSeq: " + string.substring(12, 14));
        stringBuffer.append(" Data: " + string.substring(14, string.length()) + '\n');
        return stringBuffer.toString();
    }

    String cmdTypeToStr(String string) {
        if (string.equalsIgnoreCase("00")) {
            return " R";
        }
        if (string.equalsIgnoreCase("01")) {
            return "RR";
        }
        if (string.equalsIgnoreCase("02")) {
            return " W";
        }
        if (string.equalsIgnoreCase("03")) {
            return "WR";
        }
        return "??";
    }

    static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        int n = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        while (n < byArray.length) {
            by = (byte)(byArray[n] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(stringArray[by]);
            by = (byte)(byArray[n] & 0xF);
            stringBuffer.append(stringArray[by]);
            ++n;
        }
        String string = new String(stringBuffer);
        return string;
    }

    public WirelessStatReadRequest() {
    }

    public WirelessStatReadRequest(byte[] byArray, int n) {
        this.data = byArray;
    }

    public WirelessStatReadRequest(String string) {
        this.data = string.getBytes();
    }
}

